/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.amqp_1_0.codec;

import java.nio.ByteBuffer;
import org.apache.qpid.amqp_1_0.codec.TypeConstructor;
import org.apache.qpid.amqp_1_0.codec.ValueHandler;
import org.apache.qpid.amqp_1_0.type.AmqpErrorException;
import org.apache.qpid.amqp_1_0.type.transport.ConnectionError;
import org.apache.qpid.amqp_1_0.type.transport.Error;

public class LongTypeConstructor
implements TypeConstructor {
    private static final LongTypeConstructor INSTANCE = new LongTypeConstructor();

    public static LongTypeConstructor getInstance() {
        return INSTANCE;
    }

    private LongTypeConstructor() {
    }

    public Object construct(ByteBuffer in, ValueHandler handler) throws AmqpErrorException {
        if (in.remaining() >= 8) {
            return in.getLong();
        }
        Error error = new Error();
        error.setCondition(ConnectionError.FRAMING_ERROR);
        error.setDescription("Cannot construct long: insufficient input data");
        throw new AmqpErrorException(error);
    }
}

