/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.io.rabbitmq;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import com.google.common.base.Preconditions;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.Map;
import org.apache.pulsar.io.core.annotations.FieldDoc;
import org.apache.pulsar.io.rabbitmq.RabbitMQAbstractConfig;

public class RabbitMQSourceConfig
extends RabbitMQAbstractConfig
implements Serializable {
    private static final long serialVersionUID = 1L;
    @FieldDoc(required=true, defaultValue="", help="The RabbitMQ queue name from which messages should be read from or written to")
    private String queueName;
    @FieldDoc(required=false, defaultValue="0", help="Maximum number of messages that the server will deliver, 0 for unlimited")
    private int prefetchCount = 0;
    @FieldDoc(required=false, defaultValue="false", help="Set true if the settings should be applied to the entire channel rather than each consumer")
    private boolean prefetchGlobal = false;
    @FieldDoc(required=false, defaultValue="false", help="Set true if the queue should be declared passively - ie to preserve durability/timeout settings")
    private boolean passive = false;

    public static RabbitMQSourceConfig load(String yamlFile) throws IOException {
        ObjectMapper mapper = new ObjectMapper((JsonFactory)new YAMLFactory());
        return (RabbitMQSourceConfig)mapper.readValue(new File(yamlFile), RabbitMQSourceConfig.class);
    }

    public static RabbitMQSourceConfig load(Map<String, Object> map) throws IOException {
        ObjectMapper mapper = new ObjectMapper();
        return (RabbitMQSourceConfig)mapper.readValue(mapper.writeValueAsString(map), RabbitMQSourceConfig.class);
    }

    @Override
    public void validate() {
        super.validate();
        Preconditions.checkNotNull((Object)this.queueName, (Object)"queueName property not set.");
        Preconditions.checkArgument((this.prefetchCount >= 0 ? 1 : 0) != 0, (Object)"prefetchCount must be non-negative.");
    }

    @Override
    public String getQueueName() {
        return this.queueName;
    }

    public int getPrefetchCount() {
        return this.prefetchCount;
    }

    public boolean isPrefetchGlobal() {
        return this.prefetchGlobal;
    }

    public boolean isPassive() {
        return this.passive;
    }

    @Override
    public RabbitMQSourceConfig setQueueName(String queueName) {
        this.queueName = queueName;
        return this;
    }

    public RabbitMQSourceConfig setPrefetchCount(int prefetchCount) {
        this.prefetchCount = prefetchCount;
        return this;
    }

    public RabbitMQSourceConfig setPrefetchGlobal(boolean prefetchGlobal) {
        this.prefetchGlobal = prefetchGlobal;
        return this;
    }

    public RabbitMQSourceConfig setPassive(boolean passive) {
        this.passive = passive;
        return this;
    }

    @Override
    public String toString() {
        return "RabbitMQSourceConfig(queueName=" + this.getQueueName() + ", prefetchCount=" + this.getPrefetchCount() + ", prefetchGlobal=" + this.isPrefetchGlobal() + ", passive=" + this.isPassive() + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RabbitMQSourceConfig)) {
            return false;
        }
        RabbitMQSourceConfig other = (RabbitMQSourceConfig)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getPrefetchCount() != other.getPrefetchCount()) {
            return false;
        }
        if (this.isPrefetchGlobal() != other.isPrefetchGlobal()) {
            return false;
        }
        if (this.isPassive() != other.isPassive()) {
            return false;
        }
        String this$queueName = this.getQueueName();
        String other$queueName = other.getQueueName();
        return !(this$queueName == null ? other$queueName != null : !this$queueName.equals(other$queueName));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof RabbitMQSourceConfig;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getPrefetchCount();
        result = result * 59 + (this.isPrefetchGlobal() ? 79 : 97);
        result = result * 59 + (this.isPassive() ? 79 : 97);
        String $queueName = this.getQueueName();
        result = result * 59 + ($queueName == null ? 43 : $queueName.hashCode());
        return result;
    }
}

