/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.io.nsq;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.pulsar.io.core.annotations.FieldDoc;

public class NSQSourceConfig
implements Serializable {
    private static final long serialVersionUID = 1L;
    @FieldDoc(required=true, defaultValue="", help="The topic you wish to transport into pulsar")
    private String topic;
    @FieldDoc(required=false, defaultValue="pulsar-transport-<topic>", help="The channel to use on the topic you want to transport")
    private String channel;
    @FieldDoc(required=true, defaultValue="", help="A comma-separated list of nsqlookupd hosts to contact")
    private String lookupds;

    public static NSQSourceConfig load(String yamlFile) throws IOException {
        ObjectMapper mapper = new ObjectMapper((JsonFactory)new YAMLFactory());
        return NSQSourceConfig.applyDefaults((NSQSourceConfig)mapper.readValue(new File(yamlFile), NSQSourceConfig.class));
    }

    public static NSQSourceConfig load(Map<String, Object> map) throws IOException {
        ObjectMapper mapper = new ObjectMapper();
        return NSQSourceConfig.applyDefaults((NSQSourceConfig)mapper.readValue(mapper.writeValueAsString(map), NSQSourceConfig.class));
    }

    private static NSQSourceConfig applyDefaults(NSQSourceConfig config) {
        if (config.channel == null) {
            config.channel = String.format("pulsar-transport-%s", config.topic);
        }
        return config;
    }

    public void validate() throws IllegalArgumentException {
        if (this.getChannel() == null) {
            this.setChannel(String.format("pulsar-transport-%s", this.getTopic()));
        }
        if (this.getTopic() == null || this.getLookupds() == null || this.getChannel() == null) {
            throw new IllegalArgumentException("Required property not set.");
        }
    }

    public List<String> getLookupds() {
        if (StringUtils.isBlank((CharSequence)this.lookupds)) {
            return Collections.emptyList();
        }
        ArrayList<String> out = new ArrayList<String>();
        for (String s : StringUtils.split((String)this.lookupds, (String)",")) {
            out.add(StringUtils.trim((String)s));
        }
        if (CollectionUtils.isEmpty(out)) {
            return Collections.emptyList();
        }
        return out;
    }

    public String getTopic() {
        return this.topic;
    }

    public String getChannel() {
        return this.channel;
    }

    public NSQSourceConfig setTopic(String topic) {
        this.topic = topic;
        return this;
    }

    public NSQSourceConfig setChannel(String channel) {
        this.channel = channel;
        return this;
    }

    public NSQSourceConfig setLookupds(String lookupds) {
        this.lookupds = lookupds;
        return this;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof NSQSourceConfig)) {
            return false;
        }
        NSQSourceConfig other = (NSQSourceConfig)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$topic = this.getTopic();
        String other$topic = other.getTopic();
        if (this$topic == null ? other$topic != null : !this$topic.equals(other$topic)) {
            return false;
        }
        String this$channel = this.getChannel();
        String other$channel = other.getChannel();
        if (this$channel == null ? other$channel != null : !this$channel.equals(other$channel)) {
            return false;
        }
        List<String> this$lookupds = this.getLookupds();
        List<String> other$lookupds = other.getLookupds();
        return !(this$lookupds == null ? other$lookupds != null : !((Object)this$lookupds).equals(other$lookupds));
    }

    protected boolean canEqual(Object other) {
        return other instanceof NSQSourceConfig;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $topic = this.getTopic();
        result = result * 59 + ($topic == null ? 43 : $topic.hashCode());
        String $channel = this.getChannel();
        result = result * 59 + ($channel == null ? 43 : $channel.hashCode());
        List<String> $lookupds = this.getLookupds();
        result = result * 59 + ($lookupds == null ? 43 : ((Object)$lookupds).hashCode());
        return result;
    }

    public String toString() {
        return "NSQSourceConfig(topic=" + this.getTopic() + ", channel=" + this.getChannel() + ", lookupds=" + this.getLookupds() + ")";
    }
}

