/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.io.hdfs3.sink.seq;

import java.io.IOException;
import java.util.List;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.SequenceFile;
import org.apache.hadoop.io.Text;
import org.apache.pulsar.functions.api.Record;
import org.apache.pulsar.io.core.KeyValue;
import org.apache.pulsar.io.hdfs3.sink.seq.HdfsAbstractSequenceFileSink;

public class HdfsSequentialTextSink
extends HdfsAbstractSequenceFileSink<Long, String, LongWritable, Text> {
    private AtomicLong counter;

    @Override
    public SequenceFile.Writer getWriter() throws IOException {
        this.counter = new AtomicLong(0L);
        return SequenceFile.createWriter((Configuration)this.getConfiguration(), (SequenceFile.Writer.Option[])this.getOptions().toArray(new SequenceFile.Writer.Option[this.getOptions().size()]));
    }

    @Override
    protected List<SequenceFile.Writer.Option> getOptions() throws IllegalArgumentException, IOException {
        List<SequenceFile.Writer.Option> opts = super.getOptions();
        opts.add(SequenceFile.Writer.keyClass(LongWritable.class));
        opts.add(SequenceFile.Writer.valueClass(Text.class));
        return opts;
    }

    @Override
    public KeyValue<Long, String> extractKeyValue(Record<String> record) {
        Long sequence = record.getRecordSequence().orElseGet(() -> this.counter.incrementAndGet());
        return new KeyValue((Object)sequence, (Object)((String)record.getValue()));
    }

    @Override
    public KeyValue<LongWritable, Text> convert(KeyValue<Long, String> kv) {
        return new KeyValue((Object)new LongWritable(((Long)kv.getKey()).longValue()), (Object)new Text((String)kv.getValue()));
    }
}

