/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.io.elasticsearch.client.opensearch;

import java.util.Iterator;
import java.util.NoSuchElementException;
import org.apache.pulsar.io.elasticsearch.RandomExponentialRetry;
import org.opensearch.action.bulk.BackoffPolicy;
import org.opensearch.common.unit.TimeValue;

public class RandomExponentialBackoffPolicy
extends BackoffPolicy {
    private final RandomExponentialRetry randomExponentialRetry;
    private final long start;
    private final int numberOfElements;

    public RandomExponentialBackoffPolicy(RandomExponentialRetry randomExponentialRetry, long start, int numberOfElements) {
        this.randomExponentialRetry = randomExponentialRetry;
        assert (start >= 0L);
        assert (numberOfElements >= -1);
        this.start = start;
        this.numberOfElements = numberOfElements;
    }

    public Iterator<TimeValue> iterator() {
        return new RandomExponentialBackoffIterator(this.start, this.numberOfElements);
    }

    class RandomExponentialBackoffIterator
    implements Iterator<TimeValue> {
        private final int numberOfElements;
        private final long start;
        private int currentlyConsumed;

        RandomExponentialBackoffIterator(long start, int numberOfElements) {
            this.start = start;
            this.numberOfElements = numberOfElements;
        }

        @Override
        public boolean hasNext() {
            return this.numberOfElements == -1 || this.currentlyConsumed < this.numberOfElements;
        }

        @Override
        public TimeValue next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException("Only up to " + this.numberOfElements + " elements");
            }
            long result = RandomExponentialBackoffPolicy.this.randomExponentialRetry.randomWaitInMs(this.currentlyConsumed, this.start);
            ++this.currentlyConsumed;
            return TimeValue.timeValueMillis((long)result);
        }
    }
}

