/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.common.util;

import java.util.Objects;
import java.util.concurrent.Delayed;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.RunnableScheduledFuture;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import lombok.Generated;
import org.apache.pulsar.shade.io.netty.util.concurrent.DefaultThreadFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SingleThreadNonConcurrentFixedRateScheduler
extends ScheduledThreadPoolExecutor
implements ScheduledExecutorService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SingleThreadNonConcurrentFixedRateScheduler.class);
    private static final AtomicLong fixRateTaskSequencerGenerator = new AtomicLong();
    private static final RejectedExecutionHandler defaultRejectedExecutionHandler = new ThreadPoolExecutor.AbortPolicy();
    private volatile RejectedExecutionHandler rejectedExecutionHandler = defaultRejectedExecutionHandler;

    public SingleThreadNonConcurrentFixedRateScheduler(String name) {
        super(1, new DefaultThreadFactory(name));
        super.setContinueExistingPeriodicTasksAfterShutdownPolicy(false);
        super.setExecuteExistingDelayedTasksAfterShutdownPolicy(false);
        super.setRemoveOnCancelPolicy(false);
        this.submit(() -> {});
    }

    @Override
    public ScheduledFuture<?> schedule(Runnable command, long delay, TimeUnit unit) {
        return super.schedule(new SafeRunnable(command), delay, unit);
    }

    @Override
    public ScheduledFuture<?> scheduleWithFixedDelay(Runnable command, long initialDelay, long delay, TimeUnit unit) {
        return super.scheduleWithFixedDelay(new SafeRunnable(command), initialDelay, delay, unit);
    }

    @Override
    public ScheduledFuture<?> scheduleAtFixedRate(Runnable command, long initialDelay, long period, TimeUnit unit) {
        return super.scheduleAtFixedRate(new SafeRunnable(command), initialDelay, period, unit);
    }

    @Override
    public Future<?> submit(Runnable task) {
        return super.submit(new SafeRunnable(task));
    }

    public ScheduledFuture<?> scheduleAtFixedRateNonConcurrently(Runnable command, long initialDelay, long period, TimeUnit unit) {
        if (command == null || unit == null) {
            throw new NullPointerException();
        }
        if (period <= 0L) {
            throw new IllegalArgumentException("period can not be null");
        }
        ScheduledFutureTask<Object> sft = new ScheduledFutureTask<Object>(command, null, this.triggerTime(initialDelay, unit), unit.toNanos(period), fixRateTaskSequencerGenerator.getAndIncrement());
        RunnableScheduledFuture<Object> t = this.decorateTask(command, sft);
        sft.outerTask = t;
        this.delayedExecute(t);
        return t;
    }

    private void delayedExecute(RunnableScheduledFuture<?> task) {
        if (this.isShutdown()) {
            this.reject(task);
        } else {
            super.getQueue().add(task);
            if (!this.canRunInCurrentRunState(task) && this.remove(task)) {
                task.cancel(false);
            }
        }
    }

    private void reject(Runnable command) {
        this.rejectedExecutionHandler.rejectedExecution(command, this);
    }

    private long triggerTime(long delay, TimeUnit unit) {
        return this.triggerTime(unit.toNanos(delay < 0L ? 0L : delay));
    }

    private long triggerTime(long delay) {
        return System.nanoTime() + (delay < 0x3FFFFFFFFFFFFFFFL ? delay : this.overflowFree(delay));
    }

    private long overflowFree(long delay) {
        long headDelay;
        Delayed head = (Delayed)super.getQueue().peek();
        if (head != null && (headDelay = head.getDelay(TimeUnit.NANOSECONDS)) < 0L && delay - headDelay < 0L) {
            delay = Long.MAX_VALUE + headDelay;
        }
        return delay;
    }

    @Override
    public void setContinueExistingPeriodicTasksAfterShutdownPolicy(boolean flag) {
        throw new IllegalArgumentException("Not support to set continueExistingPeriodicTasksAfterShutdownPolicy, it is always false");
    }

    @Override
    public boolean getContinueExistingPeriodicTasksAfterShutdownPolicy() {
        return false;
    }

    @Override
    public void setExecuteExistingDelayedTasksAfterShutdownPolicy(boolean flag) {
        throw new IllegalArgumentException("Not support to set executeExistingDelayedTasksAfterShutdownPolicy, it is always false");
    }

    @Override
    public boolean getExecuteExistingDelayedTasksAfterShutdownPolicy() {
        return false;
    }

    @Override
    public void setRemoveOnCancelPolicy(boolean value) {
        throw new IllegalArgumentException("Not support to set removeOnCancelPolicy, it is always false");
    }

    @Override
    public boolean getRemoveOnCancelPolicy() {
        return false;
    }

    @Override
    public void setRejectedExecutionHandler(RejectedExecutionHandler handler) {
        super.setRejectedExecutionHandler(handler);
        this.rejectedExecutionHandler = handler;
    }

    @Override
    public RejectedExecutionHandler getRejectedExecutionHandler() {
        return this.rejectedExecutionHandler;
    }

    private void reExecutePeriodic(RunnableScheduledFuture<?> task) {
        if (this.canRunInCurrentRunState(task)) {
            super.getQueue().add(task);
            return;
        }
        task.cancel(false);
    }

    private boolean canRunInCurrentRunState(RunnableScheduledFuture<?> task) {
        return !this.isShutdown();
    }

    private static final class SafeRunnable
    implements Runnable {
        private final Runnable task;

        SafeRunnable(Runnable task) {
            this.task = task;
        }

        @Override
        public void run() {
            try {
                this.task.run();
            }
            catch (Throwable t) {
                log.warn("Unexpected throwable from task {}: {}", new Object[]{this.task.getClass(), t.getMessage(), t});
            }
        }
    }

    private class ScheduledFutureTask<V>
    extends FutureTask<V>
    implements RunnableScheduledFuture<V> {
        private final long sequenceNumber;
        private volatile long time;
        private final long period;
        RunnableScheduledFuture<V> outerTask;

        ScheduledFutureTask(Runnable r, V result, long triggerTime, long period, long sequenceNumber) {
            super(r, result);
            this.outerTask = this;
            this.time = triggerTime;
            this.period = period;
            this.sequenceNumber = sequenceNumber;
        }

        public boolean equals(Object o) {
            if (!(o instanceof ScheduledFutureTask)) {
                return false;
            }
            ScheduledFutureTask that = (ScheduledFutureTask)o;
            return this.sequenceNumber == that.sequenceNumber && this.time == that.time && this.period == that.period && Objects.equals(this.outerTask, that.outerTask);
        }

        public int hashCode() {
            return Objects.hash(this.sequenceNumber, this.time, this.period, this.outerTask);
        }

        @Override
        public long getDelay(TimeUnit unit) {
            return unit.convert(this.time - System.nanoTime(), TimeUnit.NANOSECONDS);
        }

        @Override
        public int compareTo(Delayed other) {
            if (other == this) {
                return 0;
            }
            if (other instanceof ScheduledFutureTask) {
                ScheduledFutureTask x = (ScheduledFutureTask)other;
                long diff = this.time - x.time;
                if (diff < 0L) {
                    return -1;
                }
                if (diff > 0L) {
                    return 1;
                }
                if (this.sequenceNumber < x.sequenceNumber) {
                    return -1;
                }
                return 1;
            }
            long diff = this.getDelay(TimeUnit.NANOSECONDS) - other.getDelay(TimeUnit.NANOSECONDS);
            return diff < 0L ? -1 : (diff > 0L ? 1 : 0);
        }

        @Override
        public boolean isPeriodic() {
            return this.period != 0L;
        }

        private void setNextRunTime() {
            this.time = System.nanoTime() > this.time + this.period ? (this.time += ((System.nanoTime() - this.time) / this.period + 1L) * this.period) : (this.time += this.period);
        }

        @Override
        public boolean cancel(boolean mayInterruptIfRunning) {
            return super.cancel(mayInterruptIfRunning);
        }

        @Override
        public void run() {
            if (!SingleThreadNonConcurrentFixedRateScheduler.this.canRunInCurrentRunState(this)) {
                this.cancel(false);
            } else if (!this.isPeriodic()) {
                super.run();
            } else if (super.runAndReset()) {
                this.setNextRunTime();
                SingleThreadNonConcurrentFixedRateScheduler.this.reExecutePeriodic(this.outerTask);
            }
        }
    }
}

