/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.client.impl;

import java.net.InetSocketAddress;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import org.apache.pulsar.client.impl.PulsarClientSharedResourcesBuilderImpl;
import org.apache.pulsar.client.impl.conf.ClientConfigurationData;
import org.apache.pulsar.common.util.netty.DnsResolverUtil;
import org.apache.pulsar.common.util.netty.EventLoopUtil;
import org.apache.pulsar.shade.io.netty.channel.EventLoopGroup;
import org.apache.pulsar.shade.io.netty.resolver.AddressResolver;
import org.apache.pulsar.shade.io.netty.resolver.dns.DnsAddressResolverGroup;
import org.apache.pulsar.shade.io.netty.resolver.dns.DnsNameResolverBuilder;
import org.apache.pulsar.shade.io.netty.resolver.dns.DnsServerAddressStreamProvider;
import org.apache.pulsar.shade.io.netty.resolver.dns.SequentialDnsServerAddressStreamProvider;

public class DnsResolverGroupImpl
implements AutoCloseable {
    private final DnsAddressResolverGroup dnsAddressResolverGroup;

    public DnsResolverGroupImpl(ClientConfigurationData conf) {
        Optional<InetSocketAddress> bindAddress = Optional.ofNullable(conf.getDnsLookupBindAddress()).map(addr -> new InetSocketAddress((String)addr, conf.getDnsLookupBindPort()));
        Optional<DnsServerAddressStreamProvider> dnsServerAddresses = Optional.ofNullable(conf.getDnsServerAddresses()).filter(Predicate.not(List::isEmpty)).map(SequentialDnsServerAddressStreamProvider::new);
        this.dnsAddressResolverGroup = DnsResolverGroupImpl.createAddressResolverGroup(bindAddress, dnsServerAddresses);
    }

    public DnsResolverGroupImpl(PulsarClientSharedResourcesBuilderImpl.DnsResolverResourceConfig dnsConfig) {
        this.dnsAddressResolverGroup = this.createAddressResolverGroup(dnsConfig);
    }

    private DnsAddressResolverGroup createAddressResolverGroup(PulsarClientSharedResourcesBuilderImpl.DnsResolverResourceConfig dnsConfig) {
        DnsNameResolverBuilder dnsNameResolverBuilder = new DnsNameResolverBuilder().traceEnabled(dnsConfig.traceEnabled).channelType(EventLoopUtil.getDatagramChannelClass());
        if (dnsConfig.tcpFallbackEnabled || dnsConfig.tcpFallbackOnTimeoutEnabled) {
            dnsNameResolverBuilder.socketChannelType(EventLoopUtil.getClientSocketChannelClass(), dnsConfig.tcpFallbackOnTimeoutEnabled);
        }
        dnsNameResolverBuilder.ttl(dnsConfig.minTtl, dnsConfig.maxTtl).negativeTtl(dnsConfig.negativeTtl);
        if (dnsConfig.queryTimeoutMillis > -1L) {
            dnsNameResolverBuilder.queryTimeoutMillis(dnsConfig.queryTimeoutMillis);
        }
        if (dnsConfig.ndots > -1) {
            dnsNameResolverBuilder.ndots(dnsConfig.ndots);
        }
        if (dnsConfig.localAddress != null) {
            dnsNameResolverBuilder.localAddress(dnsConfig.localAddress);
        }
        if (dnsConfig.serverAddresses != null) {
            Optional.ofNullable(dnsConfig.serverAddresses).map(SequentialDnsServerAddressStreamProvider::new).ifPresent(dnsServerAddressStreamProvider -> dnsNameResolverBuilder.nameServerProvider((DnsServerAddressStreamProvider)dnsServerAddressStreamProvider));
        }
        if (dnsConfig.searchDomains != null) {
            dnsNameResolverBuilder.searchDomains(dnsConfig.searchDomains);
        }
        return new DnsAddressResolverGroup(dnsNameResolverBuilder);
    }

    private static DnsAddressResolverGroup createAddressResolverGroup(Optional<InetSocketAddress> bindAddress, Optional<DnsServerAddressStreamProvider> dnsServerAddresses) {
        DnsNameResolverBuilder dnsNameResolverBuilder = DnsResolverGroupImpl.createDnsNameResolverBuilder();
        bindAddress.ifPresent(dnsNameResolverBuilder::localAddress);
        dnsServerAddresses.ifPresent(dnsNameResolverBuilder::nameServerProvider);
        return new DnsAddressResolverGroup(dnsNameResolverBuilder);
    }

    private static DnsNameResolverBuilder createDnsNameResolverBuilder() {
        DnsNameResolverBuilder dnsNameResolverBuilder = new DnsNameResolverBuilder().traceEnabled(true).channelType(EventLoopUtil.getDatagramChannelClass()).socketChannelType(EventLoopUtil.getClientSocketChannelClass(), true);
        DnsResolverUtil.applyJdkDnsCacheSettings(dnsNameResolverBuilder);
        return dnsNameResolverBuilder;
    }

    @Override
    public void close() {
        this.dnsAddressResolverGroup.close();
    }

    public AddressResolver<InetSocketAddress> createAddressResolver(EventLoopGroup eventLoopGroup) {
        return this.dnsAddressResolverGroup.getResolver(eventLoopGroup.next());
    }
}

