/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.common.api.proto;

import org.apache.pulsar.common.api.proto.LightProtoCodec;
import org.apache.pulsar.common.api.proto.Schema;
import org.apache.pulsar.common.api.proto.ServerError;
import org.apache.pulsar.shade.io.netty.buffer.ByteBuf;
import org.apache.pulsar.shade.io.netty.buffer.Unpooled;

public final class CommandGetSchemaResponse {
    private long requestId;
    private static final int _REQUEST_ID_FIELD_NUMBER = 1;
    private static final int _REQUEST_ID_TAG = 8;
    private static final int _REQUEST_ID_TAG_SIZE = LightProtoCodec.computeVarIntSize(8);
    private static final int _REQUEST_ID_MASK = 1;
    private ServerError errorCode;
    private static final int _ERROR_CODE_FIELD_NUMBER = 2;
    private static final int _ERROR_CODE_TAG = 16;
    private static final int _ERROR_CODE_TAG_SIZE = LightProtoCodec.computeVarIntSize(16);
    private static final int _ERROR_CODE_MASK = 2;
    private String errorMessage;
    private int _errorMessageBufferIdx = -1;
    private int _errorMessageBufferLen = -1;
    private static final int _ERROR_MESSAGE_FIELD_NUMBER = 3;
    private static final int _ERROR_MESSAGE_TAG = 26;
    private static final int _ERROR_MESSAGE_TAG_SIZE = LightProtoCodec.computeVarIntSize(26);
    private static final int _ERROR_MESSAGE_MASK = 4;
    private Schema schema;
    private static final int _SCHEMA_FIELD_NUMBER = 4;
    private static final int _SCHEMA_TAG = 34;
    private static final int _SCHEMA_TAG_SIZE = LightProtoCodec.computeVarIntSize(34);
    private static final int _SCHEMA_MASK = 8;
    private ByteBuf schemaVersion = null;
    private int _schemaVersionIdx = -1;
    private int _schemaVersionLen = -1;
    private static final int _SCHEMA_VERSION_FIELD_NUMBER = 5;
    private static final int _SCHEMA_VERSION_TAG = 42;
    private static final int _SCHEMA_VERSION_TAG_SIZE = LightProtoCodec.computeVarIntSize(42);
    private static final int _SCHEMA_VERSION_MASK = 16;
    private int _bitField0;
    private static final int _REQUIRED_FIELDS_MASK0 = 1;
    private int _cachedSize;
    private ByteBuf _parsedBuffer;

    public boolean hasRequestId() {
        return (this._bitField0 & 1) != 0;
    }

    public long getRequestId() {
        if (!this.hasRequestId()) {
            throw new IllegalStateException("Field 'request_id' is not set");
        }
        return this.requestId;
    }

    public CommandGetSchemaResponse setRequestId(long requestId) {
        this.requestId = requestId;
        this._bitField0 |= 1;
        this._cachedSize = -1;
        return this;
    }

    public CommandGetSchemaResponse clearRequestId() {
        this._bitField0 &= 0xFFFFFFFE;
        return this;
    }

    public boolean hasErrorCode() {
        return (this._bitField0 & 2) != 0;
    }

    public ServerError getErrorCode() {
        if (!this.hasErrorCode()) {
            throw new IllegalStateException("Field 'error_code' is not set");
        }
        return this.errorCode;
    }

    public CommandGetSchemaResponse setErrorCode(ServerError errorCode) {
        this.errorCode = errorCode;
        this._bitField0 |= 2;
        this._cachedSize = -1;
        return this;
    }

    public CommandGetSchemaResponse clearErrorCode() {
        this._bitField0 &= 0xFFFFFFFD;
        return this;
    }

    public boolean hasErrorMessage() {
        return (this._bitField0 & 4) != 0;
    }

    public String getErrorMessage() {
        if (!this.hasErrorMessage()) {
            throw new IllegalStateException("Field 'error_message' is not set");
        }
        if (this.errorMessage == null) {
            this.errorMessage = LightProtoCodec.readString(this._parsedBuffer, this._errorMessageBufferIdx, this._errorMessageBufferLen);
        }
        return this.errorMessage;
    }

    public CommandGetSchemaResponse setErrorMessage(String errorMessage) {
        this.errorMessage = errorMessage;
        this._bitField0 |= 4;
        this._errorMessageBufferIdx = -1;
        this._errorMessageBufferLen = LightProtoCodec.computeStringUTF8Size(errorMessage);
        this._cachedSize = -1;
        return this;
    }

    public CommandGetSchemaResponse clearErrorMessage() {
        this._bitField0 &= 0xFFFFFFFB;
        this.errorMessage = null;
        this._errorMessageBufferIdx = -1;
        this._errorMessageBufferLen = -1;
        return this;
    }

    public boolean hasSchema() {
        return (this._bitField0 & 8) != 0;
    }

    public Schema getSchema() {
        if (!this.hasSchema()) {
            throw new IllegalStateException("Field 'schema' is not set");
        }
        return this.schema;
    }

    public Schema setSchema() {
        if (this.schema == null) {
            this.schema = new Schema();
        }
        this._bitField0 |= 8;
        this._cachedSize = -1;
        return this.schema;
    }

    public CommandGetSchemaResponse clearSchema() {
        this._bitField0 &= 0xFFFFFFF7;
        if (this.hasSchema()) {
            this.schema.clear();
        }
        return this;
    }

    public boolean hasSchemaVersion() {
        return (this._bitField0 & 0x10) != 0;
    }

    public int getSchemaVersionSize() {
        if (!this.hasSchemaVersion()) {
            throw new IllegalStateException("Field 'schema_version' is not set");
        }
        return this._schemaVersionLen;
    }

    public byte[] getSchemaVersion() {
        ByteBuf _b = this.getSchemaVersionSlice();
        byte[] res = new byte[_b.readableBytes()];
        _b.getBytes(0, res);
        return res;
    }

    public ByteBuf getSchemaVersionSlice() {
        if (!this.hasSchemaVersion()) {
            throw new IllegalStateException("Field 'schema_version' is not set");
        }
        if (this.schemaVersion == null) {
            return this._parsedBuffer.slice(this._schemaVersionIdx, this._schemaVersionLen);
        }
        return this.schemaVersion.slice(0, this._schemaVersionLen);
    }

    public CommandGetSchemaResponse setSchemaVersion(byte[] schemaVersion) {
        this.setSchemaVersion(Unpooled.wrappedBuffer(schemaVersion));
        return this;
    }

    public CommandGetSchemaResponse setSchemaVersion(ByteBuf schemaVersion) {
        this.schemaVersion = schemaVersion;
        this._bitField0 |= 0x10;
        this._schemaVersionIdx = -1;
        this._schemaVersionLen = schemaVersion.readableBytes();
        this._cachedSize = -1;
        return this;
    }

    public CommandGetSchemaResponse clearSchemaVersion() {
        this._bitField0 &= 0xFFFFFFEF;
        this.schemaVersion = null;
        this._schemaVersionIdx = -1;
        this._schemaVersionLen = -1;
        return this;
    }

    public int writeTo(ByteBuf _b) {
        this.checkRequiredFields();
        int _writeIdx = _b.writerIndex();
        LightProtoCodec.writeVarInt(_b, 8);
        LightProtoCodec.writeVarInt64(_b, this.requestId);
        if (this.hasErrorCode()) {
            LightProtoCodec.writeVarInt(_b, 16);
            LightProtoCodec.writeVarInt(_b, this.errorCode.getValue());
        }
        if (this.hasErrorMessage()) {
            LightProtoCodec.writeVarInt(_b, 26);
            LightProtoCodec.writeVarInt(_b, this._errorMessageBufferLen);
            if (this._errorMessageBufferIdx == -1) {
                LightProtoCodec.writeString(_b, this.errorMessage, this._errorMessageBufferLen);
            } else {
                this._parsedBuffer.getBytes(this._errorMessageBufferIdx, _b, this._errorMessageBufferLen);
            }
        }
        if (this.hasSchema()) {
            LightProtoCodec.writeVarInt(_b, 34);
            LightProtoCodec.writeVarInt(_b, this.schema.getSerializedSize());
            this.schema.writeTo(_b);
        }
        if (this.hasSchemaVersion()) {
            LightProtoCodec.writeVarInt(_b, 42);
            LightProtoCodec.writeVarInt(_b, this._schemaVersionLen);
            if (this._schemaVersionIdx == -1) {
                _b.writeBytes(this.schemaVersion);
            } else {
                this._parsedBuffer.getBytes(this._schemaVersionIdx, _b, this._schemaVersionLen);
            }
        }
        return _b.writerIndex() - _writeIdx;
    }

    public int getSerializedSize() {
        if (this._cachedSize > -1) {
            return this._cachedSize;
        }
        int _size = 0;
        _size += _REQUEST_ID_TAG_SIZE;
        _size += LightProtoCodec.computeVarInt64Size(this.requestId);
        if (this.hasErrorCode()) {
            _size += _ERROR_CODE_TAG_SIZE;
            _size += LightProtoCodec.computeVarIntSize(this.errorCode.getValue());
        }
        if (this.hasErrorMessage()) {
            _size += _ERROR_MESSAGE_TAG_SIZE;
            _size += LightProtoCodec.computeVarIntSize(this._errorMessageBufferLen);
            _size += this._errorMessageBufferLen;
        }
        if (this.hasSchema()) {
            _size += LightProtoCodec.computeVarIntSize(34);
            int MsgsizeSchema = this.schema.getSerializedSize();
            _size += LightProtoCodec.computeVarIntSize(MsgsizeSchema) + MsgsizeSchema;
        }
        if (this.hasSchemaVersion()) {
            _size += _SCHEMA_VERSION_TAG_SIZE;
            _size += LightProtoCodec.computeVarIntSize(this._schemaVersionLen) + this._schemaVersionLen;
        }
        this._cachedSize = _size;
        return _size;
    }

    public void parseFrom(ByteBuf _buffer, int _size) {
        this.clear();
        int _endIdx = _buffer.readerIndex() + _size;
        block7: while (_buffer.readerIndex() < _endIdx) {
            int _tag = LightProtoCodec.readVarInt(_buffer);
            switch (_tag) {
                case 8: {
                    this._bitField0 |= 1;
                    this.requestId = LightProtoCodec.readVarInt64(_buffer);
                    continue block7;
                }
                case 16: {
                    ServerError _errorCode = ServerError.valueOf(LightProtoCodec.readVarInt(_buffer));
                    if (_errorCode == null) continue block7;
                    this._bitField0 |= 2;
                    this.errorCode = _errorCode;
                    continue block7;
                }
                case 26: {
                    this._bitField0 |= 4;
                    this._errorMessageBufferLen = LightProtoCodec.readVarInt(_buffer);
                    this._errorMessageBufferIdx = _buffer.readerIndex();
                    _buffer.skipBytes(this._errorMessageBufferLen);
                    continue block7;
                }
                case 34: {
                    this._bitField0 |= 8;
                    int schemaSize = LightProtoCodec.readVarInt(_buffer);
                    this.setSchema().parseFrom(_buffer, schemaSize);
                    continue block7;
                }
                case 42: {
                    this._bitField0 |= 0x10;
                    this._schemaVersionLen = LightProtoCodec.readVarInt(_buffer);
                    this._schemaVersionIdx = _buffer.readerIndex();
                    _buffer.skipBytes(this._schemaVersionLen);
                    continue block7;
                }
            }
            LightProtoCodec.skipUnknownField(_tag, _buffer);
        }
        this.checkRequiredFields();
        this._parsedBuffer = _buffer;
    }

    private void checkRequiredFields() {
        if ((this._bitField0 & 1) != 1) {
            throw new IllegalStateException("Some required fields are missing");
        }
    }

    public CommandGetSchemaResponse clear() {
        this.errorMessage = null;
        this._errorMessageBufferIdx = -1;
        this._errorMessageBufferLen = -1;
        if (this.hasSchema()) {
            this.schema.clear();
        }
        this.schemaVersion = null;
        this._schemaVersionIdx = -1;
        this._schemaVersionLen = -1;
        this._parsedBuffer = null;
        this._cachedSize = -1;
        this._bitField0 = 0;
        return this;
    }

    public CommandGetSchemaResponse copyFrom(CommandGetSchemaResponse _other) {
        this._cachedSize = -1;
        if (_other.hasRequestId()) {
            this.setRequestId(_other.requestId);
        }
        if (_other.hasErrorCode()) {
            this.setErrorCode(_other.errorCode);
        }
        if (_other.hasErrorMessage()) {
            this.setErrorMessage(_other.getErrorMessage());
        }
        if (_other.hasSchema()) {
            this.setSchema().copyFrom(_other.schema);
        }
        if (_other.hasSchemaVersion()) {
            this.setSchemaVersion(_other.getSchemaVersion());
        }
        return this;
    }

    public byte[] toByteArray() {
        byte[] a = new byte[this.getSerializedSize()];
        ByteBuf b = Unpooled.wrappedBuffer(a).writerIndex(0);
        this.writeTo(b);
        return a;
    }

    public void parseFrom(byte[] a) {
        ByteBuf b = Unpooled.wrappedBuffer(a);
        this.parseFrom(b, b.readableBytes());
    }
}

