/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.client.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import lombok.NonNull;
import org.apache.pulsar.client.api.BatchReceivePolicy;
import org.apache.pulsar.client.api.Consumer;
import org.apache.pulsar.client.api.ConsumerBuilder;
import org.apache.pulsar.client.api.ConsumerCryptoFailureAction;
import org.apache.pulsar.client.api.ConsumerEventListener;
import org.apache.pulsar.client.api.ConsumerInterceptor;
import org.apache.pulsar.client.api.CryptoKeyReader;
import org.apache.pulsar.client.api.DeadLetterPolicy;
import org.apache.pulsar.client.api.KeySharedPolicy;
import org.apache.pulsar.client.api.MessageCrypto;
import org.apache.pulsar.client.api.MessageListener;
import org.apache.pulsar.client.api.MessagePayloadProcessor;
import org.apache.pulsar.client.api.PulsarClientException;
import org.apache.pulsar.client.api.RedeliveryBackoff;
import org.apache.pulsar.client.api.RegexSubscriptionMode;
import org.apache.pulsar.client.api.Schema;
import org.apache.pulsar.client.api.SubscriptionInitialPosition;
import org.apache.pulsar.client.api.SubscriptionMode;
import org.apache.pulsar.client.api.SubscriptionType;
import org.apache.pulsar.client.api.TopicConsumerBuilder;
import org.apache.pulsar.client.impl.ConsumerInterceptors;
import org.apache.pulsar.client.impl.DefaultCryptoKeyReader;
import org.apache.pulsar.client.impl.PulsarClientImpl;
import org.apache.pulsar.client.impl.TopicConsumerBuilderImpl;
import org.apache.pulsar.client.impl.conf.ConfigurationDataUtils;
import org.apache.pulsar.client.impl.conf.ConsumerConfigurationData;
import org.apache.pulsar.client.impl.conf.TopicConsumerConfigurationData;
import org.apache.pulsar.common.naming.TopicName;
import org.apache.pulsar.common.partition.PartitionedTopicMetadata;
import org.apache.pulsar.common.util.FutureUtil;
import org.apache.pulsar.shade.com.google.common.base.Preconditions;
import org.apache.pulsar.shade.org.apache.commons.lang3.StringUtils;

public class ConsumerBuilderImpl<T>
implements ConsumerBuilder<T> {
    private final PulsarClientImpl client;
    private ConsumerConfigurationData<T> conf;
    private final Schema<T> schema;
    private List<ConsumerInterceptor<T>> interceptorList;
    private static final long MIN_ACK_TIMEOUT_MILLIS = 1000L;
    private static final long MIN_TICK_TIME_MILLIS = 100L;

    public ConsumerBuilderImpl(PulsarClientImpl client, Schema<T> schema) {
        this(client, new ConsumerConfigurationData(), schema);
    }

    ConsumerBuilderImpl(PulsarClientImpl client, ConsumerConfigurationData<T> conf, Schema<T> schema) {
        Preconditions.checkArgument(schema != null, "Schema should not be null.");
        this.client = client;
        this.conf = conf;
        this.schema = schema;
    }

    public ConsumerBuilder<T> loadConf(Map<String, Object> config) {
        this.conf = ConfigurationDataUtils.loadData(config, this.conf, ConsumerConfigurationData.class);
        return this;
    }

    public ConsumerBuilder<T> clone() {
        return new ConsumerBuilderImpl<T>(this.client, this.conf.clone(), this.schema);
    }

    public Consumer<T> subscribe() throws PulsarClientException {
        try {
            return this.subscribeAsync().get();
        }
        catch (Exception e) {
            throw PulsarClientException.unwrap((Throwable)e);
        }
    }

    public CompletableFuture<Consumer<T>> subscribeAsync() {
        CompletionStage<Object> applyDLQConfig;
        if (this.conf.getTopicNames().isEmpty() && this.conf.getTopicsPattern() == null) {
            return FutureUtil.failedFuture((Throwable)new PulsarClientException.InvalidConfigurationException("Topic name must be set on the consumer builder"));
        }
        if (StringUtils.isBlank(this.conf.getSubscriptionName())) {
            return FutureUtil.failedFuture((Throwable)new PulsarClientException.InvalidConfigurationException("Subscription name must be set on the consumer builder"));
        }
        if (this.conf.getKeySharedPolicy() != null && this.conf.getSubscriptionType() != SubscriptionType.Key_Shared) {
            return FutureUtil.failedFuture((Throwable)new PulsarClientException.InvalidConfigurationException("KeySharedPolicy must set with KeyShared subscription"));
        }
        if (this.conf.isRetryEnable() && this.conf.getTopicNames().size() > 0) {
            TopicName topicFirst = TopicName.get(this.conf.getTopicNames().iterator().next());
            String oldRetryLetterTopic = topicFirst.getNamespace() + "/" + this.conf.getSubscriptionName() + "-RETRY";
            String oldDeadLetterTopic = topicFirst.getNamespace() + "/" + this.conf.getSubscriptionName() + "-DLQ";
            DeadLetterPolicy deadLetterPolicy = this.conf.getDeadLetterPolicy();
            if (deadLetterPolicy == null || StringUtils.isBlank(deadLetterPolicy.getRetryLetterTopic()) || StringUtils.isBlank(deadLetterPolicy.getDeadLetterTopic())) {
                CompletableFuture<PartitionedTopicMetadata> retryLetterTopicMetadata = this.client.getPartitionedTopicMetadata(oldRetryLetterTopic);
                CompletableFuture<PartitionedTopicMetadata> deadLetterTopicMetadata = this.client.getPartitionedTopicMetadata(oldDeadLetterTopic);
                applyDLQConfig = CompletableFuture.allOf(retryLetterTopicMetadata, deadLetterTopicMetadata).thenAccept(__ -> {
                    String retryLetterTopic = topicFirst + "-" + this.conf.getSubscriptionName() + "-RETRY";
                    String deadLetterTopic = topicFirst + "-" + this.conf.getSubscriptionName() + "-DLQ";
                    if (((PartitionedTopicMetadata)retryLetterTopicMetadata.join()).partitions > 0) {
                        retryLetterTopic = oldRetryLetterTopic;
                    }
                    if (((PartitionedTopicMetadata)deadLetterTopicMetadata.join()).partitions > 0) {
                        deadLetterTopic = oldDeadLetterTopic;
                    }
                    if (deadLetterPolicy == null) {
                        this.conf.setDeadLetterPolicy(DeadLetterPolicy.builder().maxRedeliverCount(16).retryLetterTopic(retryLetterTopic).deadLetterTopic(deadLetterTopic).build());
                    } else {
                        if (StringUtils.isBlank(deadLetterPolicy.getRetryLetterTopic())) {
                            this.conf.getDeadLetterPolicy().setRetryLetterTopic(retryLetterTopic);
                        }
                        if (StringUtils.isBlank(deadLetterPolicy.getDeadLetterTopic())) {
                            this.conf.getDeadLetterPolicy().setDeadLetterTopic(deadLetterTopic);
                        }
                    }
                    this.conf.getTopicNames().add(this.conf.getDeadLetterPolicy().getRetryLetterTopic());
                });
            } else {
                this.conf.getTopicNames().add(this.conf.getDeadLetterPolicy().getRetryLetterTopic());
                applyDLQConfig = CompletableFuture.completedFuture(null);
            }
        } else {
            applyDLQConfig = CompletableFuture.completedFuture(null);
        }
        return applyDLQConfig.thenCompose(__ -> {
            if (this.interceptorList == null || this.interceptorList.size() == 0) {
                return this.client.subscribeAsync(this.conf, this.schema, null);
            }
            return this.client.subscribeAsync(this.conf, this.schema, new ConsumerInterceptors<T>(this.interceptorList));
        });
    }

    public ConsumerBuilder<T> topic(String ... topicNames) {
        Preconditions.checkArgument(topicNames != null && topicNames.length > 0, "Passed in topicNames should not be null or empty.");
        return this.topics(Arrays.stream(topicNames).collect(Collectors.toList()));
    }

    public ConsumerBuilder<T> topics(List<String> topicNames) {
        Preconditions.checkArgument(topicNames != null && !topicNames.isEmpty(), "Passed in topicNames list should not be null or empty.");
        topicNames.stream().forEach(topicName -> Preconditions.checkArgument(StringUtils.isNotBlank(topicName), "topicNames cannot have blank topic"));
        this.conf.getTopicNames().addAll(topicNames.stream().map(StringUtils::trim).collect(Collectors.toList()));
        return this;
    }

    public ConsumerBuilder<T> topicsPattern(Pattern topicsPattern) {
        Preconditions.checkArgument(this.conf.getTopicsPattern() == null && !topicsPattern.pattern().isEmpty(), "Pattern has already been set or is empty.");
        this.conf.setTopicsPattern(topicsPattern);
        return this;
    }

    public ConsumerBuilder<T> topicsPattern(String topicsPattern) {
        Preconditions.checkArgument(StringUtils.isNotEmpty(topicsPattern), "topicsPattern should not be null or empty");
        return this.topicsPattern(Pattern.compile(topicsPattern));
    }

    public ConsumerBuilder<T> subscriptionName(String subscriptionName) {
        Preconditions.checkArgument(StringUtils.isNotBlank(subscriptionName), "subscriptionName cannot be blank");
        this.conf.setSubscriptionName(subscriptionName);
        return this;
    }

    public ConsumerBuilder<T> subscriptionProperties(Map<String, String> subscriptionProperties) {
        Preconditions.checkArgument(subscriptionProperties != null, "subscriptionProperties cannot be null");
        this.conf.setSubscriptionProperties(Collections.unmodifiableMap(subscriptionProperties));
        return this;
    }

    public ConsumerBuilder<T> ackTimeout(long ackTimeout, TimeUnit timeUnit) {
        Preconditions.checkArgument(ackTimeout == 0L || timeUnit.toMillis(ackTimeout) >= 1000L, "Ack timeout should be greater than 1000 ms");
        this.conf.setAckTimeoutMillis(timeUnit.toMillis(ackTimeout));
        return this;
    }

    public ConsumerBuilder<T> isAckReceiptEnabled(boolean isAckReceiptEnabled) {
        this.conf.setAckReceiptEnabled(isAckReceiptEnabled);
        return this;
    }

    public ConsumerBuilder<T> ackTimeoutTickTime(long tickTime, TimeUnit timeUnit) {
        Preconditions.checkArgument(timeUnit.toMillis(tickTime) >= 100L, "Ack timeout tick time should be greater than 100 ms");
        this.conf.setTickDurationMillis(timeUnit.toMillis(tickTime));
        return this;
    }

    public ConsumerBuilder<T> negativeAckRedeliveryDelay(long redeliveryDelay, TimeUnit timeUnit) {
        Preconditions.checkArgument(redeliveryDelay >= 0L, "redeliveryDelay needs to be >= 0");
        this.conf.setNegativeAckRedeliveryDelayMicros(timeUnit.toMicros(redeliveryDelay));
        return this;
    }

    public ConsumerBuilder<T> subscriptionType(@NonNull SubscriptionType subscriptionType) {
        if (subscriptionType == null) {
            throw new NullPointerException("subscriptionType is marked non-null but is null");
        }
        this.conf.setSubscriptionType(subscriptionType);
        return this;
    }

    public ConsumerBuilder<T> subscriptionMode(@NonNull SubscriptionMode subscriptionMode) {
        if (subscriptionMode == null) {
            throw new NullPointerException("subscriptionMode is marked non-null but is null");
        }
        this.conf.setSubscriptionMode(subscriptionMode);
        return this;
    }

    public ConsumerBuilder<T> messageListener(@NonNull MessageListener<T> messageListener) {
        if (messageListener == null) {
            throw new NullPointerException("messageListener is marked non-null but is null");
        }
        this.conf.setMessageListener(messageListener);
        return this;
    }

    public ConsumerBuilder<T> consumerEventListener(@NonNull ConsumerEventListener consumerEventListener) {
        if (consumerEventListener == null) {
            throw new NullPointerException("consumerEventListener is marked non-null but is null");
        }
        this.conf.setConsumerEventListener(consumerEventListener);
        return this;
    }

    public ConsumerBuilder<T> cryptoKeyReader(@NonNull CryptoKeyReader cryptoKeyReader) {
        if (cryptoKeyReader == null) {
            throw new NullPointerException("cryptoKeyReader is marked non-null but is null");
        }
        this.conf.setCryptoKeyReader(cryptoKeyReader);
        return this;
    }

    public ConsumerBuilder<T> defaultCryptoKeyReader(String privateKey) {
        Preconditions.checkArgument(StringUtils.isNotBlank(privateKey), "privateKey cannot be blank");
        return this.cryptoKeyReader(DefaultCryptoKeyReader.builder().defaultPrivateKey(privateKey).build());
    }

    public ConsumerBuilder<T> defaultCryptoKeyReader(@NonNull Map<String, String> privateKeys) {
        if (privateKeys == null) {
            throw new NullPointerException("privateKeys is marked non-null but is null");
        }
        Preconditions.checkArgument(!privateKeys.isEmpty(), "privateKeys cannot be empty");
        return this.cryptoKeyReader(DefaultCryptoKeyReader.builder().privateKeys(privateKeys).build());
    }

    public ConsumerBuilder<T> messageCrypto(@NonNull MessageCrypto messageCrypto) {
        if (messageCrypto == null) {
            throw new NullPointerException("messageCrypto is marked non-null but is null");
        }
        this.conf.setMessageCrypto(messageCrypto);
        return this;
    }

    public ConsumerBuilder<T> cryptoFailureAction(@NonNull ConsumerCryptoFailureAction action) {
        if (action == null) {
            throw new NullPointerException("action is marked non-null but is null");
        }
        this.conf.setCryptoFailureAction(action);
        return this;
    }

    public ConsumerBuilder<T> receiverQueueSize(int receiverQueueSize) {
        Preconditions.checkArgument(receiverQueueSize >= 0, "receiverQueueSize needs to be >= 0");
        this.conf.setReceiverQueueSize(receiverQueueSize);
        return this;
    }

    public ConsumerBuilder<T> acknowledgmentGroupTime(long delay, TimeUnit unit) {
        Preconditions.checkArgument(delay >= 0L, "acknowledgmentGroupTime needs to be >= 0");
        this.conf.setAcknowledgementsGroupTimeMicros(unit.toMicros(delay));
        return this;
    }

    public ConsumerBuilder<T> maxAcknowledgmentGroupSize(int messageNum) {
        Preconditions.checkArgument(messageNum > 0, "acknowledgementsGroupSize needs to be > 0");
        this.conf.setMaxAcknowledgmentGroupSize(messageNum);
        return this;
    }

    public ConsumerBuilder<T> consumerName(String consumerName) {
        Preconditions.checkArgument(StringUtils.isNotBlank(consumerName), "consumerName cannot be blank");
        this.conf.setConsumerName(consumerName);
        return this;
    }

    public ConsumerBuilder<T> priorityLevel(int priorityLevel) {
        Preconditions.checkArgument(priorityLevel >= 0, "priorityLevel needs to be >= 0");
        this.conf.setPriorityLevel(priorityLevel);
        return this;
    }

    public ConsumerBuilder<T> maxPendingChuckedMessage(int maxPendingChuckedMessage) {
        this.conf.setMaxPendingChunkedMessage(maxPendingChuckedMessage);
        return this;
    }

    public ConsumerBuilder<T> maxPendingChunkedMessage(int maxPendingChunkedMessage) {
        this.conf.setMaxPendingChunkedMessage(maxPendingChunkedMessage);
        return this;
    }

    public ConsumerBuilder<T> autoAckOldestChunkedMessageOnQueueFull(boolean autoAckOldestChunkedMessageOnQueueFull) {
        this.conf.setAutoAckOldestChunkedMessageOnQueueFull(autoAckOldestChunkedMessageOnQueueFull);
        return this;
    }

    public ConsumerBuilder<T> property(String key, String value) {
        Preconditions.checkArgument(StringUtils.isNotBlank(key) && StringUtils.isNotBlank(value), "property key/value cannot be blank");
        this.conf.getProperties().put(key, value);
        return this;
    }

    public ConsumerBuilder<T> properties(@NonNull Map<String, String> properties) {
        if (properties == null) {
            throw new NullPointerException("properties is marked non-null but is null");
        }
        properties.entrySet().forEach(entry -> Preconditions.checkArgument(StringUtils.isNotBlank((CharSequence)entry.getKey()) && StringUtils.isNotBlank((CharSequence)entry.getValue()), "properties' key/value cannot be blank"));
        this.conf.getProperties().putAll(properties);
        return this;
    }

    public ConsumerBuilder<T> maxTotalReceiverQueueSizeAcrossPartitions(int maxTotalReceiverQueueSizeAcrossPartitions) {
        Preconditions.checkArgument(maxTotalReceiverQueueSizeAcrossPartitions >= 0, "maxTotalReceiverQueueSizeAcrossPartitions needs to be >= 0");
        this.conf.setMaxTotalReceiverQueueSizeAcrossPartitions(maxTotalReceiverQueueSizeAcrossPartitions);
        return this;
    }

    public ConsumerBuilder<T> readCompacted(boolean readCompacted) {
        this.conf.setReadCompacted(readCompacted);
        return this;
    }

    public ConsumerBuilder<T> patternAutoDiscoveryPeriod(int periodInMinutes) {
        Preconditions.checkArgument(periodInMinutes >= 0, "periodInMinutes needs to be >= 0");
        this.patternAutoDiscoveryPeriod(periodInMinutes, TimeUnit.MINUTES);
        return this;
    }

    public ConsumerBuilder<T> patternAutoDiscoveryPeriod(int interval, TimeUnit unit) {
        Preconditions.checkArgument(interval >= 0, "interval needs to be >= 0");
        int intervalSeconds = (int)unit.toSeconds(interval);
        this.conf.setPatternAutoDiscoveryPeriod(intervalSeconds);
        return this;
    }

    public ConsumerBuilder<T> subscriptionInitialPosition(@NonNull SubscriptionInitialPosition subscriptionInitialPosition) {
        if (subscriptionInitialPosition == null) {
            throw new NullPointerException("subscriptionInitialPosition is marked non-null but is null");
        }
        this.conf.setSubscriptionInitialPosition(subscriptionInitialPosition);
        return this;
    }

    public ConsumerBuilder<T> subscriptionTopicsMode(@NonNull RegexSubscriptionMode mode) {
        if (mode == null) {
            throw new NullPointerException("mode is marked non-null but is null");
        }
        this.conf.setRegexSubscriptionMode(mode);
        return this;
    }

    public ConsumerBuilder<T> replicateSubscriptionState(boolean replicateSubscriptionState) {
        this.conf.setReplicateSubscriptionState(replicateSubscriptionState);
        return this;
    }

    public ConsumerBuilder<T> intercept(ConsumerInterceptor<T> ... interceptors) {
        if (this.interceptorList == null) {
            this.interceptorList = new ArrayList<ConsumerInterceptor<T>>();
        }
        this.interceptorList.addAll(Arrays.asList(interceptors));
        return this;
    }

    public ConsumerBuilder<T> deadLetterPolicy(DeadLetterPolicy deadLetterPolicy) {
        if (deadLetterPolicy != null) {
            Preconditions.checkArgument(deadLetterPolicy.getMaxRedeliverCount() > 0, "MaxRedeliverCount must be > 0.");
        }
        this.conf.setDeadLetterPolicy(deadLetterPolicy);
        return this;
    }

    public ConsumerBuilder<T> autoUpdatePartitions(boolean autoUpdate) {
        this.conf.setAutoUpdatePartitions(autoUpdate);
        return this;
    }

    public ConsumerBuilder<T> autoUpdatePartitionsInterval(int interval, TimeUnit unit) {
        this.conf.setAutoUpdatePartitionsIntervalSeconds(interval, unit);
        return this;
    }

    public ConsumerBuilder<T> startMessageIdInclusive() {
        this.conf.setResetIncludeHead(true);
        return this;
    }

    public ConsumerBuilder<T> batchReceivePolicy(BatchReceivePolicy batchReceivePolicy) {
        Preconditions.checkArgument(batchReceivePolicy != null, "batchReceivePolicy must not be null.");
        batchReceivePolicy.verify();
        this.conf.setBatchReceivePolicy(batchReceivePolicy);
        return this;
    }

    public String toString() {
        return this.conf != null ? this.conf.toString() : "";
    }

    public ConsumerBuilder<T> keySharedPolicy(KeySharedPolicy keySharedPolicy) {
        keySharedPolicy.validate();
        this.conf.setKeySharedPolicy(keySharedPolicy);
        return this;
    }

    public ConsumerBuilder<T> enableRetry(boolean retryEnable) {
        this.conf.setRetryEnable(retryEnable);
        return this;
    }

    public ConsumerBuilder<T> enableBatchIndexAcknowledgment(boolean batchIndexAcknowledgmentEnabled) {
        this.conf.setBatchIndexAckEnabled(batchIndexAcknowledgmentEnabled);
        return this;
    }

    public ConsumerBuilder<T> expireTimeOfIncompleteChunkedMessage(long duration, TimeUnit unit) {
        this.conf.setExpireTimeOfIncompleteChunkedMessageMillis(unit.toMillis(duration));
        return this;
    }

    public ConsumerBuilder<T> poolMessages(boolean poolMessages) {
        this.conf.setPoolMessages(poolMessages);
        return this;
    }

    public ConsumerBuilder<T> messagePayloadProcessor(MessagePayloadProcessor payloadProcessor) {
        this.conf.setPayloadProcessor(payloadProcessor);
        return this;
    }

    public ConsumerBuilder<T> negativeAckRedeliveryBackoff(RedeliveryBackoff negativeAckRedeliveryBackoff) {
        Preconditions.checkArgument(negativeAckRedeliveryBackoff != null, "negativeAckRedeliveryBackoff must not be null.");
        this.conf.setNegativeAckRedeliveryBackoff(negativeAckRedeliveryBackoff);
        return this;
    }

    public ConsumerBuilder<T> ackTimeoutRedeliveryBackoff(RedeliveryBackoff ackTimeoutRedeliveryBackoff) {
        Preconditions.checkArgument(ackTimeoutRedeliveryBackoff != null, "ackTimeoutRedeliveryBackoff must not be null.");
        this.conf.setAckTimeoutRedeliveryBackoff(ackTimeoutRedeliveryBackoff);
        return this;
    }

    public ConsumerBuilder<T> startPaused(boolean paused) {
        this.conf.setStartPaused(paused);
        return this;
    }

    public ConsumerBuilder<T> autoScaledReceiverQueueSizeEnabled(boolean enabled) {
        this.conf.setAutoScaledReceiverQueueSizeEnabled(enabled);
        return this;
    }

    public TopicConsumerBuilder<T> topicConfiguration(String topicName) {
        TopicConsumerConfigurationData topicConf = TopicConsumerConfigurationData.ofTopicName(topicName, this.conf);
        this.conf.getTopicConfigurations().add(topicConf);
        return new TopicConsumerBuilderImpl(this, topicConf);
    }

    public ConsumerBuilder<T> topicConfiguration(String topicName, java.util.function.Consumer<TopicConsumerBuilder<T>> builderConsumer) {
        builderConsumer.accept(this.topicConfiguration(topicName));
        return this;
    }

    public TopicConsumerBuilder<T> topicConfiguration(Pattern topicsPattern) {
        TopicConsumerConfigurationData topicConf = TopicConsumerConfigurationData.ofTopicsPattern(topicsPattern, this.conf);
        this.conf.getTopicConfigurations().add(topicConf);
        return new TopicConsumerBuilderImpl(this, topicConf);
    }

    public ConsumerBuilder<T> topicConfiguration(Pattern topicsPattern, java.util.function.Consumer<TopicConsumerBuilder<T>> builderConsumer) {
        builderConsumer.accept(this.topicConfiguration(topicsPattern));
        return this;
    }

    public PulsarClientImpl getClient() {
        return this.client;
    }

    public ConsumerConfigurationData<T> getConf() {
        return this.conf;
    }

    public Schema<T> getSchema() {
        return this.schema;
    }

    public List<ConsumerInterceptor<T>> getInterceptorList() {
        return this.interceptorList;
    }
}

