/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.shade.io.netty.incubator.channel.uring;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.AlreadyConnectedException;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.ConnectionPendingException;
import java.nio.channels.NotYetConnectedException;
import java.nio.channels.UnresolvedAddressException;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.apache.pulsar.shade.io.netty.buffer.ByteBuf;
import org.apache.pulsar.shade.io.netty.buffer.ByteBufAllocator;
import org.apache.pulsar.shade.io.netty.buffer.ByteBufHolder;
import org.apache.pulsar.shade.io.netty.buffer.ByteBufUtil;
import org.apache.pulsar.shade.io.netty.buffer.Unpooled;
import org.apache.pulsar.shade.io.netty.channel.AbstractChannel;
import org.apache.pulsar.shade.io.netty.channel.Channel;
import org.apache.pulsar.shade.io.netty.channel.ChannelConfig;
import org.apache.pulsar.shade.io.netty.channel.ChannelFuture;
import org.apache.pulsar.shade.io.netty.channel.ChannelFutureListener;
import org.apache.pulsar.shade.io.netty.channel.ChannelMetadata;
import org.apache.pulsar.shade.io.netty.channel.ChannelOption;
import org.apache.pulsar.shade.io.netty.channel.ChannelOutboundBuffer;
import org.apache.pulsar.shade.io.netty.channel.ChannelPromise;
import org.apache.pulsar.shade.io.netty.channel.ChannelPromiseNotifier;
import org.apache.pulsar.shade.io.netty.channel.ConnectTimeoutException;
import org.apache.pulsar.shade.io.netty.channel.EventLoop;
import org.apache.pulsar.shade.io.netty.channel.RecvByteBufAllocator;
import org.apache.pulsar.shade.io.netty.channel.socket.ChannelInputShutdownEvent;
import org.apache.pulsar.shade.io.netty.channel.socket.ChannelInputShutdownReadComplete;
import org.apache.pulsar.shade.io.netty.channel.socket.SocketChannelConfig;
import org.apache.pulsar.shade.io.netty.channel.unix.Buffer;
import org.apache.pulsar.shade.io.netty.channel.unix.Errors;
import org.apache.pulsar.shade.io.netty.channel.unix.FileDescriptor;
import org.apache.pulsar.shade.io.netty.channel.unix.UnixChannel;
import org.apache.pulsar.shade.io.netty.channel.unix.UnixChannelUtil;
import org.apache.pulsar.shade.io.netty.incubator.channel.uring.IOUring;
import org.apache.pulsar.shade.io.netty.incubator.channel.uring.IOUringEventLoop;
import org.apache.pulsar.shade.io.netty.incubator.channel.uring.IOUringRecvByteAllocatorHandle;
import org.apache.pulsar.shade.io.netty.incubator.channel.uring.IOUringSubmissionQueue;
import org.apache.pulsar.shade.io.netty.incubator.channel.uring.LinuxSocket;
import org.apache.pulsar.shade.io.netty.incubator.channel.uring.MsgHdrMemory;
import org.apache.pulsar.shade.io.netty.incubator.channel.uring.MsgHdrMemoryArray;
import org.apache.pulsar.shade.io.netty.incubator.channel.uring.Native;
import org.apache.pulsar.shade.io.netty.incubator.channel.uring.SockaddrIn;
import org.apache.pulsar.shade.io.netty.util.ReferenceCountUtil;
import org.apache.pulsar.shade.io.netty.util.internal.ObjectUtil;
import org.apache.pulsar.shade.io.netty.util.internal.logging.InternalLogger;
import org.apache.pulsar.shade.io.netty.util.internal.logging.InternalLoggerFactory;

abstract class AbstractIOUringChannel
extends AbstractChannel
implements UnixChannel {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(AbstractIOUringChannel.class);
    private static final ChannelMetadata METADATA = new ChannelMetadata(false);
    final LinuxSocket socket;
    protected volatile boolean active;
    private static final int POLL_IN_SCHEDULED = 1;
    private static final int POLL_OUT_SCHEDULED = 4;
    private static final int POLL_RDHUP_SCHEDULED = 8;
    private static final int WRITE_SCHEDULED = 16;
    private static final int READ_SCHEDULED = 32;
    private static final int CONNECT_SCHEDULED = 64;
    private byte ioState;
    private short numOutstandingWrites;
    private short numOutstandingReads;
    private ChannelPromise delayedClose;
    private boolean inputClosedSeenErrorOnRead;
    private ChannelPromise connectPromise;
    private ScheduledFuture<?> connectTimeoutFuture;
    private SocketAddress requestedRemoteAddress;
    private ByteBuffer remoteAddressMemory;
    private MsgHdrMemoryArray msgHdrMemoryArray;
    private IOUringSubmissionQueue submissionQueue;
    private volatile SocketAddress local;
    private volatile SocketAddress remote;

    AbstractIOUringChannel(Channel parent, LinuxSocket socket) {
        this(parent, socket, true);
    }

    AbstractIOUringChannel(Channel parent, LinuxSocket socket, boolean active) {
        super(parent);
        this.socket = ObjectUtil.checkNotNull(socket, "fd");
        if (active) {
            this.active = true;
            this.local = socket.localAddress();
            this.remote = socket.remoteAddress();
        }
        if (parent != null) {
            logger.trace("Create Channel Socket: {}", (Object)socket.intValue());
        } else {
            logger.trace("Create Server Socket: {}", (Object)socket.intValue());
        }
    }

    AbstractIOUringChannel(Channel parent, LinuxSocket fd, SocketAddress remote) {
        super(parent);
        this.socket = ObjectUtil.checkNotNull(fd, "fd");
        this.active = true;
        this.remote = remote;
        this.local = fd.localAddress();
    }

    @Override
    public boolean isOpen() {
        return this.socket.isOpen();
    }

    @Override
    public boolean isActive() {
        return this.active;
    }

    @Override
    public ChannelMetadata metadata() {
        return METADATA;
    }

    @Override
    public FileDescriptor fd() {
        return this.socket;
    }

    @Override
    protected abstract AbstractUringUnsafe newUnsafe();

    AbstractUringUnsafe ioUringUnsafe() {
        return (AbstractUringUnsafe)this.unsafe();
    }

    @Override
    protected boolean isCompatible(EventLoop loop) {
        return loop instanceof IOUringEventLoop;
    }

    protected final ByteBuf newDirectBuffer(ByteBuf buf) {
        return this.newDirectBuffer(buf, buf);
    }

    protected final ByteBuf newDirectBuffer(Object holder, ByteBuf buf) {
        int readableBytes = buf.readableBytes();
        if (readableBytes == 0) {
            ReferenceCountUtil.release(holder);
            return Unpooled.EMPTY_BUFFER;
        }
        ByteBufAllocator alloc = this.alloc();
        if (alloc.isDirectBufferPooled()) {
            return AbstractIOUringChannel.newDirectBuffer0(holder, buf, alloc, readableBytes);
        }
        ByteBuf directBuf = ByteBufUtil.threadLocalDirectBuffer();
        if (directBuf == null) {
            return AbstractIOUringChannel.newDirectBuffer0(holder, buf, alloc, readableBytes);
        }
        directBuf.writeBytes(buf, buf.readerIndex(), readableBytes);
        ReferenceCountUtil.safeRelease(holder);
        return directBuf;
    }

    private static ByteBuf newDirectBuffer0(Object holder, ByteBuf buf, ByteBufAllocator alloc, int capacity) {
        ByteBuf directBuf = alloc.directBuffer(capacity);
        directBuf.writeBytes(buf, buf.readerIndex(), capacity);
        ReferenceCountUtil.safeRelease(holder);
        return directBuf;
    }

    @Override
    protected void doDisconnect() throws Exception {
    }

    IOUringSubmissionQueue submissionQueue() {
        return this.submissionQueue;
    }

    private void freeRemoteAddressMemory() {
        if (this.remoteAddressMemory != null) {
            Buffer.free(this.remoteAddressMemory);
            this.remoteAddressMemory = null;
        }
    }

    private void freeMsgHdrArray() {
        if (this.msgHdrMemoryArray != null) {
            this.msgHdrMemoryArray.release();
            this.msgHdrMemoryArray = null;
        }
    }

    boolean ioScheduled() {
        return this.ioState != 0;
    }

    @Override
    protected void doClose() throws Exception {
        this.freeRemoteAddressMemory();
        this.freeMsgHdrArray();
        this.active = false;
        try {
            ChannelPromise promise = this.connectPromise;
            if (promise != null) {
                promise.tryFailure(new ClosedChannelException());
                this.connectPromise = null;
            }
            this.cancelConnectTimeoutFuture();
        }
        finally {
            if (this.submissionQueue != null) {
                if (this.socket.markClosed()) {
                    this.submissionQueue.addClose(this.fd().intValue(), (short)0);
                }
            } else {
                this.socket.close();
            }
        }
    }

    @Override
    protected void doBeginRead() {
        if ((this.ioState & 1) == 0) {
            this.ioUringUnsafe().schedulePollIn();
        }
    }

    @Override
    protected void doWrite(ChannelOutboundBuffer in) {
        if ((this.ioState & 0x10) != 0) {
            return;
        }
        if (this.scheduleWrite(in) > 0) {
            this.ioState = (byte)(this.ioState | 0x10);
        }
    }

    private int scheduleWrite(ChannelOutboundBuffer in) {
        if (this.delayedClose != null || this.numOutstandingWrites == Short.MAX_VALUE) {
            return 0;
        }
        if (in == null) {
            return 0;
        }
        int msgCount = in.size();
        if (msgCount == 0) {
            return 0;
        }
        Object msg = in.current();
        this.numOutstandingWrites = msgCount > 1 ? (short)this.ioUringUnsafe().scheduleWriteMultiple(in) : (msg instanceof ByteBuf && ((ByteBuf)msg).nioBufferCount() > 1 || msg instanceof ByteBufHolder && ((ByteBufHolder)msg).content().nioBufferCount() > 1 ? (short)this.ioUringUnsafe().scheduleWriteMultiple(in) : (short)this.ioUringUnsafe().scheduleWriteSingle(msg));
        assert (this.numOutstandingWrites > 0);
        return this.numOutstandingWrites;
    }

    private void schedulePollOut() {
        assert ((this.ioState & 4) == 0);
        IOUringSubmissionQueue submissionQueue = this.submissionQueue();
        submissionQueue.addPollOut(this.socket.intValue());
        this.ioState = (byte)(this.ioState | 4);
    }

    final void schedulePollRdHup() {
        assert ((this.ioState & 8) == 0);
        IOUringSubmissionQueue submissionQueue = this.submissionQueue();
        submissionQueue.addPollRdHup(this.fd().intValue());
        this.ioState = (byte)(this.ioState | 8);
    }

    final void resetCachedAddresses() {
        this.local = this.socket.localAddress();
        this.remote = this.socket.remoteAddress();
    }

    private void submitConnect(InetSocketAddress inetSocketAddress) {
        this.remoteAddressMemory = Buffer.allocateDirectWithNativeOrder(Native.SIZEOF_SOCKADDR_STORAGE);
        long remoteAddressMemoryAddress = Buffer.memoryAddress(this.remoteAddressMemory);
        SockaddrIn.write(this.socket.isIpv6(), remoteAddressMemoryAddress, inetSocketAddress);
        IOUringSubmissionQueue ioUringSubmissionQueue = this.submissionQueue();
        ioUringSubmissionQueue.addConnect(this.socket.intValue(), remoteAddressMemoryAddress, Native.SIZEOF_SOCKADDR_STORAGE, (short)0);
    }

    @Override
    protected Object filterOutboundMessage(Object msg) {
        if (msg instanceof ByteBuf) {
            ByteBuf buf = (ByteBuf)msg;
            return UnixChannelUtil.isBufferCopyNeededForWrite(buf) ? this.newDirectBuffer(buf) : buf;
        }
        throw new UnsupportedOperationException("unsupported message type");
    }

    @Override
    protected void doRegister() throws Exception {
        IOUringEventLoop eventLoop = (IOUringEventLoop)this.eventLoop();
        eventLoop.add(this);
        this.submissionQueue = eventLoop.getRingBuffer().ioUringSubmissionQueue();
    }

    @Override
    protected final void doDeregister() {
        IOUringSubmissionQueue submissionQueue = this.submissionQueue();
        if (submissionQueue != null) {
            if ((this.ioState & 0xD) == 0) {
                ((IOUringEventLoop)this.eventLoop()).remove(this);
                return;
            }
            if ((this.ioState & 1) != 0) {
                submissionQueue.addPollRemove(this.socket.intValue(), Native.POLLIN);
            }
            if ((this.ioState & 4) != 0) {
                submissionQueue.addPollRemove(this.socket.intValue(), Native.POLLOUT);
            }
            if ((this.ioState & 8) != 0) {
                submissionQueue.addPollRemove(this.socket.intValue(), Native.POLLRDHUP);
            }
        }
    }

    @Override
    protected void doBind(SocketAddress local) throws Exception {
        if (local instanceof InetSocketAddress) {
            AbstractIOUringChannel.checkResolvable((InetSocketAddress)local);
        }
        this.socket.bind(local);
        this.local = this.socket.localAddress();
    }

    protected static void checkResolvable(InetSocketAddress addr) {
        if (addr.isUnresolved()) {
            throw new UnresolvedAddressException();
        }
    }

    @Override
    protected SocketAddress localAddress0() {
        return this.local;
    }

    @Override
    protected SocketAddress remoteAddress0() {
        return this.remote;
    }

    private static boolean isAllowHalfClosure(ChannelConfig config) {
        return config instanceof SocketChannelConfig && ((SocketChannelConfig)config).isAllowHalfClosure();
    }

    private void cancelConnectTimeoutFuture() {
        if (this.connectTimeoutFuture != null) {
            this.connectTimeoutFuture.cancel(false);
            this.connectTimeoutFuture = null;
        }
    }

    private void computeRemote() {
        if (this.requestedRemoteAddress instanceof InetSocketAddress) {
            this.remote = UnixChannelUtil.computeRemoteAddr((InetSocketAddress)this.requestedRemoteAddress, this.socket.remoteAddress());
        }
    }

    private boolean shouldBreakIoUringInReady(ChannelConfig config) {
        return this.socket.isInputShutdown() && (this.inputClosedSeenErrorOnRead || !AbstractIOUringChannel.isAllowHalfClosure(config));
    }

    public void clearPollFlag(int pollMask) {
        if (pollMask == Native.POLLIN) {
            this.ioState = (byte)(this.ioState & 0xFFFFFFFE);
        } else if (pollMask == Native.POLLOUT) {
            this.ioState = (byte)(this.ioState & 0xFFFFFFFB);
        } else if (pollMask == Native.POLLRDHUP) {
            this.ioState = (byte)(this.ioState & 0xFFFFFFF7);
        }
    }

    abstract class AbstractUringUnsafe
    extends AbstractChannel.AbstractUnsafe {
        private IOUringRecvByteAllocatorHandle allocHandle;

        AbstractUringUnsafe() {
        }

        protected abstract int scheduleWriteMultiple(ChannelOutboundBuffer var1);

        protected abstract int scheduleWriteSingle(Object var1);

        @Override
        public void close(ChannelPromise promise) {
            if ((AbstractIOUringChannel.this.ioState & 0x30) == 0) {
                this.forceClose(promise);
            } else if (AbstractIOUringChannel.this.delayedClose == null || AbstractIOUringChannel.this.delayedClose.isVoid()) {
                AbstractIOUringChannel.this.delayedClose = promise;
            } else {
                if (promise.isVoid()) {
                    return;
                }
                AbstractIOUringChannel.this.delayedClose.addListener(new ChannelPromiseNotifier(promise));
            }
        }

        private void forceClose(ChannelPromise promise) {
            super.close(promise);
        }

        @Override
        protected final void flush0() {
            if ((AbstractIOUringChannel.this.ioState & 4) == 0) {
                super.flush0();
            }
        }

        private void fulfillConnectPromise(ChannelPromise promise, Throwable cause) {
            if (promise == null) {
                return;
            }
            promise.tryFailure(cause);
            this.closeIfClosed();
        }

        private void fulfillConnectPromise(ChannelPromise promise, boolean wasActive) {
            if (promise == null) {
                return;
            }
            AbstractIOUringChannel.this.active = true;
            if (AbstractIOUringChannel.this.local == null) {
                AbstractIOUringChannel.this.local = AbstractIOUringChannel.this.socket.localAddress();
            }
            AbstractIOUringChannel.this.computeRemote();
            AbstractIOUringChannel.this.schedulePollRdHup();
            boolean active = AbstractIOUringChannel.this.isActive();
            boolean promiseSet = promise.trySuccess();
            if (!wasActive && active) {
                AbstractIOUringChannel.this.pipeline().fireChannelActive();
            }
            if (!promiseSet) {
                this.close(this.voidPromise());
            }
        }

        final IOUringRecvByteAllocatorHandle newIOUringHandle(RecvByteBufAllocator.ExtendedHandle handle) {
            return new IOUringRecvByteAllocatorHandle(handle);
        }

        @Override
        public final IOUringRecvByteAllocatorHandle recvBufAllocHandle() {
            if (this.allocHandle == null) {
                this.allocHandle = this.newIOUringHandle((RecvByteBufAllocator.ExtendedHandle)super.recvBufAllocHandle());
            }
            return this.allocHandle;
        }

        final void shutdownInput(boolean rdHup) {
            logger.trace("shutdownInput Fd: {}", (Object)AbstractIOUringChannel.this.fd().intValue());
            if (!AbstractIOUringChannel.this.socket.isInputShutdown()) {
                if (AbstractIOUringChannel.isAllowHalfClosure(AbstractIOUringChannel.this.config())) {
                    try {
                        AbstractIOUringChannel.this.socket.shutdown(true, false);
                    }
                    catch (IOException ignored) {
                        this.fireEventAndClose(ChannelInputShutdownEvent.INSTANCE);
                        return;
                    }
                    catch (NotYetConnectedException notYetConnectedException) {
                        // empty catch block
                    }
                    AbstractIOUringChannel.this.pipeline().fireUserEventTriggered(ChannelInputShutdownEvent.INSTANCE);
                } else {
                    this.close(this.voidPromise());
                }
            } else if (!rdHup) {
                AbstractIOUringChannel.this.inputClosedSeenErrorOnRead = true;
                AbstractIOUringChannel.this.pipeline().fireUserEventTriggered(ChannelInputShutdownReadComplete.INSTANCE);
            }
        }

        private void fireEventAndClose(Object evt) {
            AbstractIOUringChannel.this.pipeline().fireUserEventTriggered(evt);
            this.close(this.voidPromise());
        }

        final void schedulePollIn() {
            assert ((AbstractIOUringChannel.this.ioState & 1) == 0);
            if (!AbstractIOUringChannel.this.isActive() || AbstractIOUringChannel.this.shouldBreakIoUringInReady(AbstractIOUringChannel.this.config())) {
                return;
            }
            AbstractIOUringChannel.this.ioState = (byte)(AbstractIOUringChannel.this.ioState | 1);
            IOUringSubmissionQueue submissionQueue = AbstractIOUringChannel.this.submissionQueue();
            submissionQueue.addPollIn(AbstractIOUringChannel.this.socket.intValue());
        }

        final void processDelayedClose() {
            ChannelPromise promise = AbstractIOUringChannel.this.delayedClose;
            if (promise != null && (AbstractIOUringChannel.this.ioState & 0x70) == 0) {
                AbstractIOUringChannel.this.delayedClose = null;
                this.forceClose(promise);
            }
        }

        final void readComplete(int res, int data) {
            assert (AbstractIOUringChannel.this.numOutstandingReads > 0);
            if ((AbstractIOUringChannel.this.numOutstandingReads = (short)(AbstractIOUringChannel.this.numOutstandingReads - 1)) == 0) {
                AbstractIOUringChannel.this.ioState = (byte)(AbstractIOUringChannel.this.ioState & 0xFFFFFFDF);
            }
            this.readComplete0(res, data, AbstractIOUringChannel.this.numOutstandingReads);
        }

        protected abstract void readComplete0(int var1, int var2, int var3);

        final void pollRdHup(int res) {
            AbstractIOUringChannel.this.ioState = (byte)(AbstractIOUringChannel.this.ioState & 0xFFFFFFF7);
            if (res == Native.ERRNO_ECANCELED_NEGATIVE) {
                return;
            }
            this.recvBufAllocHandle().rdHupReceived();
            if (AbstractIOUringChannel.this.isActive()) {
                this.scheduleFirstReadIfNeeded();
            } else {
                this.shutdownInput(true);
            }
        }

        final void pollIn(int res) {
            AbstractIOUringChannel.this.ioState = (byte)(AbstractIOUringChannel.this.ioState & 0xFFFFFFFE);
            if (res == Native.ERRNO_ECANCELED_NEGATIVE) {
                return;
            }
            this.scheduleFirstReadIfNeeded();
        }

        private void scheduleFirstReadIfNeeded() {
            if ((AbstractIOUringChannel.this.ioState & 0x20) == 0) {
                this.scheduleFirstRead();
            }
        }

        private void scheduleFirstRead() {
            ChannelConfig config = AbstractIOUringChannel.this.config();
            IOUringRecvByteAllocatorHandle allocHandle = this.recvBufAllocHandle();
            allocHandle.reset(config);
            this.scheduleRead();
        }

        protected final void scheduleRead() {
            if (AbstractIOUringChannel.this.delayedClose == null && AbstractIOUringChannel.this.fd().isOpen() && (AbstractIOUringChannel.this.ioState & 0x20) == 0) {
                AbstractIOUringChannel.this.numOutstandingReads = (short)this.scheduleRead0();
                if (AbstractIOUringChannel.this.numOutstandingReads > 0) {
                    AbstractIOUringChannel.this.ioState = (byte)(AbstractIOUringChannel.this.ioState | 0x20);
                }
            }
        }

        protected abstract int scheduleRead0();

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        final void pollOut(int res) {
            AbstractIOUringChannel.this.ioState = (byte)(AbstractIOUringChannel.this.ioState & 0xFFFFFFFB);
            if (res == Native.ERRNO_ECANCELED_NEGATIVE) {
                return;
            }
            if (AbstractIOUringChannel.this.connectPromise != null) {
                assert (AbstractIOUringChannel.this.eventLoop().inEventLoop());
                boolean connectStillInProgress = false;
                try {
                    boolean wasActive = AbstractIOUringChannel.this.isActive();
                    if (!AbstractIOUringChannel.this.socket.finishConnect()) {
                        connectStillInProgress = true;
                        return;
                    }
                    this.fulfillConnectPromise(AbstractIOUringChannel.this.connectPromise, wasActive);
                }
                catch (Throwable t) {
                    this.fulfillConnectPromise(AbstractIOUringChannel.this.connectPromise, this.annotateConnectException(t, AbstractIOUringChannel.this.requestedRemoteAddress));
                }
                finally {
                    if (!connectStillInProgress) {
                        AbstractIOUringChannel.this.cancelConnectTimeoutFuture();
                        AbstractIOUringChannel.this.connectPromise = null;
                    } else {
                        AbstractIOUringChannel.this.schedulePollOut();
                    }
                }
            } else if (!AbstractIOUringChannel.this.socket.isOutputShutdown()) {
                super.flush0();
            }
        }

        final void writeComplete(int res, int data) {
            if ((AbstractIOUringChannel.this.ioState & 0x40) != 0) {
                AbstractIOUringChannel.this.freeMsgHdrArray();
                if (res > 0) {
                    this.outboundBuffer().removeBytes(res);
                    this.connectComplete(res);
                } else if (res == Errors.ERRNO_EINPROGRESS_NEGATIVE || res == 0) {
                    AbstractIOUringChannel.this.submitConnect((InetSocketAddress)AbstractIOUringChannel.this.requestedRemoteAddress);
                } else {
                    this.connectComplete(res);
                }
                return;
            }
            assert (AbstractIOUringChannel.this.numOutstandingWrites > 0);
            AbstractIOUringChannel.this.numOutstandingWrites = (short)(AbstractIOUringChannel.this.numOutstandingWrites - 1);
            boolean writtenAll = this.writeComplete0(res, data, AbstractIOUringChannel.this.numOutstandingWrites);
            if (!writtenAll && (AbstractIOUringChannel.this.ioState & 4) == 0) {
                AbstractIOUringChannel.this.schedulePollOut();
            }
            if (AbstractIOUringChannel.this.numOutstandingWrites == 0) {
                AbstractIOUringChannel.this.ioState = (byte)(AbstractIOUringChannel.this.ioState & 0xFFFFFFEF);
                if (writtenAll && (AbstractIOUringChannel.this.ioState & 4) == 0) {
                    AbstractIOUringChannel.this.doWrite(AbstractIOUringChannel.this.unsafe().outboundBuffer());
                }
            }
        }

        abstract boolean writeComplete0(int var1, int var2, int var3);

        void connectComplete(int res) {
            AbstractIOUringChannel.this.ioState = (byte)(AbstractIOUringChannel.this.ioState & 0xFFFFFFBF);
            AbstractIOUringChannel.this.freeRemoteAddressMemory();
            if (res == Errors.ERRNO_EINPROGRESS_NEGATIVE) {
                AbstractIOUringChannel.this.schedulePollOut();
            } else {
                try {
                    if (res == 0) {
                        this.fulfillConnectPromise(AbstractIOUringChannel.this.connectPromise, AbstractIOUringChannel.this.active);
                    } else {
                        try {
                            Errors.throwConnectException("io_uring connect", res);
                        }
                        catch (Throwable cause) {
                            this.fulfillConnectPromise(AbstractIOUringChannel.this.connectPromise, cause);
                        }
                    }
                }
                finally {
                    AbstractIOUringChannel.this.cancelConnectTimeoutFuture();
                    AbstractIOUringChannel.this.connectPromise = null;
                }
            }
        }

        @Override
        public void connect(final SocketAddress remoteAddress, SocketAddress localAddress, ChannelPromise promise) {
            if (!promise.setUncancellable() || !this.ensureOpen(promise)) {
                return;
            }
            if (AbstractIOUringChannel.this.delayedClose != null) {
                promise.tryFailure(this.annotateConnectException(new ClosedChannelException(), remoteAddress));
                return;
            }
            try {
                if (AbstractIOUringChannel.this.connectPromise != null) {
                    throw new ConnectionPendingException();
                }
                if (localAddress instanceof InetSocketAddress) {
                    AbstractIOUringChannel.checkResolvable((InetSocketAddress)localAddress);
                }
                if (remoteAddress instanceof InetSocketAddress) {
                    AbstractIOUringChannel.checkResolvable((InetSocketAddress)remoteAddress);
                }
                if (AbstractIOUringChannel.this.remote != null) {
                    throw new AlreadyConnectedException();
                }
                if (localAddress != null) {
                    AbstractIOUringChannel.this.socket.bind(localAddress);
                }
                InetSocketAddress inetSocketAddress = (InetSocketAddress)remoteAddress;
                ByteBuf initialData = null;
                if (IOUring.isTcpFastOpenClientSideAvailable() && AbstractIOUringChannel.this.config().getOption(ChannelOption.TCP_FASTOPEN_CONNECT) == Boolean.TRUE) {
                    ChannelOutboundBuffer outbound = AbstractIOUringChannel.this.unsafe().outboundBuffer();
                    outbound.addFlush();
                    Object curr = outbound.current();
                    if (curr instanceof ByteBuf) {
                        initialData = (ByteBuf)curr;
                    }
                }
                if (initialData != null) {
                    AbstractIOUringChannel.this.msgHdrMemoryArray = new MsgHdrMemoryArray(1);
                    MsgHdrMemory hdr = AbstractIOUringChannel.this.msgHdrMemoryArray.hdr(0);
                    hdr.write(AbstractIOUringChannel.this.socket, inetSocketAddress, initialData.memoryAddress(), initialData.readableBytes(), (short)0);
                    IOUringSubmissionQueue ioUringSubmissionQueue = AbstractIOUringChannel.this.submissionQueue();
                    ioUringSubmissionQueue.addSendmsg(AbstractIOUringChannel.this.socket.intValue(), hdr.address(), Native.MSG_FASTOPEN, (short)0);
                } else {
                    AbstractIOUringChannel.this.submitConnect(inetSocketAddress);
                }
                AbstractIOUringChannel.this.ioState = (byte)(AbstractIOUringChannel.this.ioState | 0x40);
            }
            catch (Throwable t) {
                this.closeIfClosed();
                promise.tryFailure(this.annotateConnectException(t, remoteAddress));
                return;
            }
            AbstractIOUringChannel.this.connectPromise = promise;
            AbstractIOUringChannel.this.requestedRemoteAddress = remoteAddress;
            int connectTimeoutMillis = AbstractIOUringChannel.this.config().getConnectTimeoutMillis();
            if (connectTimeoutMillis > 0) {
                AbstractIOUringChannel.this.connectTimeoutFuture = AbstractIOUringChannel.this.eventLoop().schedule(new Runnable(){

                    @Override
                    public void run() {
                        ChannelPromise connectPromise = AbstractIOUringChannel.this.connectPromise;
                        if (connectPromise != null && !connectPromise.isDone() && connectPromise.tryFailure(new ConnectTimeoutException("connection timed out: " + remoteAddress))) {
                            AbstractUringUnsafe.this.close(AbstractUringUnsafe.this.voidPromise());
                        }
                    }
                }, (long)connectTimeoutMillis, TimeUnit.MILLISECONDS);
            }
            promise.addListener(new ChannelFutureListener(){

                @Override
                public void operationComplete(ChannelFuture future) {
                    if (future.isCancelled()) {
                        AbstractIOUringChannel.this.cancelConnectTimeoutFuture();
                        AbstractIOUringChannel.this.connectPromise = null;
                        AbstractUringUnsafe.this.close(AbstractUringUnsafe.this.voidPromise());
                    }
                }
            });
        }
    }
}

