/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.client.impl.transaction;

import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.pulsar.client.api.MessageId;
import org.apache.pulsar.client.api.transaction.Transaction;
import org.apache.pulsar.client.impl.PulsarClientImpl;
import org.apache.pulsar.common.util.FutureUtil;

public class TransactionImpl
implements Transaction {
    private final PulsarClientImpl client;
    private final long transactionTimeoutMs;
    private final long txnIdLeastBits;
    private final long txnIdMostBits;
    private final AtomicLong sequenceId = new AtomicLong(0L);
    private final LinkedHashMap<Long, TransactionalSendOp> sendOps;
    private final Set<String> producedTopics;
    private final Set<TransactionalAckOp> ackOps;
    private final Set<String> ackedTopics;

    TransactionImpl(PulsarClientImpl client, long transactionTimeoutMs, long txnIdLeastBits, long txnIdMostBits) {
        this.client = client;
        this.transactionTimeoutMs = transactionTimeoutMs;
        this.txnIdLeastBits = txnIdLeastBits;
        this.txnIdMostBits = txnIdMostBits;
        this.sendOps = new LinkedHashMap();
        this.producedTopics = new HashSet<String>();
        this.ackOps = new HashSet<TransactionalAckOp>();
        this.ackedTopics = new HashSet<String>();
    }

    public long nextSequenceId() {
        return this.sequenceId.getAndIncrement();
    }

    public synchronized void registerProducedTopic(String topic) {
        if (this.producedTopics.add(topic)) {
            // empty if block
        }
    }

    public synchronized CompletableFuture<MessageId> registerSendOp(long sequenceId, CompletableFuture<MessageId> sendFuture) {
        CompletableFuture<MessageId> transactionalSendFuture = new CompletableFuture<MessageId>();
        TransactionalSendOp sendOp = new TransactionalSendOp(sendFuture, transactionalSendFuture);
        this.sendOps.put(sequenceId, sendOp);
        return transactionalSendFuture;
    }

    public synchronized void registerAckedTopic(String topic) {
        if (this.ackedTopics.add(topic)) {
            // empty if block
        }
    }

    public synchronized CompletableFuture<Void> registerAckOp(CompletableFuture<Void> ackFuture) {
        CompletableFuture<Void> transactionalAckFuture = new CompletableFuture<Void>();
        TransactionalAckOp ackOp = new TransactionalAckOp(ackFuture, transactionalAckFuture);
        this.ackOps.add(ackOp);
        return transactionalAckFuture;
    }

    public CompletableFuture<Void> commit() {
        return FutureUtil.failedFuture(new UnsupportedOperationException("Not Implemented Yet"));
    }

    public CompletableFuture<Void> abort() {
        return FutureUtil.failedFuture(new UnsupportedOperationException("Not Implemented Yet"));
    }

    public PulsarClientImpl getClient() {
        return this.client;
    }

    public long getTransactionTimeoutMs() {
        return this.transactionTimeoutMs;
    }

    public long getTxnIdLeastBits() {
        return this.txnIdLeastBits;
    }

    public long getTxnIdMostBits() {
        return this.txnIdMostBits;
    }

    public AtomicLong getSequenceId() {
        return this.sequenceId;
    }

    public LinkedHashMap<Long, TransactionalSendOp> getSendOps() {
        return this.sendOps;
    }

    public Set<String> getProducedTopics() {
        return this.producedTopics;
    }

    public Set<TransactionalAckOp> getAckOps() {
        return this.ackOps;
    }

    public Set<String> getAckedTopics() {
        return this.ackedTopics;
    }

    private static class TransactionalAckOp {
        private final CompletableFuture<Void> ackFuture;
        private final CompletableFuture<Void> transactionalAckFuture;

        public TransactionalAckOp(CompletableFuture<Void> ackFuture, CompletableFuture<Void> transactionalAckFuture) {
            this.ackFuture = ackFuture;
            this.transactionalAckFuture = transactionalAckFuture;
        }

        public CompletableFuture<Void> getAckFuture() {
            return this.ackFuture;
        }

        public CompletableFuture<Void> getTransactionalAckFuture() {
            return this.transactionalAckFuture;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof TransactionalAckOp)) {
                return false;
            }
            TransactionalAckOp other = (TransactionalAckOp)o;
            if (!other.canEqual(this)) {
                return false;
            }
            CompletableFuture<Void> this$ackFuture = this.getAckFuture();
            CompletableFuture<Void> other$ackFuture = other.getAckFuture();
            if (this$ackFuture == null ? other$ackFuture != null : !this$ackFuture.equals(other$ackFuture)) {
                return false;
            }
            CompletableFuture<Void> this$transactionalAckFuture = this.getTransactionalAckFuture();
            CompletableFuture<Void> other$transactionalAckFuture = other.getTransactionalAckFuture();
            return !(this$transactionalAckFuture == null ? other$transactionalAckFuture != null : !this$transactionalAckFuture.equals(other$transactionalAckFuture));
        }

        protected boolean canEqual(Object other) {
            return other instanceof TransactionalAckOp;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            CompletableFuture<Void> $ackFuture = this.getAckFuture();
            result = result * 59 + ($ackFuture == null ? 43 : $ackFuture.hashCode());
            CompletableFuture<Void> $transactionalAckFuture = this.getTransactionalAckFuture();
            result = result * 59 + ($transactionalAckFuture == null ? 43 : $transactionalAckFuture.hashCode());
            return result;
        }

        public String toString() {
            return "TransactionImpl.TransactionalAckOp(ackFuture=" + this.getAckFuture() + ", transactionalAckFuture=" + this.getTransactionalAckFuture() + ")";
        }
    }

    private static class TransactionalSendOp {
        private final CompletableFuture<MessageId> sendFuture;
        private final CompletableFuture<MessageId> transactionalSendFuture;

        public TransactionalSendOp(CompletableFuture<MessageId> sendFuture, CompletableFuture<MessageId> transactionalSendFuture) {
            this.sendFuture = sendFuture;
            this.transactionalSendFuture = transactionalSendFuture;
        }

        public CompletableFuture<MessageId> getSendFuture() {
            return this.sendFuture;
        }

        public CompletableFuture<MessageId> getTransactionalSendFuture() {
            return this.transactionalSendFuture;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof TransactionalSendOp)) {
                return false;
            }
            TransactionalSendOp other = (TransactionalSendOp)o;
            if (!other.canEqual(this)) {
                return false;
            }
            CompletableFuture<MessageId> this$sendFuture = this.getSendFuture();
            CompletableFuture<MessageId> other$sendFuture = other.getSendFuture();
            if (this$sendFuture == null ? other$sendFuture != null : !this$sendFuture.equals(other$sendFuture)) {
                return false;
            }
            CompletableFuture<MessageId> this$transactionalSendFuture = this.getTransactionalSendFuture();
            CompletableFuture<MessageId> other$transactionalSendFuture = other.getTransactionalSendFuture();
            return !(this$transactionalSendFuture == null ? other$transactionalSendFuture != null : !this$transactionalSendFuture.equals(other$transactionalSendFuture));
        }

        protected boolean canEqual(Object other) {
            return other instanceof TransactionalSendOp;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            CompletableFuture<MessageId> $sendFuture = this.getSendFuture();
            result = result * 59 + ($sendFuture == null ? 43 : $sendFuture.hashCode());
            CompletableFuture<MessageId> $transactionalSendFuture = this.getTransactionalSendFuture();
            result = result * 59 + ($transactionalSendFuture == null ? 43 : $transactionalSendFuture.hashCode());
            return result;
        }

        public String toString() {
            return "TransactionImpl.TransactionalSendOp(sendFuture=" + this.getSendFuture() + ", transactionalSendFuture=" + this.getTransactionalSendFuture() + ")";
        }
    }
}

