/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.client.impl;

import java.util.BitSet;
import org.apache.pulsar.shade.com.google.common.annotations.VisibleForTesting;

class BatchMessageAcker {
    private final int batchSize;
    private final BitSet bitSet;
    private boolean prevBatchCumulativelyAcked = false;

    private BatchMessageAcker() {
        this.bitSet = new BitSet();
        this.batchSize = 0;
    }

    static BatchMessageAcker newAcker(int batchSize) {
        BitSet bitSet = new BitSet(batchSize);
        bitSet.set(0, batchSize);
        return new BatchMessageAcker(bitSet, batchSize);
    }

    BatchMessageAcker(BitSet bitSet, int batchSize) {
        this.bitSet = bitSet;
        this.batchSize = batchSize;
    }

    @VisibleForTesting
    BitSet getBitSet() {
        return this.bitSet;
    }

    public synchronized int getBatchSize() {
        return this.batchSize;
    }

    public synchronized boolean ackIndividual(int batchIndex) {
        this.bitSet.clear(batchIndex);
        return this.bitSet.isEmpty();
    }

    public synchronized boolean ackCumulative(int batchIndex) {
        this.bitSet.clear(0, batchIndex + 1);
        return this.bitSet.isEmpty();
    }

    public synchronized int getOutstandingAcks() {
        return this.bitSet.cardinality();
    }

    public void setPrevBatchCumulativelyAcked(boolean acked) {
        this.prevBatchCumulativelyAcked = acked;
    }

    public boolean isPrevBatchCumulativelyAcked() {
        return this.prevBatchCumulativelyAcked;
    }

    public String toString() {
        return "BatchMessageAcker{batchSize=" + this.batchSize + ", bitSet=" + this.bitSet + ", prevBatchCumulativelyAcked=" + this.prevBatchCumulativelyAcked + '}';
    }
}

