/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.client.impl.schema;

import org.apache.pulsar.client.api.Schema;
import org.apache.pulsar.common.schema.SchemaInfo;
import org.apache.pulsar.common.schema.SchemaType;
import org.apache.pulsar.shade.com.google.common.base.Preconditions;

public class AutoProduceBytesSchema<T>
implements Schema<byte[]> {
    private boolean requireSchemaValidation = true;
    private Schema<T> schema;

    public void setSchema(Schema<T> schema) {
        this.schema = schema;
        this.requireSchemaValidation = schema.getSchemaInfo() != null && SchemaType.BYTES != schema.getSchemaInfo().getType() && SchemaType.NONE != schema.getSchemaInfo().getType();
    }

    private void ensureSchemaInitialized() {
        Preconditions.checkState(null != this.schema, "Schema is not initialized before used");
    }

    public void validate(byte[] message) {
        this.ensureSchemaInitialized();
        this.schema.validate(message);
    }

    public byte[] encode(byte[] message) {
        this.ensureSchemaInitialized();
        if (this.requireSchemaValidation) {
            this.schema.validate(message);
        }
        return message;
    }

    public byte[] decode(byte[] bytes, byte[] schemaVersion) {
        this.ensureSchemaInitialized();
        if (this.requireSchemaValidation) {
            this.schema.decode(bytes, schemaVersion);
        }
        return bytes;
    }

    public SchemaInfo getSchemaInfo() {
        this.ensureSchemaInitialized();
        return this.schema.getSchemaInfo();
    }
}

