/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.shade.org.asynchttpclient.util;

import org.apache.pulsar.shade.org.asynchttpclient.util.StringBuilderPool;

public final class Base64 {
    private static final StringBuilderPool SB_POOL;
    private static final char[] LOOKUP;
    private static final byte[] REVERSE_LOOKUP;

    private Base64() {
    }

    public static String encode(byte[] bytes) {
        int chunk;
        StringBuilder buf = SB_POOL.stringBuilder();
        int i = 0;
        int end = bytes.length - 2;
        while (i < end) {
            chunk = (bytes[i++] & 0xFF) << 16 | (bytes[i++] & 0xFF) << 8 | bytes[i++] & 0xFF;
            buf.append(LOOKUP[chunk >> 18]);
            buf.append(LOOKUP[chunk >> 12 & 0x3F]);
            buf.append(LOOKUP[chunk >> 6 & 0x3F]);
            buf.append(LOOKUP[chunk & 0x3F]);
        }
        int len = bytes.length;
        if (i < len) {
            chunk = (bytes[i++] & 0xFF) << 16;
            buf.append(LOOKUP[chunk >> 18]);
            if (i < len) {
                buf.append(LOOKUP[(chunk |= (bytes[i] & 0xFF) << 8) >> 12 & 0x3F]);
                buf.append(LOOKUP[chunk >> 6 & 0x3F]);
            } else {
                buf.append(LOOKUP[chunk >> 12 & 0x3F]);
                buf.append('=');
            }
            buf.append('=');
        }
        return buf.toString();
    }

    public static byte[] decode(String encoded) {
        int padding = 0;
        int i = encoded.length() - 1;
        while (encoded.charAt(i) == '=') {
            ++padding;
            --i;
        }
        int length = encoded.length() * 6 / 8 - padding;
        byte[] bytes = new byte[length];
        int index = 0;
        int n = encoded.length();
        for (int i2 = 0; i2 < n; i2 += 4) {
            int word = REVERSE_LOOKUP[encoded.charAt(i2)] << 18;
            word += REVERSE_LOOKUP[encoded.charAt(i2 + 1)] << 12;
            word += REVERSE_LOOKUP[encoded.charAt(i2 + 2)] << 6;
            word += REVERSE_LOOKUP[encoded.charAt(i2 + 3)];
            for (int j = 0; j < 3 && index + j < length; ++j) {
                bytes[index + j] = (byte)(word >> 8 * (2 - j));
            }
            index += 3;
        }
        return bytes;
    }

    static {
        int i;
        SB_POOL = new StringBuilderPool();
        LOOKUP = new char[64];
        REVERSE_LOOKUP = new byte[256];
        for (i = 0; i < 26; ++i) {
            Base64.LOOKUP[i] = (char)(65 + i);
        }
        i = 26;
        int j = 0;
        while (i < 52) {
            Base64.LOOKUP[i] = (char)(97 + j);
            ++i;
            ++j;
        }
        i = 52;
        j = 0;
        while (i < 62) {
            Base64.LOOKUP[i] = (char)(48 + j);
            ++i;
            ++j;
        }
        Base64.LOOKUP[62] = 43;
        Base64.LOOKUP[63] = 47;
        for (i = 0; i < 256; ++i) {
            Base64.REVERSE_LOOKUP[i] = -1;
        }
        for (i = 90; i >= 65; --i) {
            Base64.REVERSE_LOOKUP[i] = (byte)(i - 65);
        }
        for (i = 122; i >= 97; --i) {
            Base64.REVERSE_LOOKUP[i] = (byte)(i - 97 + 26);
        }
        for (i = 57; i >= 48; --i) {
            Base64.REVERSE_LOOKUP[i] = (byte)(i - 48 + 52);
        }
        Base64.REVERSE_LOOKUP[43] = 62;
        Base64.REVERSE_LOOKUP[47] = 63;
        Base64.REVERSE_LOOKUP[61] = 0;
    }
}

