/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.shade.org.asynchttpclient.request.body.multipart;

import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ThreadLocalRandom;
import org.apache.pulsar.shade.io.netty.handler.codec.http.HttpHeaderNames;
import org.apache.pulsar.shade.io.netty.handler.codec.http.HttpHeaderValues;
import org.apache.pulsar.shade.io.netty.handler.codec.http.HttpHeaders;
import org.apache.pulsar.shade.org.asynchttpclient.request.body.multipart.ByteArrayPart;
import org.apache.pulsar.shade.org.asynchttpclient.request.body.multipart.FilePart;
import org.apache.pulsar.shade.org.asynchttpclient.request.body.multipart.MultipartBody;
import org.apache.pulsar.shade.org.asynchttpclient.request.body.multipart.Part;
import org.apache.pulsar.shade.org.asynchttpclient.request.body.multipart.StringPart;
import org.apache.pulsar.shade.org.asynchttpclient.request.body.multipart.part.ByteArrayMultipartPart;
import org.apache.pulsar.shade.org.asynchttpclient.request.body.multipart.part.FileMultipartPart;
import org.apache.pulsar.shade.org.asynchttpclient.request.body.multipart.part.MessageEndMultipartPart;
import org.apache.pulsar.shade.org.asynchttpclient.request.body.multipart.part.MultipartPart;
import org.apache.pulsar.shade.org.asynchttpclient.request.body.multipart.part.StringMultipartPart;
import org.apache.pulsar.shade.org.asynchttpclient.util.Assertions;
import org.apache.pulsar.shade.org.asynchttpclient.util.MiscUtils;
import org.apache.pulsar.shade.org.asynchttpclient.util.StringBuilderPool;

public class MultipartUtils {
    private static byte[] MULTIPART_CHARS = "-_1234567890abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ".getBytes(StandardCharsets.US_ASCII);

    public static MultipartBody newMultipartBody(List<Part> parts, HttpHeaders requestHeaders) {
        byte[] boundary;
        String contentType;
        Assertions.assertNotNull(parts, "parts");
        String contentTypeHeader = requestHeaders.get(HttpHeaderNames.CONTENT_TYPE);
        if (MiscUtils.isNonEmpty(contentTypeHeader)) {
            int boundaryLocation = contentTypeHeader.indexOf("boundary=");
            if (boundaryLocation != -1) {
                contentType = contentTypeHeader;
                boundary = contentTypeHeader.substring(boundaryLocation + "boundary=".length()).trim().getBytes(StandardCharsets.US_ASCII);
            } else {
                boundary = MultipartUtils.generateBoundary();
                contentType = MultipartUtils.computeContentType(contentTypeHeader, boundary);
            }
        } else {
            boundary = MultipartUtils.generateBoundary();
            contentType = MultipartUtils.computeContentType(HttpHeaderValues.MULTIPART_FORM_DATA, boundary);
        }
        List<MultipartPart<? extends Part>> multipartParts = MultipartUtils.generateMultipartParts(parts, boundary);
        return new MultipartBody(multipartParts, contentType, boundary);
    }

    public static List<MultipartPart<? extends Part>> generateMultipartParts(List<Part> parts, byte[] boundary) {
        ArrayList<MultipartPart<? extends Part>> multipartParts = new ArrayList<MultipartPart<? extends Part>>(parts.size());
        for (Part part : parts) {
            if (part instanceof FilePart) {
                multipartParts.add(new FileMultipartPart((FilePart)part, boundary));
                continue;
            }
            if (part instanceof ByteArrayPart) {
                multipartParts.add(new ByteArrayMultipartPart((ByteArrayPart)part, boundary));
                continue;
            }
            if (part instanceof StringPart) {
                multipartParts.add(new StringMultipartPart((StringPart)part, boundary));
                continue;
            }
            throw new IllegalArgumentException("Unknown part type: " + part);
        }
        multipartParts.add(new MessageEndMultipartPart(boundary));
        return multipartParts;
    }

    private static byte[] generateBoundary() {
        ThreadLocalRandom random = ThreadLocalRandom.current();
        byte[] bytes = new byte[random.nextInt(11) + 30];
        for (int i = 0; i < bytes.length; ++i) {
            bytes[i] = MULTIPART_CHARS[random.nextInt(MULTIPART_CHARS.length)];
        }
        return bytes;
    }

    private static String computeContentType(CharSequence base, byte[] boundary) {
        StringBuilder buffer = StringBuilderPool.DEFAULT.stringBuilder().append(base);
        if (base.length() != 0 && base.charAt(base.length() - 1) != ';') {
            buffer.append(';');
        }
        return buffer.append(" boundary=").append(new String(boundary, StandardCharsets.US_ASCII)).toString();
    }
}

