/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.shade.org.asynchttpclient.netty.request.body;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.channels.FileChannel;
import org.apache.pulsar.shade.io.netty.channel.Channel;
import org.apache.pulsar.shade.io.netty.channel.DefaultFileRegion;
import org.apache.pulsar.shade.io.netty.handler.codec.http.LastHttpContent;
import org.apache.pulsar.shade.io.netty.handler.stream.ChunkedNioFile;
import org.apache.pulsar.shade.org.asynchttpclient.AsyncHttpClientConfig;
import org.apache.pulsar.shade.org.asynchttpclient.netty.NettyResponseFuture;
import org.apache.pulsar.shade.org.asynchttpclient.netty.channel.ChannelManager;
import org.apache.pulsar.shade.org.asynchttpclient.netty.request.WriteProgressListener;
import org.apache.pulsar.shade.org.asynchttpclient.netty.request.body.NettyBody;

public class NettyFileBody
implements NettyBody {
    private final File file;
    private final long offset;
    private final long length;
    private final AsyncHttpClientConfig config;

    public NettyFileBody(File file, AsyncHttpClientConfig config) {
        this(file, 0L, file.length(), config);
    }

    public NettyFileBody(File file, long offset, long length, AsyncHttpClientConfig config) {
        if (!file.isFile()) {
            throw new IllegalArgumentException(String.format("File %s is not a file or doesn't exist", file.getAbsolutePath()));
        }
        this.file = file;
        this.offset = offset;
        this.length = length;
        this.config = config;
    }

    public File getFile() {
        return this.file;
    }

    public long getOffset() {
        return this.offset;
    }

    @Override
    public long getContentLength() {
        return this.length;
    }

    @Override
    public void write(Channel channel, NettyResponseFuture<?> future) throws IOException {
        FileChannel fileChannel = new RandomAccessFile(this.file, "r").getChannel();
        boolean noZeroCopy = ChannelManager.isSslHandlerConfigured(channel.pipeline()) || this.config.isDisableZeroCopy();
        Object body = noZeroCopy ? new ChunkedNioFile(fileChannel, this.offset, this.length, this.config.getChunkedFileChunkSize()) : new DefaultFileRegion(fileChannel, this.offset, this.length);
        channel.write(body, channel.newProgressivePromise()).addListener(new WriteProgressListener(future, false, this.length));
        channel.writeAndFlush(LastHttpContent.EMPTY_LAST_CONTENT, channel.voidPromise());
    }
}

