/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.common.policies.data;

import java.util.List;
import org.apache.pulsar.common.api.proto.PulsarApi;
import org.apache.pulsar.common.policies.data.ConsumerStats;
import org.apache.pulsar.shade.com.google.common.base.Preconditions;
import org.apache.pulsar.shade.com.google.common.collect.Lists;

public class SubscriptionStats {
    public double msgRateOut;
    public double msgThroughputOut;
    public double msgRateRedeliver;
    public long msgBacklog;
    public boolean blockedSubscriptionOnUnackedMsgs;
    public long unackedMessages;
    public PulsarApi.CommandSubscribe.SubType type;
    public String activeConsumerName;
    public double msgRateExpired;
    public List<ConsumerStats> consumers = Lists.newArrayList();

    public void reset() {
        this.msgRateOut = 0.0;
        this.msgThroughputOut = 0.0;
        this.msgRateRedeliver = 0.0;
        this.msgBacklog = 0L;
        this.unackedMessages = 0L;
        this.msgRateExpired = 0.0;
        this.consumers.clear();
    }

    public SubscriptionStats add(SubscriptionStats stats) {
        Preconditions.checkNotNull(stats);
        this.msgRateOut += stats.msgRateOut;
        this.msgThroughputOut += stats.msgThroughputOut;
        this.msgRateRedeliver += stats.msgRateRedeliver;
        this.msgBacklog += stats.msgBacklog;
        this.unackedMessages += stats.unackedMessages;
        this.msgRateExpired += stats.msgRateExpired;
        if (this.consumers.size() != stats.consumers.size()) {
            for (int i = 0; i < stats.consumers.size(); ++i) {
                ConsumerStats consumerStats = new ConsumerStats();
                this.consumers.add(consumerStats.add(stats.consumers.get(i)));
            }
        } else {
            for (int i = 0; i < stats.consumers.size(); ++i) {
                this.consumers.get(i).add(stats.consumers.get(i));
            }
        }
        return this;
    }
}

