/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.client.impl;

import java.util.Map;
import java.util.Optional;
import org.apache.pulsar.client.api.Message;
import org.apache.pulsar.client.api.MessageId;
import org.apache.pulsar.client.impl.TopicMessageIdImpl;
import org.apache.pulsar.common.api.EncryptionContext;

public class TopicMessageImpl<T>
implements Message<T> {
    private final String topicPartitionName;
    private final Message<T> msg;
    private final TopicMessageIdImpl messageId;

    TopicMessageImpl(String topicPartitionName, String topicName, Message<T> msg) {
        this.topicPartitionName = topicPartitionName;
        this.msg = msg;
        this.messageId = new TopicMessageIdImpl(topicPartitionName, topicName, msg.getMessageId());
    }

    @Override
    public String getTopicName() {
        return this.msg.getTopicName();
    }

    public String getTopicPartitionName() {
        return this.topicPartitionName;
    }

    @Override
    public MessageId getMessageId() {
        return this.messageId;
    }

    public MessageId getInnerMessageId() {
        return this.messageId.getInnerMessageId();
    }

    @Override
    public Map<String, String> getProperties() {
        return this.msg.getProperties();
    }

    @Override
    public boolean hasProperty(String name) {
        return this.msg.hasProperty(name);
    }

    @Override
    public String getProperty(String name) {
        return this.msg.getProperty(name);
    }

    @Override
    public byte[] getData() {
        return this.msg.getData();
    }

    @Override
    public long getPublishTime() {
        return this.msg.getPublishTime();
    }

    @Override
    public long getEventTime() {
        return this.msg.getEventTime();
    }

    @Override
    public long getSequenceId() {
        return this.msg.getSequenceId();
    }

    @Override
    public String getProducerName() {
        return this.msg.getProducerName();
    }

    @Override
    public boolean hasKey() {
        return this.msg.hasKey();
    }

    @Override
    public String getKey() {
        return this.msg.getKey();
    }

    @Override
    public boolean hasBase64EncodedKey() {
        return this.msg.hasBase64EncodedKey();
    }

    @Override
    public byte[] getKeyBytes() {
        return this.msg.getKeyBytes();
    }

    @Override
    public T getValue() {
        return this.msg.getValue();
    }

    @Override
    public Optional<EncryptionContext> getEncryptionCtx() {
        return this.msg.getEncryptionCtx();
    }

    public Message<T> getMessage() {
        return this.msg;
    }
}

