/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.client.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import lombok.NonNull;
import org.apache.pulsar.client.api.CompressionType;
import org.apache.pulsar.client.api.CryptoKeyReader;
import org.apache.pulsar.client.api.HashingScheme;
import org.apache.pulsar.client.api.MessageRouter;
import org.apache.pulsar.client.api.MessageRoutingMode;
import org.apache.pulsar.client.api.Producer;
import org.apache.pulsar.client.api.ProducerBuilder;
import org.apache.pulsar.client.api.ProducerCryptoFailureAction;
import org.apache.pulsar.client.api.ProducerInterceptor;
import org.apache.pulsar.client.api.PulsarClientException;
import org.apache.pulsar.client.api.Schema;
import org.apache.pulsar.client.impl.ProducerInterceptors;
import org.apache.pulsar.client.impl.PulsarClientImpl;
import org.apache.pulsar.client.impl.conf.ConfigurationDataUtils;
import org.apache.pulsar.client.impl.conf.ProducerConfigurationData;
import org.apache.pulsar.common.util.FutureUtil;
import org.apache.pulsar.shade.com.google.common.annotations.VisibleForTesting;

public class ProducerBuilderImpl<T>
implements ProducerBuilder<T> {
    private final PulsarClientImpl client;
    private ProducerConfigurationData conf;
    private Schema<T> schema;
    private List<ProducerInterceptor<T>> interceptorList;

    @VisibleForTesting
    public ProducerBuilderImpl(PulsarClientImpl client, Schema<T> schema) {
        this(client, new ProducerConfigurationData(), schema);
    }

    private ProducerBuilderImpl(PulsarClientImpl client, ProducerConfigurationData conf, Schema<T> schema) {
        this.client = client;
        this.conf = conf;
        this.schema = schema;
    }

    public ProducerBuilder<T> schema(Schema<T> schema) {
        this.schema = schema;
        return this;
    }

    @Override
    public ProducerBuilder<T> clone() {
        return new ProducerBuilderImpl<T>(this.client, this.conf.clone(), this.schema);
    }

    @Override
    public Producer<T> create() throws PulsarClientException {
        try {
            return this.createAsync().get();
        }
        catch (ExecutionException e) {
            Throwable t = e.getCause();
            if (t instanceof PulsarClientException) {
                throw (PulsarClientException)t;
            }
            throw new PulsarClientException(t);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new PulsarClientException(e);
        }
    }

    @Override
    public CompletableFuture<Producer<T>> createAsync() {
        if (this.conf.getTopicName() == null) {
            return FutureUtil.failedFuture(new IllegalArgumentException("Topic name must be set on the producer builder"));
        }
        return this.interceptorList == null || this.interceptorList.size() == 0 ? this.client.createProducerAsync(this.conf, this.schema, null) : this.client.createProducerAsync(this.conf, this.schema, new ProducerInterceptors<T>(this.interceptorList));
    }

    @Override
    public ProducerBuilder<T> loadConf(Map<String, Object> config) {
        this.conf = ConfigurationDataUtils.loadData(config, this.conf, ProducerConfigurationData.class);
        return this;
    }

    @Override
    public ProducerBuilder<T> topic(String topicName) {
        this.conf.setTopicName(topicName);
        return this;
    }

    @Override
    public ProducerBuilder<T> producerName(@NonNull String producerName) {
        if (producerName == null) {
            throw new NullPointerException("producerName is marked @NonNull but is null");
        }
        this.conf.setProducerName(producerName);
        return this;
    }

    @Override
    public ProducerBuilder<T> sendTimeout(int sendTimeout, @NonNull TimeUnit unit) {
        if (unit == null) {
            throw new NullPointerException("unit is marked @NonNull but is null");
        }
        if (sendTimeout < 0) {
            throw new IllegalArgumentException("sendTimeout needs to be >= 0");
        }
        this.conf.setSendTimeoutMs(unit.toMillis(sendTimeout));
        return this;
    }

    @Override
    public ProducerBuilder<T> maxPendingMessages(int maxPendingMessages) {
        if (maxPendingMessages <= 0) {
            throw new IllegalArgumentException("maxPendingMessages needs to be > 0");
        }
        this.conf.setMaxPendingMessages(maxPendingMessages);
        return this;
    }

    @Override
    public ProducerBuilder<T> maxPendingMessagesAcrossPartitions(int maxPendingMessagesAcrossPartitions) {
        this.conf.setMaxPendingMessagesAcrossPartitions(maxPendingMessagesAcrossPartitions);
        return this;
    }

    @Override
    public ProducerBuilder<T> blockIfQueueFull(boolean blockIfQueueFull) {
        this.conf.setBlockIfQueueFull(blockIfQueueFull);
        return this;
    }

    @Override
    public ProducerBuilder<T> messageRoutingMode(@NonNull MessageRoutingMode messageRouteMode) {
        if (messageRouteMode == null) {
            throw new NullPointerException("messageRouteMode is marked @NonNull but is null");
        }
        this.conf.setMessageRoutingMode(messageRouteMode);
        return this;
    }

    @Override
    public ProducerBuilder<T> compressionType(@NonNull CompressionType compressionType) {
        if (compressionType == null) {
            throw new NullPointerException("compressionType is marked @NonNull but is null");
        }
        this.conf.setCompressionType(compressionType);
        return this;
    }

    @Override
    public ProducerBuilder<T> hashingScheme(@NonNull HashingScheme hashingScheme) {
        if (hashingScheme == null) {
            throw new NullPointerException("hashingScheme is marked @NonNull but is null");
        }
        this.conf.setHashingScheme(hashingScheme);
        return this;
    }

    @Override
    public ProducerBuilder<T> messageRouter(@NonNull MessageRouter messageRouter) {
        if (messageRouter == null) {
            throw new NullPointerException("messageRouter is marked @NonNull but is null");
        }
        this.conf.setCustomMessageRouter(messageRouter);
        return this;
    }

    @Override
    public ProducerBuilder<T> enableBatching(boolean batchMessagesEnabled) {
        this.conf.setBatchingEnabled(batchMessagesEnabled);
        return this;
    }

    @Override
    public ProducerBuilder<T> cryptoKeyReader(@NonNull CryptoKeyReader cryptoKeyReader) {
        if (cryptoKeyReader == null) {
            throw new NullPointerException("cryptoKeyReader is marked @NonNull but is null");
        }
        this.conf.setCryptoKeyReader(cryptoKeyReader);
        return this;
    }

    @Override
    public ProducerBuilder<T> addEncryptionKey(@NonNull String key) {
        if (key == null) {
            throw new NullPointerException("key is marked @NonNull but is null");
        }
        this.conf.getEncryptionKeys().add(key);
        return this;
    }

    @Override
    public ProducerBuilder<T> cryptoFailureAction(@NonNull ProducerCryptoFailureAction action) {
        if (action == null) {
            throw new NullPointerException("action is marked @NonNull but is null");
        }
        this.conf.setCryptoFailureAction(action);
        return this;
    }

    @Override
    public ProducerBuilder<T> batchingMaxPublishDelay(long batchDelay, @NonNull TimeUnit timeUnit) {
        if (timeUnit == null) {
            throw new NullPointerException("timeUnit is marked @NonNull but is null");
        }
        this.conf.setBatchingMaxPublishDelayMicros(timeUnit.toMicros(batchDelay));
        return this;
    }

    @Override
    public ProducerBuilder<T> batchingMaxMessages(int batchMessagesMaxMessagesPerBatch) {
        this.conf.setBatchingMaxMessages(batchMessagesMaxMessagesPerBatch);
        return this;
    }

    @Override
    public ProducerBuilder<T> initialSequenceId(long initialSequenceId) {
        this.conf.setInitialSequenceId(initialSequenceId);
        return this;
    }

    @Override
    public ProducerBuilder<T> property(@NonNull String key, @NonNull String value) {
        if (key == null) {
            throw new NullPointerException("key is marked @NonNull but is null");
        }
        if (value == null) {
            throw new NullPointerException("value is marked @NonNull but is null");
        }
        this.conf.getProperties().put(key, value);
        return this;
    }

    @Override
    public ProducerBuilder<T> properties(@NonNull Map<String, String> properties) {
        if (properties == null) {
            throw new NullPointerException("properties is marked @NonNull but is null");
        }
        this.conf.getProperties().putAll(properties);
        return this;
    }

    @Override
    public ProducerBuilder<T> intercept(ProducerInterceptor<T> ... interceptors) {
        if (this.interceptorList == null) {
            this.interceptorList = new ArrayList<ProducerInterceptor<T>>();
        }
        this.interceptorList.addAll(Arrays.asList(interceptors));
        return this;
    }
}

