/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.shade.com.yahoo.sketches.tuple;

import org.apache.pulsar.shade.com.yahoo.memory.Memory;
import org.apache.pulsar.shade.com.yahoo.sketches.tuple.ArrayOfDoublesAnotB;
import org.apache.pulsar.shade.com.yahoo.sketches.tuple.ArrayOfDoublesIntersection;
import org.apache.pulsar.shade.com.yahoo.sketches.tuple.ArrayOfDoublesUnion;
import org.apache.pulsar.shade.com.yahoo.sketches.tuple.DirectArrayOfDoublesIntersection;
import org.apache.pulsar.shade.com.yahoo.sketches.tuple.DirectArrayOfDoublesUnion;
import org.apache.pulsar.shade.com.yahoo.sketches.tuple.HeapArrayOfDoublesAnotB;
import org.apache.pulsar.shade.com.yahoo.sketches.tuple.HeapArrayOfDoublesIntersection;
import org.apache.pulsar.shade.com.yahoo.sketches.tuple.HeapArrayOfDoublesUnion;

public class ArrayOfDoublesSetOperationBuilder {
    private int nomEntries_ = 4096;
    private int numValues_ = 1;
    private long seed_ = 9001L;
    private Memory dstMem_;
    private static final int DEFAULT_NOMINAL_ENTRIES = 4096;
    private static final int DEFAULT_NUMBER_OF_VALUES = 1;

    public ArrayOfDoublesSetOperationBuilder setNominalEntries(int nomEntries) {
        this.nomEntries_ = nomEntries;
        return this;
    }

    public ArrayOfDoublesSetOperationBuilder setNumberOfValues(int numValues) {
        this.numValues_ = numValues;
        return this;
    }

    public ArrayOfDoublesSetOperationBuilder setSeed(long seed) {
        this.seed_ = seed;
        return this;
    }

    public ArrayOfDoublesSetOperationBuilder setMemory(Memory dstMem) {
        this.dstMem_ = dstMem;
        return this;
    }

    public ArrayOfDoublesUnion buildUnion() {
        if (this.dstMem_ == null) {
            return new HeapArrayOfDoublesUnion(this.nomEntries_, this.numValues_, this.seed_);
        }
        return new DirectArrayOfDoublesUnion(this.nomEntries_, this.numValues_, this.seed_, this.dstMem_);
    }

    public ArrayOfDoublesIntersection buildIntersection() {
        if (this.dstMem_ == null) {
            return new HeapArrayOfDoublesIntersection(this.numValues_, this.seed_);
        }
        return new DirectArrayOfDoublesIntersection(this.numValues_, this.seed_, this.dstMem_);
    }

    public ArrayOfDoublesAnotB buildAnotB() {
        return new HeapArrayOfDoublesAnotB(this.numValues_, this.seed_);
    }
}

