/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.shade.org.asynchttpclient.netty.timeout;

import java.net.InetSocketAddress;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.pulsar.shade.io.netty.util.TimerTask;
import org.apache.pulsar.shade.org.asynchttpclient.netty.NettyResponseFuture;
import org.apache.pulsar.shade.org.asynchttpclient.netty.request.NettyRequestSender;
import org.apache.pulsar.shade.org.asynchttpclient.netty.timeout.TimeoutsHolder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class TimeoutTimerTask
implements TimerTask {
    private static final Logger LOGGER = LoggerFactory.getLogger(TimeoutTimerTask.class);
    protected final AtomicBoolean done = new AtomicBoolean();
    protected volatile NettyResponseFuture<?> nettyResponseFuture;
    protected final NettyRequestSender requestSender;
    protected final TimeoutsHolder timeoutsHolder;

    public TimeoutTimerTask(NettyResponseFuture<?> nettyResponseFuture, NettyRequestSender requestSender, TimeoutsHolder timeoutsHolder) {
        this.nettyResponseFuture = nettyResponseFuture;
        this.requestSender = requestSender;
        this.timeoutsHolder = timeoutsHolder;
    }

    protected void expire(String message, long time) {
        LOGGER.debug("{} for {} after {} ms", new Object[]{message, this.nettyResponseFuture, time});
        this.requestSender.abort(this.nettyResponseFuture.channel(), this.nettyResponseFuture, new TimeoutException(message));
    }

    public void clean() {
        if (this.done.compareAndSet(false, true)) {
            this.nettyResponseFuture = null;
        }
    }

    protected void appendRemoteAddress(StringBuilder sb) {
        InetSocketAddress remoteAddress = this.timeoutsHolder.remoteAddress();
        sb.append(remoteAddress.getHostName());
        if (!remoteAddress.isUnresolved()) {
            sb.append('/').append(remoteAddress.getAddress().getHostAddress());
        }
        sb.append(':').append(remoteAddress.getPort());
    }
}

