/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.shade.org.asynchttpclient.netty.handler.intercept;

import java.util.HashSet;
import java.util.Set;
import org.apache.pulsar.shade.io.netty.channel.Channel;
import org.apache.pulsar.shade.io.netty.handler.codec.http.HttpHeaderNames;
import org.apache.pulsar.shade.io.netty.handler.codec.http.HttpHeaders;
import org.apache.pulsar.shade.io.netty.handler.codec.http.HttpResponse;
import org.apache.pulsar.shade.io.netty.handler.codec.http.HttpUtil;
import org.apache.pulsar.shade.io.netty.handler.codec.http.cookie.ClientCookieDecoder;
import org.apache.pulsar.shade.io.netty.handler.codec.http.cookie.Cookie;
import org.apache.pulsar.shade.org.asynchttpclient.AsyncHttpClientConfig;
import org.apache.pulsar.shade.org.asynchttpclient.Realm;
import org.apache.pulsar.shade.org.asynchttpclient.Request;
import org.apache.pulsar.shade.org.asynchttpclient.RequestBuilder;
import org.apache.pulsar.shade.org.asynchttpclient.handler.MaxRedirectException;
import org.apache.pulsar.shade.org.asynchttpclient.netty.NettyResponseFuture;
import org.apache.pulsar.shade.org.asynchttpclient.netty.channel.ChannelManager;
import org.apache.pulsar.shade.org.asynchttpclient.netty.request.NettyRequestSender;
import org.apache.pulsar.shade.org.asynchttpclient.uri.Uri;
import org.apache.pulsar.shade.org.asynchttpclient.util.HttpConstants;
import org.apache.pulsar.shade.org.asynchttpclient.util.HttpUtils;
import org.apache.pulsar.shade.org.asynchttpclient.util.MiscUtils;
import org.apache.pulsar.shade.org.asynchttpclient.util.ThrowableUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Redirect30xInterceptor {
    public static final Set<Integer> REDIRECT_STATUSES = new HashSet<Integer>();
    private static final Logger LOGGER;
    private final ChannelManager channelManager;
    private final AsyncHttpClientConfig config;
    private final NettyRequestSender requestSender;
    private final MaxRedirectException maxRedirectException;

    public Redirect30xInterceptor(ChannelManager channelManager, AsyncHttpClientConfig config, NettyRequestSender requestSender) {
        this.channelManager = channelManager;
        this.config = config;
        this.requestSender = requestSender;
        this.maxRedirectException = ThrowableUtil.unknownStackTrace(new MaxRedirectException("Maximum redirect reached: " + config.getMaxRedirects()), Redirect30xInterceptor.class, "exitAfterHandlingRedirect");
    }

    public boolean exitAfterHandlingRedirect(Channel channel, NettyResponseFuture<?> future, HttpResponse response, Request request, int statusCode, Realm realm) throws Exception {
        if (HttpUtils.followRedirect(this.config, request)) {
            if (future.incrementAndGetCurrentRedirectCount() >= this.config.getMaxRedirects()) {
                throw this.maxRedirectException;
            }
            future.setInAuth(false);
            future.setInProxyAuth(false);
            String originalMethod = request.getMethod();
            boolean switchToGet = !originalMethod.equals(HttpConstants.Methods.GET) && (statusCode == HttpConstants.ResponseStatusCodes.MOVED_PERMANENTLY_301 || statusCode == HttpConstants.ResponseStatusCodes.SEE_OTHER_303 || statusCode == HttpConstants.ResponseStatusCodes.FOUND_302 && !this.config.isStrict302Handling());
            boolean keepBody = statusCode == HttpConstants.ResponseStatusCodes.TEMPORARY_REDIRECT_307 || statusCode == HttpConstants.ResponseStatusCodes.PERMANENT_REDIRECT_308 || statusCode == HttpConstants.ResponseStatusCodes.FOUND_302 && this.config.isStrict302Handling();
            RequestBuilder requestBuilder = (RequestBuilder)((RequestBuilder)((RequestBuilder)((RequestBuilder)((RequestBuilder)((RequestBuilder)((RequestBuilder)((RequestBuilder)new RequestBuilder(switchToGet ? HttpConstants.Methods.GET : originalMethod).setCookies(request.getCookies())).setChannelPoolPartitioning(request.getChannelPoolPartitioning())).setFollowRedirect(true)).setLocalAddress(request.getLocalAddress())).setNameResolver(request.getNameResolver())).setProxyServer(request.getProxyServer())).setRealm(request.getRealm())).setRequestTimeout(request.getRequestTimeout());
            if (keepBody) {
                requestBuilder.setCharset(request.getCharset());
                if (MiscUtils.isNonEmpty(request.getFormParams())) {
                    requestBuilder.setFormParams(request.getFormParams());
                } else if (request.getStringData() != null) {
                    requestBuilder.setBody(request.getStringData());
                } else if (request.getByteData() != null) {
                    requestBuilder.setBody(request.getByteData());
                } else if (request.getByteBufferData() != null) {
                    requestBuilder.setBody(request.getByteBufferData());
                } else if (request.getBodyGenerator() != null) {
                    requestBuilder.setBody(request.getBodyGenerator());
                }
            }
            requestBuilder.setHeaders(this.propagatedHeaders(request, realm, keepBody));
            boolean initialConnectionKeepAlive = future.isKeepAlive();
            Object initialPartitionKey = future.getPartitionKey();
            HttpHeaders responseHeaders = response.headers();
            String location = responseHeaders.get(HttpHeaderNames.LOCATION);
            Uri newUri = Uri.create(future.getUri(), location);
            LOGGER.debug("Redirecting to {}", (Object)newUri);
            for (String cookieStr : responseHeaders.getAll(HttpHeaderNames.SET_COOKIE)) {
                Cookie c = ClientCookieDecoder.STRICT.decode(cookieStr);
                if (c == null) continue;
                requestBuilder.addOrReplaceCookie(c);
            }
            boolean sameBase = HttpUtils.isSameBase(request.getUri(), newUri);
            if (sameBase) {
                requestBuilder.setVirtualHost(request.getVirtualHost());
            }
            Request nextRequest = ((RequestBuilder)requestBuilder.setUri(newUri)).build();
            future.setTargetRequest(nextRequest);
            LOGGER.debug("Sending redirect to {}", (Object)newUri);
            if (future.isKeepAlive() && !HttpUtil.isTransferEncodingChunked(response)) {
                if (sameBase) {
                    future.setReuseChannel(true);
                    this.requestSender.drainChannelAndExecuteNextRequest(channel, future, nextRequest);
                } else {
                    this.channelManager.drainChannelAndOffer(channel, future, initialConnectionKeepAlive, initialPartitionKey);
                    this.requestSender.sendNextRequest(nextRequest, future);
                }
            } else {
                this.channelManager.closeChannel(channel);
                this.requestSender.sendNextRequest(nextRequest, future);
            }
            return true;
        }
        return false;
    }

    private HttpHeaders propagatedHeaders(Request request, Realm realm, boolean keepBody) {
        HttpHeaders headers = request.getHeaders().remove(HttpHeaderNames.HOST).remove(HttpHeaderNames.CONTENT_LENGTH);
        if (!keepBody) {
            headers.remove(HttpHeaderNames.CONTENT_TYPE);
        }
        if (realm != null && realm.getScheme() == Realm.AuthScheme.NTLM) {
            headers.remove(HttpHeaderNames.AUTHORIZATION).remove(HttpHeaderNames.PROXY_AUTHORIZATION);
        }
        return headers;
    }

    static {
        REDIRECT_STATUSES.add(HttpConstants.ResponseStatusCodes.MOVED_PERMANENTLY_301);
        REDIRECT_STATUSES.add(HttpConstants.ResponseStatusCodes.FOUND_302);
        REDIRECT_STATUSES.add(HttpConstants.ResponseStatusCodes.SEE_OTHER_303);
        REDIRECT_STATUSES.add(HttpConstants.ResponseStatusCodes.TEMPORARY_REDIRECT_307);
        REDIRECT_STATUSES.add(HttpConstants.ResponseStatusCodes.PERMANENT_REDIRECT_308);
        LOGGER = LoggerFactory.getLogger(Redirect30xInterceptor.class);
    }
}

