/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.shade.org.asynchttpclient.netty.channel;

import java.net.ConnectException;
import java.net.InetSocketAddress;
import org.apache.pulsar.shade.io.netty.channel.Channel;
import org.apache.pulsar.shade.io.netty.handler.codec.http.HttpRequest;
import org.apache.pulsar.shade.io.netty.handler.ssl.SslHandler;
import org.apache.pulsar.shade.io.netty.util.concurrent.Future;
import org.apache.pulsar.shade.io.netty.util.concurrent.GenericFutureListener;
import org.apache.pulsar.shade.org.asynchttpclient.Request;
import org.apache.pulsar.shade.org.asynchttpclient.handler.AsyncHandlerExtensions;
import org.apache.pulsar.shade.org.asynchttpclient.handler.AsyncHandlerExtensionsUtils;
import org.apache.pulsar.shade.org.asynchttpclient.netty.NettyResponseFuture;
import org.apache.pulsar.shade.org.asynchttpclient.netty.SimpleFutureListener;
import org.apache.pulsar.shade.org.asynchttpclient.netty.channel.ChannelManager;
import org.apache.pulsar.shade.org.asynchttpclient.netty.channel.ChannelState;
import org.apache.pulsar.shade.org.asynchttpclient.netty.channel.Channels;
import org.apache.pulsar.shade.org.asynchttpclient.netty.channel.ConnectionSemaphore;
import org.apache.pulsar.shade.org.asynchttpclient.netty.future.StackTraceInspector;
import org.apache.pulsar.shade.org.asynchttpclient.netty.request.NettyRequestSender;
import org.apache.pulsar.shade.org.asynchttpclient.netty.timeout.TimeoutsHolder;
import org.apache.pulsar.shade.org.asynchttpclient.uri.Uri;
import org.apache.pulsar.shade.org.asynchttpclient.util.HttpUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class NettyConnectListener<T> {
    private static final Logger LOGGER = LoggerFactory.getLogger(NettyConnectListener.class);
    private final NettyRequestSender requestSender;
    private final NettyResponseFuture<T> future;
    private final ChannelManager channelManager;
    private final ConnectionSemaphore connectionSemaphore;
    private final Object partitionKey;

    public NettyConnectListener(NettyResponseFuture<T> future, NettyRequestSender requestSender, ChannelManager channelManager, ConnectionSemaphore connectionSemaphore, Object partitionKey) {
        this.future = future;
        this.requestSender = requestSender;
        this.channelManager = channelManager;
        this.connectionSemaphore = connectionSemaphore;
        this.partitionKey = partitionKey;
    }

    private boolean futureIsAlreadyCancelled(Channel channel) {
        if (this.future.isDone()) {
            Channels.silentlyCloseChannel(channel);
            return true;
        }
        return false;
    }

    private void writeRequest(Channel channel) {
        if (this.futureIsAlreadyCancelled(channel)) {
            return;
        }
        if (LOGGER.isDebugEnabled()) {
            HttpRequest httpRequest = this.future.getNettyRequest().getHttpRequest();
            LOGGER.debug("Using new Channel '{}' for '{}' to '{}'", new Object[]{channel, httpRequest.method(), httpRequest.uri()});
        }
        Channels.setAttribute(channel, this.future);
        this.channelManager.registerOpenChannel(channel, this.partitionKey);
        this.future.attachChannel(channel, false);
        this.requestSender.writeRequest(this.future, channel);
    }

    public void onSuccess(final Channel channel, InetSocketAddress remoteAddress) {
        Object partitionKeyLock;
        if (this.connectionSemaphore != null && (partitionKeyLock = this.future.takePartitionKeyLock()) != null) {
            channel.closeFuture().addListener((GenericFutureListener<? extends Future<? super Void>>)new GenericFutureListener<Future<? super Void>>(){

                @Override
                public void operationComplete(Future<? super Void> future) throws Exception {
                    NettyConnectListener.this.connectionSemaphore.releaseChannelLock(partitionKeyLock);
                }
            });
        }
        Channels.setActiveToken(channel);
        TimeoutsHolder timeoutsHolder = this.future.getTimeoutsHolder();
        if (this.futureIsAlreadyCancelled(channel)) {
            return;
        }
        Request request = this.future.getTargetRequest();
        Uri uri = request.getUri();
        timeoutsHolder.setResolvedRemoteAddress(remoteAddress);
        if (this.future.getProxyServer() == null && uri.isSecured()) {
            SslHandler sslHandler = null;
            try {
                sslHandler = this.channelManager.addSslHandler(channel.pipeline(), uri, request.getVirtualHost());
            }
            catch (Exception sslError) {
                this.onFailure(channel, sslError);
                return;
            }
            final AsyncHandlerExtensions asyncHandlerExtensions = AsyncHandlerExtensionsUtils.toAsyncHandlerExtensions(this.future.getAsyncHandler());
            if (asyncHandlerExtensions != null) {
                try {
                    asyncHandlerExtensions.onTlsHandshakeAttempt();
                }
                catch (Exception e) {
                    LOGGER.error("onTlsHandshakeAttempt crashed", (Throwable)e);
                    this.onFailure(channel, e);
                    return;
                }
            }
            sslHandler.handshakeFuture().addListener((GenericFutureListener<Future<Channel>>)new SimpleFutureListener<Channel>(){

                @Override
                protected void onSuccess(Channel value) throws Exception {
                    if (asyncHandlerExtensions != null) {
                        try {
                            asyncHandlerExtensions.onTlsHandshakeSuccess();
                        }
                        catch (Exception e) {
                            LOGGER.error("onTlsHandshakeSuccess crashed", (Throwable)e);
                            NettyConnectListener.this.onFailure(channel, e);
                            return;
                        }
                    }
                    NettyConnectListener.this.writeRequest(channel);
                }

                @Override
                protected void onFailure(Throwable cause) throws Exception {
                    if (asyncHandlerExtensions != null) {
                        try {
                            asyncHandlerExtensions.onTlsHandshakeFailure(cause);
                        }
                        catch (Exception e) {
                            LOGGER.error("onTlsHandshakeFailure crashed", (Throwable)e);
                            NettyConnectListener.this.onFailure(channel, e);
                            return;
                        }
                    }
                    NettyConnectListener.this.onFailure(channel, cause);
                }
            });
        } else {
            this.writeRequest(channel);
        }
    }

    public void onFailure(Channel channel, Throwable cause) {
        Channels.silentlyCloseChannel(channel);
        boolean canRetry = this.future.incrementRetryAndCheck();
        LOGGER.debug("Trying to recover from failing to connect channel {} with a retry value of {} ", (Object)channel, (Object)canRetry);
        if (canRetry && cause != null && (this.future.getChannelState() != ChannelState.NEW || StackTraceInspector.recoverOnNettyDisconnectException(cause)) && this.requestSender.retry(this.future)) {
            return;
        }
        LOGGER.debug("Failed to recover from connect exception: {} with channel {}", (Object)cause, (Object)channel);
        boolean printCause = cause.getMessage() != null;
        String printedCause = printCause ? cause.getMessage() : HttpUtils.getBaseUrl(this.future.getUri());
        ConnectException e = new ConnectException(printedCause);
        e.initCause(cause);
        this.future.abort(e);
    }
}

