/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.shade.com.scurrilous.circe.utils;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Locale;
import org.apache.pulsar.shade.com.google.common.base.Preconditions;

public class NativeUtils {
    public static final String OS_NAME = System.getProperty("os.name").toLowerCase(Locale.US);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void loadLibraryFromJar(String path) throws Exception {
        Preconditions.checkArgument(path.startsWith("/"), "absolute path must start with  /");
        String[] parts = path.split("/");
        String filename = parts.length > 0 ? parts[parts.length - 1] : null;
        File dir = File.createTempFile("native", "");
        dir.delete();
        if (!dir.mkdir()) {
            throw new IOException("Failed to create temp directory " + dir.getAbsolutePath());
        }
        dir.deleteOnExit();
        File temp = new File(dir, filename);
        temp.deleteOnExit();
        byte[] buffer = new byte[1024];
        InputStream input = NativeUtils.class.getResourceAsStream(path);
        if (input == null) {
            throw new FileNotFoundException("Couldn't find file into jar " + path);
        }
        FileOutputStream out = new FileOutputStream(temp);
        try {
            int read;
            while ((read = input.read(buffer)) != -1) {
                ((OutputStream)out).write(buffer, 0, read);
            }
        }
        finally {
            ((OutputStream)out).close();
            input.close();
        }
        if (!temp.exists()) {
            throw new FileNotFoundException("Failed to copy file from jar at " + temp.getAbsolutePath());
        }
        System.load(temp.getAbsolutePath());
    }

    public static String libType() {
        if (OS_NAME.indexOf("mac") >= 0) {
            return "jnilib";
        }
        if (OS_NAME.indexOf("nix") >= 0 || OS_NAME.indexOf("nux") >= 0 || OS_NAME.indexOf("aix") > 0) {
            return "so";
        }
        if (OS_NAME.indexOf("win") >= 0) {
            return "dll";
        }
        throw new TypeNotPresentException(OS_NAME + " not supported", null);
    }
}

