/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.shade.com.scurrilous.circe.impl;

import java.nio.ByteBuffer;
import org.apache.pulsar.shade.com.scurrilous.circe.IncrementalLongHash;
import org.apache.pulsar.shade.com.scurrilous.circe.StatefulLongHash;
import org.apache.pulsar.shade.com.scurrilous.circe.impl.IncrementalLongStatefulHash;

public abstract class AbstractIncrementalLongHash
implements IncrementalLongHash {
    @Override
    public boolean supportsUnsafe() {
        return false;
    }

    @Override
    public StatefulLongHash createStateful() {
        return new IncrementalLongStatefulHash(this);
    }

    @Override
    public long calculate(byte[] input) {
        return this.resume(this.initial(), input);
    }

    @Override
    public long calculate(byte[] input, int index, int length) {
        return this.resume(this.initial(), input, index, length);
    }

    @Override
    public long calculate(ByteBuffer input) {
        return this.resume(this.initial(), input);
    }

    @Override
    public long calculate(long address, long length) {
        return this.resume(this.initial(), address, length);
    }

    @Override
    public long resume(long current, byte[] input) {
        return this.resumeUnchecked(current, input, 0, input.length);
    }

    @Override
    public long resume(long current, byte[] input, int index, int length) {
        if (length < 0) {
            throw new IllegalArgumentException();
        }
        if (index < 0 || index + length > input.length) {
            throw new IndexOutOfBoundsException();
        }
        return this.resumeUnchecked(current, input, index, length);
    }

    @Override
    public long resume(long current, ByteBuffer input) {
        int index;
        byte[] array;
        int length = input.remaining();
        if (input.hasArray()) {
            array = input.array();
            index = input.arrayOffset() + input.position();
            input.position(input.limit());
        } else {
            array = new byte[length];
            index = 0;
            input.get(array);
        }
        return this.resumeUnchecked(current, array, index, length);
    }

    @Override
    public long resume(long current, long address, long length) {
        throw new UnsupportedOperationException();
    }

    protected abstract long initial();

    protected abstract long resumeUnchecked(long var1, byte[] var3, int var4, int var5);
}

