/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.shade.com.scurrilous.circe;

import java.util.Comparator;
import java.util.EnumSet;
import java.util.Iterator;

public enum HashSupport {
    HARDWARE_INCREMENTAL(10),
    HARDWARE(20),
    NATIVE_INCREMENTAL(30),
    NATIVE(40),
    UNSAFE_INCREMENTAL(50),
    UNSAFE(60),
    STATELESS_INCREMENTAL(70),
    INCREMENTAL(80),
    INT_SIZED(90),
    LONG_SIZED(90),
    STATEFUL(100);

    public static final int MIN_PRIORITY = 0;
    public static final int MAX_PRIORITY = 110;
    private final int priority;

    private HashSupport(int priority) {
        this.priority = priority;
    }

    public int getPriority() {
        return this.priority;
    }

    public static int getMaxPriority(EnumSet<HashSupport> set) {
        if (set.isEmpty()) {
            return 110;
        }
        return ((HashSupport)((Object)set.iterator().next())).getPriority();
    }

    public static int compare(EnumSet<HashSupport> set1, EnumSet<HashSupport> set2) {
        Iterator i1 = set1.iterator();
        Iterator i2 = set2.iterator();
        int floor = 0;
        while (i1.hasNext() || i2.hasNext()) {
            int p2;
            int p1;
            while ((p1 = i1.hasNext() ? ((HashSupport)((Object)i1.next())).getPriority() : 110) == floor) {
            }
            while ((p2 = i2.hasNext() ? ((HashSupport)((Object)i2.next())).getPriority() : 110) == floor) {
            }
            if (p1 < p2) {
                return -1;
            }
            if (p1 > p2) {
                return 1;
            }
            floor = p1;
        }
        return 0;
    }

    static final class SetComparator
    implements Comparator<EnumSet<HashSupport>> {
        SetComparator() {
        }

        @Override
        public int compare(EnumSet<HashSupport> o1, EnumSet<HashSupport> o2) {
            return HashSupport.compare(o1, o2);
        }
    }
}

