/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.common.policies.data;

import java.util.Map;
import java.util.Optional;
import java.util.TreeMap;
import org.apache.pulsar.common.policies.data.BookieInfo;
import org.apache.pulsar.shade.com.google.common.base.Preconditions;

public class BookiesRackConfiguration
extends TreeMap<String, Map<String, BookieInfo>> {
    public boolean removeBookie(String address) {
        for (Map m : this.values()) {
            if (m.remove(address) == null) continue;
            return true;
        }
        return false;
    }

    public Optional<BookieInfo> getBookie(String address) {
        for (Map m : this.values()) {
            BookieInfo bi = (BookieInfo)m.get(address);
            if (bi == null) continue;
            return Optional.of(bi);
        }
        return Optional.empty();
    }

    public void updateBookie(String group, String address, BookieInfo bookieInfo) {
        Preconditions.checkNotNull(group);
        Preconditions.checkNotNull(address);
        Preconditions.checkNotNull(bookieInfo);
        this.removeBookie(address);
        this.computeIfAbsent(group, key -> new TreeMap()).put(address, bookieInfo);
    }
}

