/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.common.nar;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.apache.pulsar.common.nar.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NarUnpacker {
    private static final Logger log = LoggerFactory.getLogger(NarUnpacker.class);
    private static String HASH_FILENAME = "nar-md5sum";

    public static File unpackNar(File nar, File baseWorkingDirectory) throws IOException {
        File narWorkingDirectory = new File(baseWorkingDirectory, nar.getName() + "-unpacked");
        if (!narWorkingDirectory.exists()) {
            NarUnpacker.unpack(nar, narWorkingDirectory, NarUnpacker.calculateMd5sum(nar));
        } else {
            byte[] narMd5 = NarUnpacker.calculateMd5sum(nar);
            File workingHashFile = new File(narWorkingDirectory, HASH_FILENAME);
            if (!workingHashFile.exists()) {
                FileUtils.deleteFile(narWorkingDirectory, true);
                NarUnpacker.unpack(nar, narWorkingDirectory, narMd5);
            } else {
                byte[] hashFileContents = Files.readAllBytes(workingHashFile.toPath());
                if (!Arrays.equals(hashFileContents, narMd5)) {
                    log.info("Contents of nar {} have changed. Reloading.", (Object)nar.getAbsolutePath());
                    FileUtils.deleteFile(narWorkingDirectory, true);
                    NarUnpacker.unpack(nar, narWorkingDirectory, narMd5);
                }
            }
        }
        return narWorkingDirectory;
    }

    private static void unpack(File nar, File workingDirectory, byte[] hash) throws IOException {
        try (JarFile jarFile = new JarFile(nar);){
            Enumeration<JarEntry> jarEntries = jarFile.entries();
            while (jarEntries.hasMoreElements()) {
                JarEntry jarEntry = jarEntries.nextElement();
                String name = jarEntry.getName();
                File f = new File(workingDirectory, name);
                if (jarEntry.isDirectory()) {
                    FileUtils.ensureDirectoryExistAndCanReadAndWrite(f);
                    continue;
                }
                NarUnpacker.makeFile(jarFile.getInputStream(jarEntry), f);
            }
        }
        File hashFile = new File(workingDirectory, HASH_FILENAME);
        try (FileOutputStream fos = new FileOutputStream(hashFile);){
            fos.write(hash);
        }
    }

    private static void makeFile(InputStream inputStream, File file) throws IOException {
        try (InputStream in = inputStream;
             FileOutputStream fos = new FileOutputStream(file);){
            int numRead;
            byte[] bytes = new byte[65536];
            while ((numRead = in.read(bytes)) != -1) {
                fos.write(bytes, 0, numRead);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static byte[] calculateMd5sum(File file) throws IOException {
        try (FileInputStream inputStream = new FileInputStream(file);){
            MessageDigest md5 = MessageDigest.getInstance("md5");
            byte[] buffer = new byte[1024];
            int read = inputStream.read(buffer);
            while (read > -1) {
                md5.update(buffer, 0, read);
                read = inputStream.read(buffer);
            }
            byte[] byArray = md5.digest();
            return byArray;
        }
        catch (NoSuchAlgorithmException nsae) {
            throw new IllegalArgumentException(nsae);
        }
    }
}

