/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.client.impl;

import java.nio.ByteBuffer;
import java.util.List;
import java.util.Map;
import org.apache.pulsar.client.api.Message;
import org.apache.pulsar.client.api.MessageBuilder;
import org.apache.pulsar.client.api.Schema;
import org.apache.pulsar.client.impl.MessageImpl;
import org.apache.pulsar.common.api.proto.PulsarApi;
import org.apache.pulsar.shade.com.google.common.base.Preconditions;

public class MessageBuilderImpl<T>
implements MessageBuilder<T> {
    private static final ByteBuffer EMPTY_CONTENT = ByteBuffer.allocate(0);
    private final PulsarApi.MessageMetadata.Builder msgMetadataBuilder = PulsarApi.MessageMetadata.newBuilder();
    private final Schema<T> schema;
    private ByteBuffer content = EMPTY_CONTENT;

    public MessageBuilderImpl(Schema<T> schema) {
        this.schema = schema;
    }

    @Override
    public Message<T> build() {
        return MessageImpl.create(this.msgMetadataBuilder, this.content, this.schema);
    }

    @Override
    public MessageBuilder<T> setValue(T value) {
        return this.setContent(this.schema.encode(value));
    }

    @Override
    public MessageBuilder<T> setContent(byte[] data) {
        this.setContent(data, 0, data.length);
        return this;
    }

    @Override
    public MessageBuilder<T> setContent(byte[] data, int offet, int length) {
        this.content = ByteBuffer.wrap(data, offet, length);
        return this;
    }

    @Override
    public MessageBuilder<T> setContent(ByteBuffer buf) {
        this.content = buf.duplicate();
        return this;
    }

    @Override
    public MessageBuilder<T> setProperties(Map<String, String> properties) {
        for (Map.Entry<String, String> entry : properties.entrySet()) {
            this.msgMetadataBuilder.addProperties(PulsarApi.KeyValue.newBuilder().setKey(entry.getKey()).setValue(entry.getValue()).build());
        }
        return this;
    }

    @Override
    public MessageBuilder<T> setProperty(String name, String value) {
        this.msgMetadataBuilder.addProperties(PulsarApi.KeyValue.newBuilder().setKey(name).setValue(value).build());
        return this;
    }

    @Override
    public MessageBuilder<T> setKey(String key) {
        this.msgMetadataBuilder.setPartitionKey(key);
        return this;
    }

    @Override
    public MessageBuilder<T> setEventTime(long timestamp) {
        Preconditions.checkArgument(timestamp > 0L, "Invalid timestamp : '%s'", timestamp);
        this.msgMetadataBuilder.setEventTime(timestamp);
        return this;
    }

    @Override
    public MessageBuilder<T> setSequenceId(long sequenceId) {
        Preconditions.checkArgument(sequenceId >= 0L);
        this.msgMetadataBuilder.setSequenceId(sequenceId);
        return this;
    }

    @Override
    public MessageBuilder<T> setReplicationClusters(List<String> clusters) {
        Preconditions.checkNotNull(clusters);
        this.msgMetadataBuilder.clearReplicateTo();
        this.msgMetadataBuilder.addAllReplicateTo(clusters);
        return this;
    }

    @Override
    public MessageBuilder<T> disableReplication() {
        this.msgMetadataBuilder.clearReplicateTo();
        this.msgMetadataBuilder.addReplicateTo("__local__");
        return this;
    }
}

