/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.client.api.url;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLStreamHandler;
import java.util.Base64;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class DataURLStreamHandler
extends URLStreamHandler {
    @Override
    protected URLConnection openConnection(URL u) throws IOException {
        return new DataURLConnection(u);
    }

    class DataURLConnection
    extends URLConnection {
        private boolean parsed;
        private String contentType;
        private String data;
        private URI uri;

        protected DataURLConnection(URL url) {
            super(url);
            this.parsed = false;
            try {
                this.uri = this.url.toURI();
            }
            catch (URISyntaxException e) {
                this.uri = null;
            }
        }

        @Override
        public void connect() throws IOException {
            if (this.parsed) {
                return;
            }
            if (this.uri == null) {
                throw new IOException();
            }
            Pattern pattern = Pattern.compile("(?<mimeType>.+?)(;(?<charset>charset=.+?))?(;(?<base64>base64?))?,(?<data>.+)", 32);
            Matcher matcher = pattern.matcher(this.uri.getSchemeSpecificPart());
            if (matcher.matches()) {
                this.contentType = matcher.group("mimeType");
                String charset = matcher.group("charset");
                if (charset == null) {
                    charset = "US-ASCII";
                }
                this.data = matcher.group("base64") == null ? new String(matcher.group("data").getBytes(), charset) : new String(Base64.getDecoder().decode(matcher.group("data")), charset);
            } else {
                throw new MalformedURLException();
            }
            this.parsed = true;
        }

        @Override
        public long getContentLengthLong() {
            long length;
            try {
                this.connect();
                length = this.data.length();
            }
            catch (IOException e) {
                length = -1L;
            }
            return length;
        }

        @Override
        public String getContentType() {
            String contentType;
            try {
                this.connect();
                contentType = this.contentType;
            }
            catch (IOException e) {
                contentType = null;
            }
            return contentType;
        }

        @Override
        public String getContentEncoding() {
            return "identity";
        }

        @Override
        public InputStream getInputStream() throws IOException {
            this.connect();
            return new ByteArrayInputStream(this.data.getBytes());
        }
    }
}

