/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.client.api;

import java.io.Closeable;
import java.util.concurrent.CompletableFuture;
import org.apache.pulsar.client.api.ClientBuilder;
import org.apache.pulsar.client.api.ClientConfiguration;
import org.apache.pulsar.client.api.Consumer;
import org.apache.pulsar.client.api.ConsumerBuilder;
import org.apache.pulsar.client.api.ConsumerConfiguration;
import org.apache.pulsar.client.api.MessageId;
import org.apache.pulsar.client.api.Producer;
import org.apache.pulsar.client.api.ProducerBuilder;
import org.apache.pulsar.client.api.ProducerConfiguration;
import org.apache.pulsar.client.api.PulsarClientException;
import org.apache.pulsar.client.api.Reader;
import org.apache.pulsar.client.api.ReaderBuilder;
import org.apache.pulsar.client.api.ReaderConfiguration;
import org.apache.pulsar.client.api.Schema;
import org.apache.pulsar.client.impl.ClientBuilderImpl;
import org.apache.pulsar.client.impl.PulsarClientImpl;

public interface PulsarClient
extends Closeable {
    public static ClientBuilder builder() {
        return new ClientBuilderImpl();
    }

    @Deprecated
    public static PulsarClient create(String serviceUrl) throws PulsarClientException {
        return PulsarClient.create(serviceUrl, new ClientConfiguration());
    }

    @Deprecated
    public static PulsarClient create(String serviceUrl, ClientConfiguration conf) throws PulsarClientException {
        return new PulsarClientImpl(serviceUrl, conf);
    }

    public ProducerBuilder<byte[]> newProducer();

    public <T> ProducerBuilder<T> newProducer(Schema<T> var1);

    public ConsumerBuilder<byte[]> newConsumer();

    public <T> ConsumerBuilder<T> newConsumer(Schema<T> var1);

    public ReaderBuilder<byte[]> newReader();

    public <T> ReaderBuilder<T> newReader(Schema<T> var1);

    @Deprecated
    public Producer<byte[]> createProducer(String var1) throws PulsarClientException;

    @Deprecated
    public CompletableFuture<Producer<byte[]>> createProducerAsync(String var1);

    @Deprecated
    public Producer<byte[]> createProducer(String var1, ProducerConfiguration var2) throws PulsarClientException;

    @Deprecated
    public CompletableFuture<Producer<byte[]>> createProducerAsync(String var1, ProducerConfiguration var2);

    @Deprecated
    public Consumer<byte[]> subscribe(String var1, String var2) throws PulsarClientException;

    @Deprecated
    public CompletableFuture<Consumer<byte[]>> subscribeAsync(String var1, String var2);

    @Deprecated
    public Consumer<byte[]> subscribe(String var1, String var2, ConsumerConfiguration var3) throws PulsarClientException;

    @Deprecated
    public CompletableFuture<Consumer<byte[]>> subscribeAsync(String var1, String var2, ConsumerConfiguration var3);

    @Deprecated
    public Reader<byte[]> createReader(String var1, MessageId var2, ReaderConfiguration var3) throws PulsarClientException;

    @Deprecated
    public CompletableFuture<Reader<byte[]>> createReaderAsync(String var1, MessageId var2, ReaderConfiguration var3);

    @Override
    public void close() throws PulsarClientException;

    public CompletableFuture<Void> closeAsync();

    public void shutdown() throws PulsarClientException;
}

