/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.client.impl.schema.generic;

import com.google.common.collect.Lists;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import org.apache.pulsar.client.api.schema.Field;
import org.apache.pulsar.client.api.schema.GenericRecord;
import org.apache.pulsar.shade.com.fasterxml.jackson.databind.JsonNode;

class GenericJsonRecord
implements GenericRecord {
    private final List<Field> fields;
    private final JsonNode jn;

    GenericJsonRecord(List<Field> fields, JsonNode jn) {
        this.fields = fields;
        this.jn = jn;
    }

    JsonNode getJsonNode() {
        return this.jn;
    }

    @Override
    public List<Field> getFields() {
        return this.fields;
    }

    @Override
    public Object getField(String fieldName) {
        JsonNode fn = this.jn.get(fieldName);
        if (fn.isContainerNode()) {
            AtomicInteger idx = new AtomicInteger(0);
            List<Field> fields = Lists.newArrayList(fn.fieldNames()).stream().map(f -> new Field((String)f, idx.getAndIncrement())).collect(Collectors.toList());
            return new GenericJsonRecord(fields, fn);
        }
        if (fn.isBoolean()) {
            return fn.asBoolean();
        }
        if (fn.isInt()) {
            return fn.asInt();
        }
        if (fn.isFloatingPointNumber()) {
            return fn.asDouble();
        }
        if (fn.isDouble()) {
            return fn.asDouble();
        }
        return fn.asText();
    }
}

