/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.client.impl.schema.generic;

import com.google.common.base.Preconditions;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import org.apache.pulsar.client.api.SchemaSerializationException;
import org.apache.pulsar.client.impl.schema.generic.GenericAvroRecord;
import org.apache.pulsar.client.impl.schema.generic.GenericSchema;
import org.apache.pulsar.common.schema.SchemaInfo;
import org.apache.pulsar.shade.org.apache.avro.generic.GenericDatumReader;
import org.apache.pulsar.shade.org.apache.avro.generic.GenericDatumWriter;
import org.apache.pulsar.shade.org.apache.avro.generic.GenericRecord;
import org.apache.pulsar.shade.org.apache.avro.io.BinaryDecoder;
import org.apache.pulsar.shade.org.apache.avro.io.BinaryEncoder;
import org.apache.pulsar.shade.org.apache.avro.io.DecoderFactory;
import org.apache.pulsar.shade.org.apache.avro.io.EncoderFactory;

class GenericAvroSchema
extends GenericSchema {
    private final GenericDatumWriter<GenericRecord> datumWriter;
    private BinaryEncoder encoder;
    private final ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
    private final GenericDatumReader<GenericRecord> datumReader;

    public GenericAvroSchema(SchemaInfo schemaInfo) {
        super(schemaInfo);
        this.encoder = EncoderFactory.get().binaryEncoder(this.byteArrayOutputStream, this.encoder);
        this.datumWriter = new GenericDatumWriter(this.schema);
        this.datumReader = new GenericDatumReader(this.schema);
    }

    @Override
    public synchronized byte[] encode(org.apache.pulsar.client.api.schema.GenericRecord message) {
        Preconditions.checkArgument((boolean)(message instanceof GenericAvroRecord));
        GenericAvroRecord gar = (GenericAvroRecord)message;
        try {
            this.datumWriter.write(gar.getAvroRecord(), this.encoder);
            this.encoder.flush();
            byte[] byArray = this.byteArrayOutputStream.toByteArray();
            return byArray;
        }
        catch (Exception e) {
            throw new SchemaSerializationException(e);
        }
        finally {
            this.byteArrayOutputStream.reset();
        }
    }

    @Override
    public org.apache.pulsar.client.api.schema.GenericRecord decode(byte[] bytes) {
        try {
            BinaryDecoder decoder = DecoderFactory.get().binaryDecoder(bytes, null);
            GenericRecord avroRecord = this.datumReader.read(null, decoder);
            return new GenericAvroRecord(this.schema, this.fields, avroRecord);
        }
        catch (IOException e) {
            throw new SchemaSerializationException(e);
        }
    }
}

