/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.client.impl.schema.generic;

import java.util.List;
import java.util.stream.Collectors;
import org.apache.pulsar.client.api.schema.Field;
import org.apache.pulsar.shade.org.apache.avro.Schema;
import org.apache.pulsar.shade.org.apache.avro.generic.GenericRecord;
import org.apache.pulsar.shade.org.apache.avro.util.Utf8;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class GenericAvroRecord
implements org.apache.pulsar.client.api.schema.GenericRecord {
    private static final Logger log = LoggerFactory.getLogger(GenericAvroRecord.class);
    private final Schema schema;
    private final List<Field> fields;
    private final GenericRecord record;

    GenericAvroRecord(Schema schema, List<Field> fields, GenericRecord record) {
        this.schema = schema;
        this.fields = fields;
        this.record = record;
    }

    @Override
    public List<Field> getFields() {
        return this.fields;
    }

    @Override
    public Object getField(String fieldName) {
        Object value = this.record.get(fieldName);
        if (value instanceof Utf8) {
            return ((Utf8)value).toString();
        }
        if (value instanceof GenericRecord) {
            GenericRecord avroRecord = (GenericRecord)value;
            Schema recordSchema = avroRecord.getSchema();
            List<Field> fields = recordSchema.getFields().stream().map(f -> new Field(f.name(), f.pos())).collect(Collectors.toList());
            return new GenericAvroRecord(this.schema, fields, avroRecord);
        }
        return value;
    }

    GenericRecord getAvroRecord() {
        return this.record;
    }
}

