/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.client.impl.schema;

import org.apache.pulsar.client.api.Schema;
import org.apache.pulsar.common.schema.SchemaInfo;
import org.apache.pulsar.common.schema.SchemaType;
import org.apache.pulsar.shade.io.netty.buffer.ByteBuf;
import org.apache.pulsar.shade.io.netty.buffer.ByteBufUtil;
import org.apache.pulsar.shade.io.netty.buffer.Unpooled;

public class ByteBufSchema
implements Schema<ByteBuf> {
    private static final ByteBufSchema INSTANCE = new ByteBufSchema();
    private static final SchemaInfo SCHEMA_INFO = new SchemaInfo().setName("ByteBuf").setType(SchemaType.BYTES).setSchema(new byte[0]);

    public static ByteBufSchema of() {
        return INSTANCE;
    }

    @Override
    public byte[] encode(ByteBuf message) {
        if (message == null) {
            return null;
        }
        return ByteBufUtil.getBytes((ByteBuf)message);
    }

    @Override
    public ByteBuf decode(byte[] bytes) {
        if (null == bytes) {
            return null;
        }
        return Unpooled.wrappedBuffer((byte[])bytes);
    }

    @Override
    public SchemaInfo getSchemaInfo() {
        return SCHEMA_INFO;
    }
}

