/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.client.impl.schema;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import org.apache.pulsar.client.api.SchemaSerializationException;
import org.apache.pulsar.common.schema.SchemaInfo;
import org.apache.pulsar.common.schema.SchemaType;
import org.apache.pulsar.shade.org.apache.avro.Schema;
import org.apache.pulsar.shade.org.apache.avro.io.BinaryEncoder;
import org.apache.pulsar.shade.org.apache.avro.io.DecoderFactory;
import org.apache.pulsar.shade.org.apache.avro.io.EncoderFactory;
import org.apache.pulsar.shade.org.apache.avro.reflect.ReflectData;
import org.apache.pulsar.shade.org.apache.avro.reflect.ReflectDatumReader;
import org.apache.pulsar.shade.org.apache.avro.reflect.ReflectDatumWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AvroSchema<T>
implements org.apache.pulsar.client.api.Schema<T> {
    private static final Logger log = LoggerFactory.getLogger(AvroSchema.class);
    private SchemaInfo schemaInfo;
    private Schema schema;
    private ReflectDatumWriter<T> datumWriter;
    private ReflectDatumReader<T> reader;
    private BinaryEncoder encoder;
    private ByteArrayOutputStream byteArrayOutputStream;

    private AvroSchema(Schema schema, Map<String, String> properties) {
        this.schema = schema;
        this.schemaInfo = new SchemaInfo();
        this.schemaInfo.setName("");
        this.schemaInfo.setProperties(properties);
        this.schemaInfo.setType(SchemaType.AVRO);
        this.schemaInfo.setSchema(this.schema.toString().getBytes());
        this.byteArrayOutputStream = new ByteArrayOutputStream();
        this.encoder = EncoderFactory.get().binaryEncoder(this.byteArrayOutputStream, this.encoder);
        this.datumWriter = new ReflectDatumWriter(this.schema);
        this.reader = new ReflectDatumReader(this.schema);
    }

    @Override
    public synchronized byte[] encode(T message) {
        try {
            this.datumWriter.write(message, this.encoder);
            this.encoder.flush();
            byte[] byArray = this.byteArrayOutputStream.toByteArray();
            return byArray;
        }
        catch (Exception e) {
            throw new SchemaSerializationException(e);
        }
        finally {
            this.byteArrayOutputStream.reset();
        }
    }

    @Override
    public T decode(byte[] bytes) {
        try {
            return this.reader.read(null, DecoderFactory.get().binaryDecoder(bytes, null));
        }
        catch (IOException e) {
            throw new SchemaSerializationException(e);
        }
    }

    @Override
    public SchemaInfo getSchemaInfo() {
        return this.schemaInfo;
    }

    private static <T> Schema createAvroSchema(Class<T> pojo) {
        return ReflectData.AllowNull.get().getSchema(pojo);
    }

    public static <T> AvroSchema<T> of(Class<T> pojo) {
        return new AvroSchema<T>(AvroSchema.createAvroSchema(pojo), Collections.emptyMap());
    }

    public static <T> AvroSchema<T> of(Class<T> pojo, Map<String, String> properties) {
        return new AvroSchema<T>(AvroSchema.createAvroSchema(pojo), properties);
    }
}

