/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.client.impl.schema;

import com.google.common.base.Preconditions;
import org.apache.pulsar.client.api.Schema;
import org.apache.pulsar.client.api.schema.GenericRecord;
import org.apache.pulsar.common.schema.SchemaInfo;

public class AutoConsumeSchema
implements Schema<GenericRecord> {
    private Schema<GenericRecord> schema;

    public void setSchema(Schema<GenericRecord> schema) {
        this.schema = schema;
    }

    private void ensureSchemaInitialized() {
        Preconditions.checkState((null != this.schema ? 1 : 0) != 0, (Object)"Schema is not initialized before used");
    }

    @Override
    public void validate(byte[] message) {
        this.ensureSchemaInitialized();
        this.schema.validate(message);
    }

    @Override
    public byte[] encode(GenericRecord message) {
        this.ensureSchemaInitialized();
        return this.schema.encode(message);
    }

    @Override
    public GenericRecord decode(byte[] bytes) {
        this.ensureSchemaInitialized();
        return this.schema.decode(bytes);
    }

    @Override
    public SchemaInfo getSchemaInfo() {
        this.ensureSchemaInitialized();
        return this.schema.getSchemaInfo();
    }
}

