/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.client.api;

import com.google.protobuf.GeneratedMessageV3;
import org.apache.pulsar.client.api.schema.GenericRecord;
import org.apache.pulsar.client.impl.schema.AutoConsumeSchema;
import org.apache.pulsar.client.impl.schema.AutoProduceBytesSchema;
import org.apache.pulsar.client.impl.schema.AvroSchema;
import org.apache.pulsar.client.impl.schema.ByteSchema;
import org.apache.pulsar.client.impl.schema.BytesSchema;
import org.apache.pulsar.client.impl.schema.DoubleSchema;
import org.apache.pulsar.client.impl.schema.FloatSchema;
import org.apache.pulsar.client.impl.schema.IntSchema;
import org.apache.pulsar.client.impl.schema.JSONSchema;
import org.apache.pulsar.client.impl.schema.LongSchema;
import org.apache.pulsar.client.impl.schema.ProtobufSchema;
import org.apache.pulsar.client.impl.schema.ShortSchema;
import org.apache.pulsar.client.impl.schema.StringSchema;
import org.apache.pulsar.client.impl.schema.generic.GenericSchema;
import org.apache.pulsar.common.schema.SchemaInfo;

public interface Schema<T> {
    public static final Schema<byte[]> BYTES = new BytesSchema();
    public static final Schema<String> STRING = new StringSchema();

    default public void validate(byte[] message) {
        this.decode(message);
    }

    public byte[] encode(T var1);

    public T decode(byte[] var1);

    public SchemaInfo getSchemaInfo();

    public static <T extends GeneratedMessageV3> Schema<T> PROTOBUF(Class<T> clazz) {
        return ProtobufSchema.of(clazz);
    }

    public static <T> Schema<T> AVRO(Class<T> clazz) {
        return AvroSchema.of(clazz);
    }

    public static <T> Schema<T> JSON(Class<T> clazz) {
        return JSONSchema.of(clazz);
    }

    @Deprecated
    public static Schema<GenericRecord> AUTO() {
        return Schema.AUTO_CONSUME();
    }

    public static Schema<GenericRecord> AUTO_CONSUME() {
        return new AutoConsumeSchema();
    }

    public static Schema<byte[]> AUTO_PRODUCE_BYTES() {
        return new AutoProduceBytesSchema();
    }

    public static Schema<?> getSchema(SchemaInfo schemaInfo) {
        switch (schemaInfo.getType()) {
            case INT8: {
                return ByteSchema.of();
            }
            case INT16: {
                return ShortSchema.of();
            }
            case INT32: {
                return IntSchema.of();
            }
            case INT64: {
                return LongSchema.of();
            }
            case STRING: {
                return StringSchema.utf8();
            }
            case FLOAT: {
                return FloatSchema.of();
            }
            case DOUBLE: {
                return DoubleSchema.of();
            }
            case BYTES: {
                return BytesSchema.of();
            }
            case JSON: 
            case AVRO: {
                return GenericSchema.of(schemaInfo);
            }
        }
        throw new IllegalArgumentException("Retrieve schema instance from schema info for type '" + schemaInfo.getType() + "' is not supported yet");
    }
}

