/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.shade.org.apache.commons.compress.compressors.xz;

import java.io.IOException;
import java.io.OutputStream;
import org.apache.pulsar.shade.org.apache.commons.compress.compressors.CompressorOutputStream;
import org.apache.pulsar.shade.org.tukaani.xz.LZMA2Options;
import org.apache.pulsar.shade.org.tukaani.xz.XZOutputStream;

public class XZCompressorOutputStream
extends CompressorOutputStream {
    private final XZOutputStream out;

    public XZCompressorOutputStream(OutputStream outputStream) throws IOException {
        this.out = new XZOutputStream(outputStream, new LZMA2Options());
    }

    public XZCompressorOutputStream(OutputStream outputStream, int preset) throws IOException {
        this.out = new XZOutputStream(outputStream, new LZMA2Options(preset));
    }

    @Override
    public void write(int b) throws IOException {
        this.out.write(b);
    }

    @Override
    public void write(byte[] buf, int off, int len) throws IOException {
        this.out.write(buf, off, len);
    }

    @Override
    public void flush() throws IOException {
        this.out.flush();
    }

    public void finish() throws IOException {
        this.out.finish();
    }

    @Override
    public void close() throws IOException {
        this.out.close();
    }
}

