/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.client.impl.schema;

import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import org.apache.pulsar.client.api.SchemaSerializationException;
import org.apache.pulsar.common.schema.SchemaInfo;
import org.apache.pulsar.common.schema.SchemaType;
import org.apache.pulsar.shade.com.fasterxml.jackson.core.JsonProcessingException;
import org.apache.pulsar.shade.com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.pulsar.shade.com.fasterxml.jackson.module.jsonSchema.JsonSchema;
import org.apache.pulsar.shade.com.fasterxml.jackson.module.jsonSchema.JsonSchemaGenerator;
import org.apache.pulsar.shade.org.apache.avro.Schema;
import org.apache.pulsar.shade.org.apache.avro.reflect.ReflectData;

public class JSONSchema<T>
implements org.apache.pulsar.client.api.Schema<T> {
    private final Schema schema;
    private final SchemaInfo schemaInfo;
    private final ObjectMapper objectMapper;
    private final Class<T> pojo;
    private Map<String, String> properties;

    private JSONSchema(Class<T> pojo, Map<String, String> properties) {
        this.pojo = pojo;
        this.properties = properties;
        this.objectMapper = new ObjectMapper();
        this.schema = ReflectData.AllowNull.get().getSchema(pojo);
        this.schemaInfo = new SchemaInfo();
        this.schemaInfo.setName("");
        this.schemaInfo.setProperties(properties);
        this.schemaInfo.setType(SchemaType.JSON);
        this.schemaInfo.setSchema(this.schema.toString().getBytes());
    }

    @Override
    public byte[] encode(T message) throws SchemaSerializationException {
        try {
            return this.objectMapper.writeValueAsBytes(message);
        }
        catch (JsonProcessingException e) {
            throw new SchemaSerializationException(e);
        }
    }

    @Override
    public T decode(byte[] bytes) {
        try {
            return this.objectMapper.readValue(new String(bytes), this.pojo);
        }
        catch (IOException e) {
            throw new RuntimeException(new SchemaSerializationException(e));
        }
    }

    @Override
    public SchemaInfo getSchemaInfo() {
        return this.schemaInfo;
    }

    public SchemaInfo getBackwardsCompatibleJsonSchemaInfo() {
        SchemaInfo backwardsCompatibleSchemaInfo;
        try {
            JsonSchemaGenerator schemaGen = new JsonSchemaGenerator(this.objectMapper);
            JsonSchema jsonBackwardsCompatibileSchema = schemaGen.generateSchema(this.pojo);
            backwardsCompatibleSchemaInfo = new SchemaInfo();
            backwardsCompatibleSchemaInfo.setName("");
            backwardsCompatibleSchemaInfo.setProperties(this.properties);
            backwardsCompatibleSchemaInfo.setType(SchemaType.JSON);
            backwardsCompatibleSchemaInfo.setSchema(this.objectMapper.writeValueAsBytes(jsonBackwardsCompatibileSchema));
        }
        catch (JsonProcessingException ex) {
            throw new RuntimeException(ex);
        }
        return backwardsCompatibleSchemaInfo;
    }

    public static <T> JSONSchema<T> of(Class<T> pojo) {
        return new JSONSchema<T>(pojo, Collections.emptyMap());
    }

    public static <T> JSONSchema<T> of(Class<T> pojo, Map<String, String> properties) {
        return new JSONSchema<T>(pojo, properties);
    }
}

