/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.client.api;

import com.google.protobuf.GeneratedMessageV3;
import org.apache.pulsar.client.impl.schema.AvroSchema;
import org.apache.pulsar.client.impl.schema.BytesSchema;
import org.apache.pulsar.client.impl.schema.JSONSchema;
import org.apache.pulsar.client.impl.schema.ProtobufSchema;
import org.apache.pulsar.client.impl.schema.StringSchema;
import org.apache.pulsar.common.schema.SchemaInfo;

public interface Schema<T> {
    public static final Schema<byte[]> BYTES = new BytesSchema();
    public static final Schema<String> STRING = new StringSchema();

    public byte[] encode(T var1);

    public T decode(byte[] var1);

    public SchemaInfo getSchemaInfo();

    public static <T extends GeneratedMessageV3> Schema<T> PROTOBUF(Class<T> clazz) {
        return ProtobufSchema.of(clazz);
    }

    public static <T> Schema<T> AVRO(Class<T> clazz) {
        return AvroSchema.of(clazz);
    }

    public static <T> Schema<T> JSON(Class<T> clazz) {
        return JSONSchema.of(clazz);
    }
}

