/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.reactive.client.internal.adapter;

import org.apache.pulsar.client.api.Schema;
import org.apache.pulsar.reactive.client.api.EndOfStreamAction;
import org.apache.pulsar.reactive.client.api.MutableReactiveMessageReaderSpec;
import org.apache.pulsar.reactive.client.api.ReactiveMessageReader;
import org.apache.pulsar.reactive.client.api.ReactiveMessageReaderBuilder;
import org.apache.pulsar.reactive.client.api.ReactiveMessageReaderSpec;
import org.apache.pulsar.reactive.client.api.StartAtSpec;
import org.apache.pulsar.reactive.client.internal.adapter.AdaptedReactiveMessageReader;
import org.apache.pulsar.reactive.client.internal.adapter.ReactiveReaderAdapterFactory;

class AdaptedReactiveMessageReaderBuilder<T>
implements ReactiveMessageReaderBuilder<T> {
    private final ReactiveReaderAdapterFactory reactiveReaderAdapterFactory;
    private final Schema<T> schema;
    private final MutableReactiveMessageReaderSpec readerSpec;
    private StartAtSpec startAtSpec = StartAtSpec.ofEarliest();
    private EndOfStreamAction endOfStreamAction = EndOfStreamAction.COMPLETE;

    AdaptedReactiveMessageReaderBuilder(Schema<T> schema, ReactiveReaderAdapterFactory reactiveReaderAdapterFactory) {
        this(schema, reactiveReaderAdapterFactory, new MutableReactiveMessageReaderSpec());
    }

    private AdaptedReactiveMessageReaderBuilder(Schema<T> schema, ReactiveReaderAdapterFactory reactiveReaderAdapterFactory, MutableReactiveMessageReaderSpec readerSpec) {
        this.reactiveReaderAdapterFactory = reactiveReaderAdapterFactory;
        this.schema = schema;
        this.readerSpec = readerSpec;
    }

    public ReactiveMessageReaderBuilder<T> startAtSpec(StartAtSpec startAtSpec) {
        this.startAtSpec = startAtSpec;
        return this;
    }

    public ReactiveMessageReaderBuilder<T> endOfStreamAction(EndOfStreamAction endOfStreamAction) {
        this.endOfStreamAction = endOfStreamAction;
        return this;
    }

    public MutableReactiveMessageReaderSpec getMutableSpec() {
        return this.readerSpec;
    }

    public ReactiveMessageReaderBuilder<T> clone() {
        AdaptedReactiveMessageReaderBuilder<T> cloned = new AdaptedReactiveMessageReaderBuilder<T>(this.schema, this.reactiveReaderAdapterFactory, new MutableReactiveMessageReaderSpec((ReactiveMessageReaderSpec)this.readerSpec));
        cloned.startAtSpec = this.startAtSpec;
        cloned.endOfStreamAction = this.endOfStreamAction;
        return this;
    }

    public ReactiveMessageReader<T> build() {
        return new AdaptedReactiveMessageReader<T>(this.reactiveReaderAdapterFactory, this.schema, (ReactiveMessageReaderSpec)this.readerSpec, this.startAtSpec, this.endOfStreamAction);
    }
}

