/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.client.impl;

import java.net.InetSocketAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.pulsar.client.api.PulsarClientException;
import org.apache.pulsar.client.impl.EndpointStatus;
import org.apache.pulsar.client.impl.ServiceNameResolver;
import org.apache.pulsar.common.net.ServiceURI;
import org.apache.pulsar.common.util.Backoff;
import org.apache.pulsar.common.util.BackoffBuilder;
import org.apache.pulsar.shade.com.google.common.annotations.VisibleForTesting;
import org.apache.pulsar.shade.com.google.common.base.Preconditions;
import org.apache.pulsar.shade.io.netty.util.internal.PlatformDependent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PulsarServiceNameResolver
implements ServiceNameResolver {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(PulsarServiceNameResolver.class);
    private volatile ServiceURI serviceUri;
    private volatile String serviceUrl;
    private static final AtomicIntegerFieldUpdater<PulsarServiceNameResolver> CURRENT_INDEX_UPDATER = AtomicIntegerFieldUpdater.newUpdater(PulsarServiceNameResolver.class, "currentIndex");
    private volatile int currentIndex;
    private volatile List<InetSocketAddress> allAddressList;
    private volatile Set<InetSocketAddress> allAddressSet;
    private volatile List<InetSocketAddress> availableAddressList;
    private final Map<InetSocketAddress, EndpointStatus> hostAvailabilityMap = new ConcurrentHashMap<InetSocketAddress, EndpointStatus>();
    private final long serviceUrlQuarantineInitDurationMs;
    private final long serviceUrlQuarantineMaxDurationMs;
    private final boolean enableServiceUrlQuarantine;

    public PulsarServiceNameResolver() {
        this(0L, 0L);
    }

    public PulsarServiceNameResolver(long serviceUrlQuarantineInitDurationMs, long serviceUrlQuarantineMaxDurationMs) {
        this.serviceUrlQuarantineInitDurationMs = serviceUrlQuarantineInitDurationMs;
        this.serviceUrlQuarantineMaxDurationMs = serviceUrlQuarantineMaxDurationMs;
        this.enableServiceUrlQuarantine = serviceUrlQuarantineInitDurationMs > 0L && serviceUrlQuarantineMaxDurationMs > 0L;
    }

    @Override
    public InetSocketAddress resolveHost() {
        List<InetSocketAddress> list;
        List<InetSocketAddress> availableAddresses = this.availableAddressList;
        if (availableAddresses != null && !availableAddresses.isEmpty()) {
            list = availableAddresses;
        } else {
            list = this.allAddressList;
            if (this.availableAddressList != null) {
                log.warn("No available hosts found for service url: {}", (Object)this.serviceUrl);
            }
        }
        Preconditions.checkState(list != null, "No service url is provided yet");
        Preconditions.checkState(!list.isEmpty(), "No hosts found for service url : " + this.serviceUrl);
        if (list.size() == 1) {
            return list.get(0);
        }
        int originalIndex = CURRENT_INDEX_UPDATER.getAndUpdate(this, last -> (last + 1) % list.size());
        return list.get((originalIndex + 1) % list.size());
    }

    @Override
    public URI resolveHostUri() {
        InetSocketAddress host = this.resolveHost();
        String hostUrl = this.serviceUri.getServiceScheme() + "://" + host.getHostString() + ":" + host.getPort();
        return URI.create(hostUrl);
    }

    @Override
    public String getServiceUrl() {
        return this.serviceUrl;
    }

    @Override
    public ServiceURI getServiceUri() {
        return this.serviceUri;
    }

    @Override
    public synchronized void updateServiceUrl(String serviceUrl) throws PulsarClientException.InvalidServiceURL {
        ServiceURI uri;
        try {
            uri = ServiceURI.create(serviceUrl);
        }
        catch (IllegalArgumentException iae) {
            log.error("Invalid service-url {} provided {}", new Object[]{serviceUrl, iae.getMessage(), iae});
            throw new PulsarClientException.InvalidServiceURL((Throwable)iae);
        }
        String[] hosts = uri.getServiceHosts();
        ArrayList<InetSocketAddress> addresses = new ArrayList<InetSocketAddress>(hosts.length);
        for (String host : hosts) {
            String hostUrl = uri.getServiceScheme() + "://" + host;
            try {
                URI hostUri = new URI(hostUrl);
                addresses.add(InetSocketAddress.createUnresolved(hostUri.getHost(), hostUri.getPort()));
            }
            catch (URISyntaxException e) {
                log.error("Invalid host provided {}", (Object)hostUrl, (Object)e);
                throw new PulsarClientException.InvalidServiceURL((Throwable)e);
            }
        }
        this.allAddressList = addresses;
        this.allAddressSet = Set.copyOf(addresses);
        this.serviceUrl = serviceUrl;
        this.serviceUri = uri;
        this.currentIndex = PulsarServiceNameResolver.randomIndex(addresses.size());
        if (this.enableServiceUrlQuarantine) {
            this.hostAvailabilityMap.keySet().retainAll(this.allAddressSet);
            this.allAddressSet.forEach(address -> this.hostAvailabilityMap.putIfAbsent((InetSocketAddress)address, this.createEndpointStatus(true, (InetSocketAddress)address)));
            this.availableAddressList = this.hostAvailabilityMap.entrySet().stream().filter(entry -> ((EndpointStatus)entry.getValue()).isAvailable() && this.allAddressSet.contains(entry.getKey())).map(Map.Entry::getKey).collect(Collectors.toList());
        }
    }

    private static int randomIndex(int numAddresses) {
        return numAddresses == 1 ? 0 : PlatformDependent.threadLocalRandom().nextInt(numAddresses);
    }

    @Override
    public synchronized void markHostAvailability(InetSocketAddress address, boolean isAvailable) {
        if (!this.enableServiceUrlQuarantine) {
            return;
        }
        if (!this.allAddressSet.contains(address)) {
            log.debug("Address {} is not part of the original service URL, ignoring availability update", (Object)address);
            return;
        }
        AtomicBoolean availableHostsChanged = new AtomicBoolean(false);
        this.hostAvailabilityMap.compute(address, (key, oldStatus) -> {
            if (oldStatus == null) {
                EndpointStatus endpointStatus = this.createEndpointStatus(isAvailable, (InetSocketAddress)key);
                availableHostsChanged.set(true);
                return endpointStatus;
            }
            if (oldStatus.isAvailable() != isAvailable) {
                availableHostsChanged.set(true);
            }
            this.computeEndpointStatus(isAvailable, (EndpointStatus)oldStatus);
            return oldStatus;
        });
        this.hostAvailabilityMap.forEach((__, endpointStatus) -> {
            if (!endpointStatus.isAvailable()) {
                this.computeEndpointStatus(false, (EndpointStatus)endpointStatus);
                if (!availableHostsChanged.get() && endpointStatus.isAvailable()) {
                    availableHostsChanged.set(true);
                }
            }
        });
        if (availableHostsChanged.get()) {
            this.availableAddressList = this.hostAvailabilityMap.entrySet().stream().filter(entry -> ((EndpointStatus)entry.getValue()).isAvailable() && this.allAddressSet.contains(entry.getKey())).map(Map.Entry::getKey).collect(Collectors.toList());
            log.info("service name resolver available hosts changed, current available hosts: {}", this.availableAddressList);
        }
    }

    @VisibleForTesting
    List<InetSocketAddress> getAvailableAddressList() {
        return this.availableAddressList;
    }

    private EndpointStatus createEndpointStatus(boolean isAvailable, InetSocketAddress inetSocketAddress) {
        Backoff backoff = new BackoffBuilder().setInitialTime(this.serviceUrlQuarantineInitDurationMs, TimeUnit.MILLISECONDS).setMax(this.serviceUrlQuarantineMaxDurationMs, TimeUnit.MILLISECONDS).create();
        EndpointStatus endpointStatus = new EndpointStatus(inetSocketAddress, backoff, System.currentTimeMillis(), 0L, isAvailable);
        if (!isAvailable) {
            this.computeEndpointStatus(false, endpointStatus);
        }
        return endpointStatus;
    }

    private void computeEndpointStatus(boolean newIsAvailable, EndpointStatus status) {
        if (!newIsAvailable) {
            if (!status.isAvailable()) {
                boolean needTryRecover;
                long elapsedTimeMsSinceLast = System.currentTimeMillis() - status.getLastUpdateTimeStampMs();
                boolean bl = needTryRecover = elapsedTimeMsSinceLast >= status.getNextDelayMsToRecover();
                if (needTryRecover) {
                    log.info("service name resolver try to recover host {} after {}", (Object)status.getSocketAddress(), (Object)Duration.ofMillis(elapsedTimeMsSinceLast));
                    status.setAvailable(true);
                    status.setLastUpdateTimeStampMs(System.currentTimeMillis());
                    status.setNextDelayMsToRecover(status.getQuarantineBackoff().next());
                }
            } else {
                status.setAvailable(false);
                status.setLastUpdateTimeStampMs(System.currentTimeMillis());
                status.setNextDelayMsToRecover(status.getQuarantineBackoff().next());
            }
        } else if (!status.isAvailable()) {
            status.setAvailable(true);
            status.setLastUpdateTimeStampMs(System.currentTimeMillis());
            status.setNextDelayMsToRecover(0L);
            status.getQuarantineBackoff().reset();
        }
    }
}

