/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.shade.org.glassfish.jersey.jackson.internal;

import java.lang.annotation.Annotation;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Logger;
import org.apache.pulsar.shade.com.fasterxml.jackson.core.JsonFactory;
import org.apache.pulsar.shade.com.fasterxml.jackson.core.StreamReadConstraints;
import org.apache.pulsar.shade.com.fasterxml.jackson.databind.Module;
import org.apache.pulsar.shade.com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.pulsar.shade.com.fasterxml.jackson.databind.ObjectReader;
import org.apache.pulsar.shade.javax.annotation.PostConstruct;
import org.apache.pulsar.shade.javax.inject.Inject;
import org.apache.pulsar.shade.javax.inject.Singleton;
import org.apache.pulsar.shade.javax.ws.rs.core.Configuration;
import org.apache.pulsar.shade.javax.ws.rs.core.Context;
import org.apache.pulsar.shade.javax.ws.rs.ext.Providers;
import org.apache.pulsar.shade.org.glassfish.jersey.CommonProperties;
import org.apache.pulsar.shade.org.glassfish.jersey.internal.util.PropertiesHelper;
import org.apache.pulsar.shade.org.glassfish.jersey.jackson.LocalizationMessages;
import org.apache.pulsar.shade.org.glassfish.jersey.jackson.internal.jackson.jaxrs.cfg.Annotations;
import org.apache.pulsar.shade.org.glassfish.jersey.jackson.internal.jackson.jaxrs.json.JacksonJaxbJsonProvider;
import org.apache.pulsar.shade.org.glassfish.jersey.jackson.internal.jackson.jaxrs.json.JsonEndpointConfig;
import org.apache.pulsar.shade.org.glassfish.jersey.jackson.internal.jackson.jaxrs.json.JsonMapperConfigurator;
import org.apache.pulsar.shade.org.glassfish.jersey.message.MessageProperties;

@Singleton
public class DefaultJacksonJaxbJsonProvider
extends JacksonJaxbJsonProvider {
    private Configuration commonConfig;
    private static final Logger LOGGER = Logger.getLogger(DefaultJacksonJaxbJsonProvider.class.getName());
    private static final String EXCLUDE_MODULE_NAME = "JaxbAnnotationModule";

    @Inject
    public DefaultJacksonJaxbJsonProvider(@Context Providers providers, @Context Configuration config) {
        this.commonConfig = config;
        this._providers = providers;
    }

    public DefaultJacksonJaxbJsonProvider(Providers providers, Configuration config, Annotations ... annotationsToUse) {
        super(annotationsToUse);
        this.commonConfig = config;
        this._providers = providers;
    }

    @Override
    protected JsonEndpointConfig _configForReading(ObjectReader reader, Annotation[] annotations) {
        try {
            this.updateFactoryConstraints(reader.getFactory());
        }
        catch (Throwable t2) {
            LOGGER.warning(LocalizationMessages.ERROR_JACKSON_STREAMREADCONSTRAINTS(t2.getMessage()));
        }
        return super._configForReading(reader, annotations);
    }

    @PostConstruct
    private void findAndRegisterModules() {
        ObjectMapper defaultMapper = ((JsonMapperConfigurator)this._mapperConfig).getDefaultMapper();
        ObjectMapper mapper = ((JsonMapperConfigurator)this._mapperConfig).getConfiguredMapper();
        List<Module> modules = this.filterModules();
        defaultMapper.registerModules(modules);
        if (mapper != null) {
            mapper.registerModules(modules);
        }
    }

    private List<Module> filterModules() {
        String disabledModules = CommonProperties.getValue(this.commonConfig.getProperties(), this.commonConfig.getRuntimeType(), "org.apache.pulsar.shade.jersey.config.json.jackson.disabled.modules", String.class);
        String enabledModules = CommonProperties.getValue(this.commonConfig.getProperties(), this.commonConfig.getRuntimeType(), "org.apache.pulsar.shade.jersey.config.json.jackson.enabled.modules", String.class);
        List<Module> modules = ObjectMapper.findModules();
        modules.removeIf(mod -> mod.getModuleName().contains(EXCLUDE_MODULE_NAME));
        if (enabledModules != null && !enabledModules.isEmpty()) {
            List<String> enabledModulesList = Arrays.asList(enabledModules.split(","));
            modules.removeIf(mod -> !enabledModulesList.contains(mod.getModuleName()));
        } else if (disabledModules != null && !disabledModules.isEmpty()) {
            List<String> disabledModulesList = Arrays.asList(disabledModules.split(","));
            modules.removeIf(mod -> disabledModulesList.contains(mod.getModuleName()));
        }
        return modules;
    }

    private void updateFactoryConstraints(JsonFactory jsonFactory) {
        Object maxStringLengthObject = this.commonConfig.getProperty(MessageProperties.JSON_MAX_STRING_LENGTH);
        Integer maxStringLength = PropertiesHelper.convertValue(maxStringLengthObject, Integer.class);
        if (maxStringLength != 20000000) {
            StreamReadConstraints constraints = jsonFactory.streamReadConstraints();
            jsonFactory.setStreamReadConstraints(StreamReadConstraints.builder().maxStringLength(maxStringLength.intValue()).maxDocumentLength(constraints.getMaxDocumentLength()).maxNameLength(constraints.getMaxNameLength()).maxNestingDepth(constraints.getMaxNestingDepth()).maxNumberLength(constraints.getMaxNumberLength()).build());
        }
    }
}

