/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.common.policies.data;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.pulsar.common.api.proto.CommandSubscribe;
import org.apache.pulsar.common.policies.data.InactiveTopicPolicies;
import org.apache.pulsar.common.policies.data.OffloadPoliciesImpl;
import org.apache.pulsar.common.policies.data.PersistencePolicies;
import org.apache.pulsar.common.policies.data.PublishRate;
import org.apache.pulsar.common.policies.data.RetentionPolicies;
import org.apache.pulsar.common.policies.data.SubscribeRate;
import org.apache.pulsar.common.policies.data.impl.BacklogQuotaImpl;
import org.apache.pulsar.common.policies.data.impl.DispatchRateImpl;
import org.apache.pulsar.shade.com.google.common.collect.Maps;

public class TopicPolicies {
    private Map<String, BacklogQuotaImpl> backLogQuotaMap = Maps.newHashMap();
    private PersistencePolicies persistence = null;
    private RetentionPolicies retentionPolicies = null;
    private Boolean deduplicationEnabled = null;
    private Integer messageTTLInSeconds = null;
    private Integer maxProducerPerTopic = null;
    private Integer maxConsumerPerTopic = null;
    private Integer maxConsumersPerSubscription = null;
    private Integer maxUnackedMessagesOnConsumer = null;
    private Integer maxUnackedMessagesOnSubscription = null;
    private Long delayedDeliveryTickTimeMillis = null;
    private Boolean delayedDeliveryEnabled = null;
    private OffloadPoliciesImpl offloadPolicies;
    private InactiveTopicPolicies inactiveTopicPolicies = null;
    private DispatchRateImpl dispatchRate = null;
    private DispatchRateImpl subscriptionDispatchRate = null;
    private Long compactionThreshold = null;
    private PublishRate publishRate = null;
    private SubscribeRate subscribeRate = null;
    private Integer deduplicationSnapshotIntervalSeconds = null;
    private Integer maxMessageSize = null;
    private Integer maxSubscriptionsPerTopic = null;
    private DispatchRateImpl replicatorDispatchRate = null;
    private List<CommandSubscribe.SubType> subscriptionTypesEnabled = new ArrayList<CommandSubscribe.SubType>();

    public boolean isReplicatorDispatchRateSet() {
        return this.replicatorDispatchRate != null;
    }

    public boolean isMaxSubscriptionsPerTopicSet() {
        return this.maxSubscriptionsPerTopic != null;
    }

    public boolean isMaxMessageSizeSet() {
        return this.maxMessageSize != null;
    }

    public boolean isDeduplicationSnapshotIntervalSecondsSet() {
        return this.deduplicationSnapshotIntervalSeconds != null;
    }

    public boolean isInactiveTopicPoliciesSet() {
        return this.inactiveTopicPolicies != null;
    }

    public boolean isOffloadPoliciesSet() {
        return this.offloadPolicies != null;
    }

    public boolean isMaxUnackedMessagesOnConsumerSet() {
        return this.maxUnackedMessagesOnConsumer != null;
    }

    public boolean isDelayedDeliveryTickTimeMillisSet() {
        return this.delayedDeliveryTickTimeMillis != null;
    }

    public boolean isDelayedDeliveryEnabledSet() {
        return this.delayedDeliveryEnabled != null;
    }

    public boolean isMaxUnackedMessagesOnSubscriptionSet() {
        return this.maxUnackedMessagesOnSubscription != null;
    }

    public boolean isBacklogQuotaSet() {
        return !this.backLogQuotaMap.isEmpty();
    }

    public boolean isPersistentPolicySet() {
        return this.persistence != null;
    }

    public boolean isRetentionSet() {
        return this.retentionPolicies != null;
    }

    public boolean isDeduplicationSet() {
        return this.deduplicationEnabled != null;
    }

    public boolean isMessageTTLSet() {
        return this.messageTTLInSeconds != null;
    }

    public boolean isMaxProducerPerTopicSet() {
        return this.maxProducerPerTopic != null;
    }

    public boolean isMaxConsumerPerTopicSet() {
        return this.maxConsumerPerTopic != null;
    }

    public boolean isMaxConsumersPerSubscriptionSet() {
        return this.maxConsumersPerSubscription != null;
    }

    public boolean isDispatchRateSet() {
        return this.dispatchRate != null;
    }

    public boolean isSubscriptionDispatchRateSet() {
        return this.subscriptionDispatchRate != null;
    }

    public boolean isCompactionThresholdSet() {
        return this.compactionThreshold != null;
    }

    public boolean isPublishRateSet() {
        return this.publishRate != null;
    }

    public boolean isSubscribeRateSet() {
        return this.subscribeRate != null;
    }

    public static TopicPoliciesBuilder builder() {
        return new TopicPoliciesBuilder();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TopicPolicies)) {
            return false;
        }
        TopicPolicies other = (TopicPolicies)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Boolean this$deduplicationEnabled = this.getDeduplicationEnabled();
        Boolean other$deduplicationEnabled = other.getDeduplicationEnabled();
        if (this$deduplicationEnabled == null ? other$deduplicationEnabled != null : !((Object)this$deduplicationEnabled).equals(other$deduplicationEnabled)) {
            return false;
        }
        Integer this$messageTTLInSeconds = this.getMessageTTLInSeconds();
        Integer other$messageTTLInSeconds = other.getMessageTTLInSeconds();
        if (this$messageTTLInSeconds == null ? other$messageTTLInSeconds != null : !((Object)this$messageTTLInSeconds).equals(other$messageTTLInSeconds)) {
            return false;
        }
        Integer this$maxProducerPerTopic = this.getMaxProducerPerTopic();
        Integer other$maxProducerPerTopic = other.getMaxProducerPerTopic();
        if (this$maxProducerPerTopic == null ? other$maxProducerPerTopic != null : !((Object)this$maxProducerPerTopic).equals(other$maxProducerPerTopic)) {
            return false;
        }
        Integer this$maxConsumerPerTopic = this.getMaxConsumerPerTopic();
        Integer other$maxConsumerPerTopic = other.getMaxConsumerPerTopic();
        if (this$maxConsumerPerTopic == null ? other$maxConsumerPerTopic != null : !((Object)this$maxConsumerPerTopic).equals(other$maxConsumerPerTopic)) {
            return false;
        }
        Integer this$maxConsumersPerSubscription = this.getMaxConsumersPerSubscription();
        Integer other$maxConsumersPerSubscription = other.getMaxConsumersPerSubscription();
        if (this$maxConsumersPerSubscription == null ? other$maxConsumersPerSubscription != null : !((Object)this$maxConsumersPerSubscription).equals(other$maxConsumersPerSubscription)) {
            return false;
        }
        Integer this$maxUnackedMessagesOnConsumer = this.getMaxUnackedMessagesOnConsumer();
        Integer other$maxUnackedMessagesOnConsumer = other.getMaxUnackedMessagesOnConsumer();
        if (this$maxUnackedMessagesOnConsumer == null ? other$maxUnackedMessagesOnConsumer != null : !((Object)this$maxUnackedMessagesOnConsumer).equals(other$maxUnackedMessagesOnConsumer)) {
            return false;
        }
        Integer this$maxUnackedMessagesOnSubscription = this.getMaxUnackedMessagesOnSubscription();
        Integer other$maxUnackedMessagesOnSubscription = other.getMaxUnackedMessagesOnSubscription();
        if (this$maxUnackedMessagesOnSubscription == null ? other$maxUnackedMessagesOnSubscription != null : !((Object)this$maxUnackedMessagesOnSubscription).equals(other$maxUnackedMessagesOnSubscription)) {
            return false;
        }
        Long this$delayedDeliveryTickTimeMillis = this.getDelayedDeliveryTickTimeMillis();
        Long other$delayedDeliveryTickTimeMillis = other.getDelayedDeliveryTickTimeMillis();
        if (this$delayedDeliveryTickTimeMillis == null ? other$delayedDeliveryTickTimeMillis != null : !((Object)this$delayedDeliveryTickTimeMillis).equals(other$delayedDeliveryTickTimeMillis)) {
            return false;
        }
        Boolean this$delayedDeliveryEnabled = this.getDelayedDeliveryEnabled();
        Boolean other$delayedDeliveryEnabled = other.getDelayedDeliveryEnabled();
        if (this$delayedDeliveryEnabled == null ? other$delayedDeliveryEnabled != null : !((Object)this$delayedDeliveryEnabled).equals(other$delayedDeliveryEnabled)) {
            return false;
        }
        Long this$compactionThreshold = this.getCompactionThreshold();
        Long other$compactionThreshold = other.getCompactionThreshold();
        if (this$compactionThreshold == null ? other$compactionThreshold != null : !((Object)this$compactionThreshold).equals(other$compactionThreshold)) {
            return false;
        }
        Integer this$deduplicationSnapshotIntervalSeconds = this.getDeduplicationSnapshotIntervalSeconds();
        Integer other$deduplicationSnapshotIntervalSeconds = other.getDeduplicationSnapshotIntervalSeconds();
        if (this$deduplicationSnapshotIntervalSeconds == null ? other$deduplicationSnapshotIntervalSeconds != null : !((Object)this$deduplicationSnapshotIntervalSeconds).equals(other$deduplicationSnapshotIntervalSeconds)) {
            return false;
        }
        Integer this$maxMessageSize = this.getMaxMessageSize();
        Integer other$maxMessageSize = other.getMaxMessageSize();
        if (this$maxMessageSize == null ? other$maxMessageSize != null : !((Object)this$maxMessageSize).equals(other$maxMessageSize)) {
            return false;
        }
        Integer this$maxSubscriptionsPerTopic = this.getMaxSubscriptionsPerTopic();
        Integer other$maxSubscriptionsPerTopic = other.getMaxSubscriptionsPerTopic();
        if (this$maxSubscriptionsPerTopic == null ? other$maxSubscriptionsPerTopic != null : !((Object)this$maxSubscriptionsPerTopic).equals(other$maxSubscriptionsPerTopic)) {
            return false;
        }
        Map<String, BacklogQuotaImpl> this$backLogQuotaMap = this.getBackLogQuotaMap();
        Map<String, BacklogQuotaImpl> other$backLogQuotaMap = other.getBackLogQuotaMap();
        if (this$backLogQuotaMap == null ? other$backLogQuotaMap != null : !((Object)this$backLogQuotaMap).equals(other$backLogQuotaMap)) {
            return false;
        }
        PersistencePolicies this$persistence = this.getPersistence();
        PersistencePolicies other$persistence = other.getPersistence();
        if (this$persistence == null ? other$persistence != null : !this$persistence.equals(other$persistence)) {
            return false;
        }
        RetentionPolicies this$retentionPolicies = this.getRetentionPolicies();
        RetentionPolicies other$retentionPolicies = other.getRetentionPolicies();
        if (this$retentionPolicies == null ? other$retentionPolicies != null : !this$retentionPolicies.equals(other$retentionPolicies)) {
            return false;
        }
        OffloadPoliciesImpl this$offloadPolicies = this.getOffloadPolicies();
        OffloadPoliciesImpl other$offloadPolicies = other.getOffloadPolicies();
        if (this$offloadPolicies == null ? other$offloadPolicies != null : !((Object)this$offloadPolicies).equals(other$offloadPolicies)) {
            return false;
        }
        InactiveTopicPolicies this$inactiveTopicPolicies = this.getInactiveTopicPolicies();
        InactiveTopicPolicies other$inactiveTopicPolicies = other.getInactiveTopicPolicies();
        if (this$inactiveTopicPolicies == null ? other$inactiveTopicPolicies != null : !this$inactiveTopicPolicies.equals(other$inactiveTopicPolicies)) {
            return false;
        }
        DispatchRateImpl this$dispatchRate = this.getDispatchRate();
        DispatchRateImpl other$dispatchRate = other.getDispatchRate();
        if (this$dispatchRate == null ? other$dispatchRate != null : !this$dispatchRate.equals(other$dispatchRate)) {
            return false;
        }
        DispatchRateImpl this$subscriptionDispatchRate = this.getSubscriptionDispatchRate();
        DispatchRateImpl other$subscriptionDispatchRate = other.getSubscriptionDispatchRate();
        if (this$subscriptionDispatchRate == null ? other$subscriptionDispatchRate != null : !this$subscriptionDispatchRate.equals(other$subscriptionDispatchRate)) {
            return false;
        }
        PublishRate this$publishRate = this.getPublishRate();
        PublishRate other$publishRate = other.getPublishRate();
        if (this$publishRate == null ? other$publishRate != null : !this$publishRate.equals(other$publishRate)) {
            return false;
        }
        SubscribeRate this$subscribeRate = this.getSubscribeRate();
        SubscribeRate other$subscribeRate = other.getSubscribeRate();
        if (this$subscribeRate == null ? other$subscribeRate != null : !this$subscribeRate.equals(other$subscribeRate)) {
            return false;
        }
        DispatchRateImpl this$replicatorDispatchRate = this.getReplicatorDispatchRate();
        DispatchRateImpl other$replicatorDispatchRate = other.getReplicatorDispatchRate();
        if (this$replicatorDispatchRate == null ? other$replicatorDispatchRate != null : !this$replicatorDispatchRate.equals(other$replicatorDispatchRate)) {
            return false;
        }
        List<CommandSubscribe.SubType> this$subscriptionTypesEnabled = this.getSubscriptionTypesEnabled();
        List<CommandSubscribe.SubType> other$subscriptionTypesEnabled = other.getSubscriptionTypesEnabled();
        return !(this$subscriptionTypesEnabled == null ? other$subscriptionTypesEnabled != null : !((Object)this$subscriptionTypesEnabled).equals(other$subscriptionTypesEnabled));
    }

    protected boolean canEqual(Object other) {
        return other instanceof TopicPolicies;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $deduplicationEnabled = this.getDeduplicationEnabled();
        result = result * 59 + ($deduplicationEnabled == null ? 43 : ((Object)$deduplicationEnabled).hashCode());
        Integer $messageTTLInSeconds = this.getMessageTTLInSeconds();
        result = result * 59 + ($messageTTLInSeconds == null ? 43 : ((Object)$messageTTLInSeconds).hashCode());
        Integer $maxProducerPerTopic = this.getMaxProducerPerTopic();
        result = result * 59 + ($maxProducerPerTopic == null ? 43 : ((Object)$maxProducerPerTopic).hashCode());
        Integer $maxConsumerPerTopic = this.getMaxConsumerPerTopic();
        result = result * 59 + ($maxConsumerPerTopic == null ? 43 : ((Object)$maxConsumerPerTopic).hashCode());
        Integer $maxConsumersPerSubscription = this.getMaxConsumersPerSubscription();
        result = result * 59 + ($maxConsumersPerSubscription == null ? 43 : ((Object)$maxConsumersPerSubscription).hashCode());
        Integer $maxUnackedMessagesOnConsumer = this.getMaxUnackedMessagesOnConsumer();
        result = result * 59 + ($maxUnackedMessagesOnConsumer == null ? 43 : ((Object)$maxUnackedMessagesOnConsumer).hashCode());
        Integer $maxUnackedMessagesOnSubscription = this.getMaxUnackedMessagesOnSubscription();
        result = result * 59 + ($maxUnackedMessagesOnSubscription == null ? 43 : ((Object)$maxUnackedMessagesOnSubscription).hashCode());
        Long $delayedDeliveryTickTimeMillis = this.getDelayedDeliveryTickTimeMillis();
        result = result * 59 + ($delayedDeliveryTickTimeMillis == null ? 43 : ((Object)$delayedDeliveryTickTimeMillis).hashCode());
        Boolean $delayedDeliveryEnabled = this.getDelayedDeliveryEnabled();
        result = result * 59 + ($delayedDeliveryEnabled == null ? 43 : ((Object)$delayedDeliveryEnabled).hashCode());
        Long $compactionThreshold = this.getCompactionThreshold();
        result = result * 59 + ($compactionThreshold == null ? 43 : ((Object)$compactionThreshold).hashCode());
        Integer $deduplicationSnapshotIntervalSeconds = this.getDeduplicationSnapshotIntervalSeconds();
        result = result * 59 + ($deduplicationSnapshotIntervalSeconds == null ? 43 : ((Object)$deduplicationSnapshotIntervalSeconds).hashCode());
        Integer $maxMessageSize = this.getMaxMessageSize();
        result = result * 59 + ($maxMessageSize == null ? 43 : ((Object)$maxMessageSize).hashCode());
        Integer $maxSubscriptionsPerTopic = this.getMaxSubscriptionsPerTopic();
        result = result * 59 + ($maxSubscriptionsPerTopic == null ? 43 : ((Object)$maxSubscriptionsPerTopic).hashCode());
        Map<String, BacklogQuotaImpl> $backLogQuotaMap = this.getBackLogQuotaMap();
        result = result * 59 + ($backLogQuotaMap == null ? 43 : ((Object)$backLogQuotaMap).hashCode());
        PersistencePolicies $persistence = this.getPersistence();
        result = result * 59 + ($persistence == null ? 43 : $persistence.hashCode());
        RetentionPolicies $retentionPolicies = this.getRetentionPolicies();
        result = result * 59 + ($retentionPolicies == null ? 43 : $retentionPolicies.hashCode());
        OffloadPoliciesImpl $offloadPolicies = this.getOffloadPolicies();
        result = result * 59 + ($offloadPolicies == null ? 43 : ((Object)$offloadPolicies).hashCode());
        InactiveTopicPolicies $inactiveTopicPolicies = this.getInactiveTopicPolicies();
        result = result * 59 + ($inactiveTopicPolicies == null ? 43 : $inactiveTopicPolicies.hashCode());
        DispatchRateImpl $dispatchRate = this.getDispatchRate();
        result = result * 59 + ($dispatchRate == null ? 43 : $dispatchRate.hashCode());
        DispatchRateImpl $subscriptionDispatchRate = this.getSubscriptionDispatchRate();
        result = result * 59 + ($subscriptionDispatchRate == null ? 43 : $subscriptionDispatchRate.hashCode());
        PublishRate $publishRate = this.getPublishRate();
        result = result * 59 + ($publishRate == null ? 43 : $publishRate.hashCode());
        SubscribeRate $subscribeRate = this.getSubscribeRate();
        result = result * 59 + ($subscribeRate == null ? 43 : $subscribeRate.hashCode());
        DispatchRateImpl $replicatorDispatchRate = this.getReplicatorDispatchRate();
        result = result * 59 + ($replicatorDispatchRate == null ? 43 : $replicatorDispatchRate.hashCode());
        List<CommandSubscribe.SubType> $subscriptionTypesEnabled = this.getSubscriptionTypesEnabled();
        result = result * 59 + ($subscriptionTypesEnabled == null ? 43 : ((Object)$subscriptionTypesEnabled).hashCode());
        return result;
    }

    public String toString() {
        return "TopicPolicies(backLogQuotaMap=" + this.getBackLogQuotaMap() + ", persistence=" + this.getPersistence() + ", retentionPolicies=" + this.getRetentionPolicies() + ", deduplicationEnabled=" + this.getDeduplicationEnabled() + ", messageTTLInSeconds=" + this.getMessageTTLInSeconds() + ", maxProducerPerTopic=" + this.getMaxProducerPerTopic() + ", maxConsumerPerTopic=" + this.getMaxConsumerPerTopic() + ", maxConsumersPerSubscription=" + this.getMaxConsumersPerSubscription() + ", maxUnackedMessagesOnConsumer=" + this.getMaxUnackedMessagesOnConsumer() + ", maxUnackedMessagesOnSubscription=" + this.getMaxUnackedMessagesOnSubscription() + ", delayedDeliveryTickTimeMillis=" + this.getDelayedDeliveryTickTimeMillis() + ", delayedDeliveryEnabled=" + this.getDelayedDeliveryEnabled() + ", offloadPolicies=" + this.getOffloadPolicies() + ", inactiveTopicPolicies=" + this.getInactiveTopicPolicies() + ", dispatchRate=" + this.getDispatchRate() + ", subscriptionDispatchRate=" + this.getSubscriptionDispatchRate() + ", compactionThreshold=" + this.getCompactionThreshold() + ", publishRate=" + this.getPublishRate() + ", subscribeRate=" + this.getSubscribeRate() + ", deduplicationSnapshotIntervalSeconds=" + this.getDeduplicationSnapshotIntervalSeconds() + ", maxMessageSize=" + this.getMaxMessageSize() + ", maxSubscriptionsPerTopic=" + this.getMaxSubscriptionsPerTopic() + ", replicatorDispatchRate=" + this.getReplicatorDispatchRate() + ", subscriptionTypesEnabled=" + this.getSubscriptionTypesEnabled() + ")";
    }

    public TopicPolicies() {
    }

    public TopicPolicies(Map<String, BacklogQuotaImpl> backLogQuotaMap, PersistencePolicies persistence, RetentionPolicies retentionPolicies, Boolean deduplicationEnabled, Integer messageTTLInSeconds, Integer maxProducerPerTopic, Integer maxConsumerPerTopic, Integer maxConsumersPerSubscription, Integer maxUnackedMessagesOnConsumer, Integer maxUnackedMessagesOnSubscription, Long delayedDeliveryTickTimeMillis, Boolean delayedDeliveryEnabled, OffloadPoliciesImpl offloadPolicies, InactiveTopicPolicies inactiveTopicPolicies, DispatchRateImpl dispatchRate, DispatchRateImpl subscriptionDispatchRate, Long compactionThreshold, PublishRate publishRate, SubscribeRate subscribeRate, Integer deduplicationSnapshotIntervalSeconds, Integer maxMessageSize, Integer maxSubscriptionsPerTopic, DispatchRateImpl replicatorDispatchRate, List<CommandSubscribe.SubType> subscriptionTypesEnabled) {
        this.backLogQuotaMap = backLogQuotaMap;
        this.persistence = persistence;
        this.retentionPolicies = retentionPolicies;
        this.deduplicationEnabled = deduplicationEnabled;
        this.messageTTLInSeconds = messageTTLInSeconds;
        this.maxProducerPerTopic = maxProducerPerTopic;
        this.maxConsumerPerTopic = maxConsumerPerTopic;
        this.maxConsumersPerSubscription = maxConsumersPerSubscription;
        this.maxUnackedMessagesOnConsumer = maxUnackedMessagesOnConsumer;
        this.maxUnackedMessagesOnSubscription = maxUnackedMessagesOnSubscription;
        this.delayedDeliveryTickTimeMillis = delayedDeliveryTickTimeMillis;
        this.delayedDeliveryEnabled = delayedDeliveryEnabled;
        this.offloadPolicies = offloadPolicies;
        this.inactiveTopicPolicies = inactiveTopicPolicies;
        this.dispatchRate = dispatchRate;
        this.subscriptionDispatchRate = subscriptionDispatchRate;
        this.compactionThreshold = compactionThreshold;
        this.publishRate = publishRate;
        this.subscribeRate = subscribeRate;
        this.deduplicationSnapshotIntervalSeconds = deduplicationSnapshotIntervalSeconds;
        this.maxMessageSize = maxMessageSize;
        this.maxSubscriptionsPerTopic = maxSubscriptionsPerTopic;
        this.replicatorDispatchRate = replicatorDispatchRate;
        this.subscriptionTypesEnabled = subscriptionTypesEnabled;
    }

    public Map<String, BacklogQuotaImpl> getBackLogQuotaMap() {
        return this.backLogQuotaMap;
    }

    public PersistencePolicies getPersistence() {
        return this.persistence;
    }

    public RetentionPolicies getRetentionPolicies() {
        return this.retentionPolicies;
    }

    public Boolean getDeduplicationEnabled() {
        return this.deduplicationEnabled;
    }

    public Integer getMessageTTLInSeconds() {
        return this.messageTTLInSeconds;
    }

    public Integer getMaxProducerPerTopic() {
        return this.maxProducerPerTopic;
    }

    public Integer getMaxConsumerPerTopic() {
        return this.maxConsumerPerTopic;
    }

    public Integer getMaxConsumersPerSubscription() {
        return this.maxConsumersPerSubscription;
    }

    public Integer getMaxUnackedMessagesOnConsumer() {
        return this.maxUnackedMessagesOnConsumer;
    }

    public Integer getMaxUnackedMessagesOnSubscription() {
        return this.maxUnackedMessagesOnSubscription;
    }

    public Long getDelayedDeliveryTickTimeMillis() {
        return this.delayedDeliveryTickTimeMillis;
    }

    public Boolean getDelayedDeliveryEnabled() {
        return this.delayedDeliveryEnabled;
    }

    public OffloadPoliciesImpl getOffloadPolicies() {
        return this.offloadPolicies;
    }

    public InactiveTopicPolicies getInactiveTopicPolicies() {
        return this.inactiveTopicPolicies;
    }

    public DispatchRateImpl getDispatchRate() {
        return this.dispatchRate;
    }

    public DispatchRateImpl getSubscriptionDispatchRate() {
        return this.subscriptionDispatchRate;
    }

    public Long getCompactionThreshold() {
        return this.compactionThreshold;
    }

    public PublishRate getPublishRate() {
        return this.publishRate;
    }

    public SubscribeRate getSubscribeRate() {
        return this.subscribeRate;
    }

    public Integer getDeduplicationSnapshotIntervalSeconds() {
        return this.deduplicationSnapshotIntervalSeconds;
    }

    public Integer getMaxMessageSize() {
        return this.maxMessageSize;
    }

    public Integer getMaxSubscriptionsPerTopic() {
        return this.maxSubscriptionsPerTopic;
    }

    public DispatchRateImpl getReplicatorDispatchRate() {
        return this.replicatorDispatchRate;
    }

    public List<CommandSubscribe.SubType> getSubscriptionTypesEnabled() {
        return this.subscriptionTypesEnabled;
    }

    public void setBackLogQuotaMap(Map<String, BacklogQuotaImpl> backLogQuotaMap) {
        this.backLogQuotaMap = backLogQuotaMap;
    }

    public void setPersistence(PersistencePolicies persistence) {
        this.persistence = persistence;
    }

    public void setRetentionPolicies(RetentionPolicies retentionPolicies) {
        this.retentionPolicies = retentionPolicies;
    }

    public void setDeduplicationEnabled(Boolean deduplicationEnabled) {
        this.deduplicationEnabled = deduplicationEnabled;
    }

    public void setMessageTTLInSeconds(Integer messageTTLInSeconds) {
        this.messageTTLInSeconds = messageTTLInSeconds;
    }

    public void setMaxProducerPerTopic(Integer maxProducerPerTopic) {
        this.maxProducerPerTopic = maxProducerPerTopic;
    }

    public void setMaxConsumerPerTopic(Integer maxConsumerPerTopic) {
        this.maxConsumerPerTopic = maxConsumerPerTopic;
    }

    public void setMaxConsumersPerSubscription(Integer maxConsumersPerSubscription) {
        this.maxConsumersPerSubscription = maxConsumersPerSubscription;
    }

    public void setMaxUnackedMessagesOnConsumer(Integer maxUnackedMessagesOnConsumer) {
        this.maxUnackedMessagesOnConsumer = maxUnackedMessagesOnConsumer;
    }

    public void setMaxUnackedMessagesOnSubscription(Integer maxUnackedMessagesOnSubscription) {
        this.maxUnackedMessagesOnSubscription = maxUnackedMessagesOnSubscription;
    }

    public void setDelayedDeliveryTickTimeMillis(Long delayedDeliveryTickTimeMillis) {
        this.delayedDeliveryTickTimeMillis = delayedDeliveryTickTimeMillis;
    }

    public void setDelayedDeliveryEnabled(Boolean delayedDeliveryEnabled) {
        this.delayedDeliveryEnabled = delayedDeliveryEnabled;
    }

    public void setOffloadPolicies(OffloadPoliciesImpl offloadPolicies) {
        this.offloadPolicies = offloadPolicies;
    }

    public void setInactiveTopicPolicies(InactiveTopicPolicies inactiveTopicPolicies) {
        this.inactiveTopicPolicies = inactiveTopicPolicies;
    }

    public void setDispatchRate(DispatchRateImpl dispatchRate) {
        this.dispatchRate = dispatchRate;
    }

    public void setSubscriptionDispatchRate(DispatchRateImpl subscriptionDispatchRate) {
        this.subscriptionDispatchRate = subscriptionDispatchRate;
    }

    public void setCompactionThreshold(Long compactionThreshold) {
        this.compactionThreshold = compactionThreshold;
    }

    public void setPublishRate(PublishRate publishRate) {
        this.publishRate = publishRate;
    }

    public void setSubscribeRate(SubscribeRate subscribeRate) {
        this.subscribeRate = subscribeRate;
    }

    public void setDeduplicationSnapshotIntervalSeconds(Integer deduplicationSnapshotIntervalSeconds) {
        this.deduplicationSnapshotIntervalSeconds = deduplicationSnapshotIntervalSeconds;
    }

    public void setMaxMessageSize(Integer maxMessageSize) {
        this.maxMessageSize = maxMessageSize;
    }

    public void setMaxSubscriptionsPerTopic(Integer maxSubscriptionsPerTopic) {
        this.maxSubscriptionsPerTopic = maxSubscriptionsPerTopic;
    }

    public void setReplicatorDispatchRate(DispatchRateImpl replicatorDispatchRate) {
        this.replicatorDispatchRate = replicatorDispatchRate;
    }

    public void setSubscriptionTypesEnabled(List<CommandSubscribe.SubType> subscriptionTypesEnabled) {
        this.subscriptionTypesEnabled = subscriptionTypesEnabled;
    }

    public static class TopicPoliciesBuilder {
        private Map<String, BacklogQuotaImpl> backLogQuotaMap;
        private PersistencePolicies persistence;
        private RetentionPolicies retentionPolicies;
        private Boolean deduplicationEnabled;
        private Integer messageTTLInSeconds;
        private Integer maxProducerPerTopic;
        private Integer maxConsumerPerTopic;
        private Integer maxConsumersPerSubscription;
        private Integer maxUnackedMessagesOnConsumer;
        private Integer maxUnackedMessagesOnSubscription;
        private Long delayedDeliveryTickTimeMillis;
        private Boolean delayedDeliveryEnabled;
        private OffloadPoliciesImpl offloadPolicies;
        private InactiveTopicPolicies inactiveTopicPolicies;
        private DispatchRateImpl dispatchRate;
        private DispatchRateImpl subscriptionDispatchRate;
        private Long compactionThreshold;
        private PublishRate publishRate;
        private SubscribeRate subscribeRate;
        private Integer deduplicationSnapshotIntervalSeconds;
        private Integer maxMessageSize;
        private Integer maxSubscriptionsPerTopic;
        private DispatchRateImpl replicatorDispatchRate;
        private List<CommandSubscribe.SubType> subscriptionTypesEnabled;

        TopicPoliciesBuilder() {
        }

        public TopicPoliciesBuilder backLogQuotaMap(Map<String, BacklogQuotaImpl> backLogQuotaMap) {
            this.backLogQuotaMap = backLogQuotaMap;
            return this;
        }

        public TopicPoliciesBuilder persistence(PersistencePolicies persistence) {
            this.persistence = persistence;
            return this;
        }

        public TopicPoliciesBuilder retentionPolicies(RetentionPolicies retentionPolicies) {
            this.retentionPolicies = retentionPolicies;
            return this;
        }

        public TopicPoliciesBuilder deduplicationEnabled(Boolean deduplicationEnabled) {
            this.deduplicationEnabled = deduplicationEnabled;
            return this;
        }

        public TopicPoliciesBuilder messageTTLInSeconds(Integer messageTTLInSeconds) {
            this.messageTTLInSeconds = messageTTLInSeconds;
            return this;
        }

        public TopicPoliciesBuilder maxProducerPerTopic(Integer maxProducerPerTopic) {
            this.maxProducerPerTopic = maxProducerPerTopic;
            return this;
        }

        public TopicPoliciesBuilder maxConsumerPerTopic(Integer maxConsumerPerTopic) {
            this.maxConsumerPerTopic = maxConsumerPerTopic;
            return this;
        }

        public TopicPoliciesBuilder maxConsumersPerSubscription(Integer maxConsumersPerSubscription) {
            this.maxConsumersPerSubscription = maxConsumersPerSubscription;
            return this;
        }

        public TopicPoliciesBuilder maxUnackedMessagesOnConsumer(Integer maxUnackedMessagesOnConsumer) {
            this.maxUnackedMessagesOnConsumer = maxUnackedMessagesOnConsumer;
            return this;
        }

        public TopicPoliciesBuilder maxUnackedMessagesOnSubscription(Integer maxUnackedMessagesOnSubscription) {
            this.maxUnackedMessagesOnSubscription = maxUnackedMessagesOnSubscription;
            return this;
        }

        public TopicPoliciesBuilder delayedDeliveryTickTimeMillis(Long delayedDeliveryTickTimeMillis) {
            this.delayedDeliveryTickTimeMillis = delayedDeliveryTickTimeMillis;
            return this;
        }

        public TopicPoliciesBuilder delayedDeliveryEnabled(Boolean delayedDeliveryEnabled) {
            this.delayedDeliveryEnabled = delayedDeliveryEnabled;
            return this;
        }

        public TopicPoliciesBuilder offloadPolicies(OffloadPoliciesImpl offloadPolicies) {
            this.offloadPolicies = offloadPolicies;
            return this;
        }

        public TopicPoliciesBuilder inactiveTopicPolicies(InactiveTopicPolicies inactiveTopicPolicies) {
            this.inactiveTopicPolicies = inactiveTopicPolicies;
            return this;
        }

        public TopicPoliciesBuilder dispatchRate(DispatchRateImpl dispatchRate) {
            this.dispatchRate = dispatchRate;
            return this;
        }

        public TopicPoliciesBuilder subscriptionDispatchRate(DispatchRateImpl subscriptionDispatchRate) {
            this.subscriptionDispatchRate = subscriptionDispatchRate;
            return this;
        }

        public TopicPoliciesBuilder compactionThreshold(Long compactionThreshold) {
            this.compactionThreshold = compactionThreshold;
            return this;
        }

        public TopicPoliciesBuilder publishRate(PublishRate publishRate) {
            this.publishRate = publishRate;
            return this;
        }

        public TopicPoliciesBuilder subscribeRate(SubscribeRate subscribeRate) {
            this.subscribeRate = subscribeRate;
            return this;
        }

        public TopicPoliciesBuilder deduplicationSnapshotIntervalSeconds(Integer deduplicationSnapshotIntervalSeconds) {
            this.deduplicationSnapshotIntervalSeconds = deduplicationSnapshotIntervalSeconds;
            return this;
        }

        public TopicPoliciesBuilder maxMessageSize(Integer maxMessageSize) {
            this.maxMessageSize = maxMessageSize;
            return this;
        }

        public TopicPoliciesBuilder maxSubscriptionsPerTopic(Integer maxSubscriptionsPerTopic) {
            this.maxSubscriptionsPerTopic = maxSubscriptionsPerTopic;
            return this;
        }

        public TopicPoliciesBuilder replicatorDispatchRate(DispatchRateImpl replicatorDispatchRate) {
            this.replicatorDispatchRate = replicatorDispatchRate;
            return this;
        }

        public TopicPoliciesBuilder subscriptionTypesEnabled(List<CommandSubscribe.SubType> subscriptionTypesEnabled) {
            this.subscriptionTypesEnabled = subscriptionTypesEnabled;
            return this;
        }

        public TopicPolicies build() {
            return new TopicPolicies(this.backLogQuotaMap, this.persistence, this.retentionPolicies, this.deduplicationEnabled, this.messageTTLInSeconds, this.maxProducerPerTopic, this.maxConsumerPerTopic, this.maxConsumersPerSubscription, this.maxUnackedMessagesOnConsumer, this.maxUnackedMessagesOnSubscription, this.delayedDeliveryTickTimeMillis, this.delayedDeliveryEnabled, this.offloadPolicies, this.inactiveTopicPolicies, this.dispatchRate, this.subscriptionDispatchRate, this.compactionThreshold, this.publishRate, this.subscribeRate, this.deduplicationSnapshotIntervalSeconds, this.maxMessageSize, this.maxSubscriptionsPerTopic, this.replicatorDispatchRate, this.subscriptionTypesEnabled);
        }

        public String toString() {
            return "TopicPolicies.TopicPoliciesBuilder(backLogQuotaMap=" + this.backLogQuotaMap + ", persistence=" + this.persistence + ", retentionPolicies=" + this.retentionPolicies + ", deduplicationEnabled=" + this.deduplicationEnabled + ", messageTTLInSeconds=" + this.messageTTLInSeconds + ", maxProducerPerTopic=" + this.maxProducerPerTopic + ", maxConsumerPerTopic=" + this.maxConsumerPerTopic + ", maxConsumersPerSubscription=" + this.maxConsumersPerSubscription + ", maxUnackedMessagesOnConsumer=" + this.maxUnackedMessagesOnConsumer + ", maxUnackedMessagesOnSubscription=" + this.maxUnackedMessagesOnSubscription + ", delayedDeliveryTickTimeMillis=" + this.delayedDeliveryTickTimeMillis + ", delayedDeliveryEnabled=" + this.delayedDeliveryEnabled + ", offloadPolicies=" + this.offloadPolicies + ", inactiveTopicPolicies=" + this.inactiveTopicPolicies + ", dispatchRate=" + this.dispatchRate + ", subscriptionDispatchRate=" + this.subscriptionDispatchRate + ", compactionThreshold=" + this.compactionThreshold + ", publishRate=" + this.publishRate + ", subscribeRate=" + this.subscribeRate + ", deduplicationSnapshotIntervalSeconds=" + this.deduplicationSnapshotIntervalSeconds + ", maxMessageSize=" + this.maxMessageSize + ", maxSubscriptionsPerTopic=" + this.maxSubscriptionsPerTopic + ", replicatorDispatchRate=" + this.replicatorDispatchRate + ", subscriptionTypesEnabled=" + this.subscriptionTypesEnabled + ")";
        }
    }
}

