/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.common.protocol;

import java.io.IOException;
import java.util.Map;
import java.util.Optional;
import org.apache.pulsar.common.api.proto.PulsarApi;
import org.apache.pulsar.common.api.proto.PulsarMarkers;
import org.apache.pulsar.common.protocol.Commands;
import org.apache.pulsar.common.util.protobuf.ByteBufCodedInputStream;
import org.apache.pulsar.common.util.protobuf.ByteBufCodedOutputStream;
import org.apache.pulsar.shade.io.netty.buffer.ByteBuf;
import org.apache.pulsar.shade.io.netty.buffer.PooledByteBufAllocator;

public final class Markers {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ByteBuf newMessage(PulsarMarkers.MarkerType markerType, Optional<String> restrictToCluster, ByteBuf payload) {
        PulsarApi.MessageMetadata.Builder msgMetadataBuilder = PulsarApi.MessageMetadata.newBuilder();
        msgMetadataBuilder.setPublishTime(System.currentTimeMillis());
        msgMetadataBuilder.setProducerName("pulsar.marker");
        msgMetadataBuilder.setSequenceId(0L);
        msgMetadataBuilder.setMarkerType(markerType.getNumber());
        if (restrictToCluster.isPresent()) {
            msgMetadataBuilder.addReplicateTo(restrictToCluster.get());
        }
        PulsarApi.MessageMetadata msgMetadata = msgMetadataBuilder.build();
        try {
            ByteBuf byteBuf = Commands.serializeMetadataAndPayload(Commands.ChecksumType.Crc32c, msgMetadata, payload);
            return byteBuf;
        }
        finally {
            msgMetadata.recycle();
            msgMetadataBuilder.recycle();
        }
    }

    public static boolean isServerOnlyMarker(PulsarApi.MessageMetadata msgMetadata) {
        return msgMetadata.hasMarkerType();
    }

    public static boolean isReplicatedSubscriptionSnapshotMarker(PulsarApi.MessageMetadata msgMetadata) {
        return msgMetadata != null && msgMetadata.hasMarkerType() && msgMetadata.getMarkerType() == 12;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ByteBuf newReplicatedSubscriptionsSnapshotRequest(String snapshotId, String sourceCluster) {
        ByteBuf byteBuf;
        PulsarMarkers.ReplicatedSubscriptionsSnapshotRequest.Builder builder = PulsarMarkers.ReplicatedSubscriptionsSnapshotRequest.newBuilder();
        builder.setSnapshotId(snapshotId);
        builder.setSourceCluster(sourceCluster);
        PulsarMarkers.ReplicatedSubscriptionsSnapshotRequest req = builder.build();
        int size = req.getSerializedSize();
        ByteBuf payload = PooledByteBufAllocator.DEFAULT.buffer(size);
        ByteBufCodedOutputStream outStream = ByteBufCodedOutputStream.get(payload);
        try {
            req.writeTo(outStream);
            byteBuf = Markers.newMessage(PulsarMarkers.MarkerType.REPLICATED_SUBSCRIPTION_SNAPSHOT_REQUEST, Optional.empty(), payload);
        }
        catch (Throwable throwable) {
            payload.release();
            builder.recycle();
            req.recycle();
            outStream.recycle();
            throw throwable;
        }
        payload.release();
        builder.recycle();
        req.recycle();
        outStream.recycle();
        return byteBuf;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static PulsarMarkers.ReplicatedSubscriptionsSnapshotRequest parseReplicatedSubscriptionsSnapshotRequest(ByteBuf payload) throws IOException {
        ByteBufCodedInputStream inStream = ByteBufCodedInputStream.get(payload);
        PulsarMarkers.ReplicatedSubscriptionsSnapshotRequest.Builder builder = null;
        try {
            builder = PulsarMarkers.ReplicatedSubscriptionsSnapshotRequest.newBuilder();
            PulsarMarkers.ReplicatedSubscriptionsSnapshotRequest replicatedSubscriptionsSnapshotRequest = builder.mergeFrom(inStream, null).build();
            return replicatedSubscriptionsSnapshotRequest;
        }
        finally {
            builder.recycle();
            inStream.recycle();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ByteBuf newReplicatedSubscriptionsSnapshotResponse(String snapshotId, String replyToCluster, String cluster, long ledgerId, long entryId) {
        ByteBuf byteBuf;
        PulsarMarkers.ReplicatedSubscriptionsSnapshotResponse.Builder builder = PulsarMarkers.ReplicatedSubscriptionsSnapshotResponse.newBuilder();
        builder.setSnapshotId(snapshotId);
        PulsarMarkers.MessageIdData.Builder msgIdBuilder = PulsarMarkers.MessageIdData.newBuilder();
        msgIdBuilder.setLedgerId(ledgerId);
        msgIdBuilder.setEntryId(entryId);
        PulsarMarkers.ClusterMessageId.Builder clusterMessageIdBuilder = PulsarMarkers.ClusterMessageId.newBuilder();
        clusterMessageIdBuilder.setCluster(cluster);
        clusterMessageIdBuilder.setMessageId(msgIdBuilder);
        builder.setCluster(clusterMessageIdBuilder);
        PulsarMarkers.ReplicatedSubscriptionsSnapshotResponse response = builder.build();
        int size = response.getSerializedSize();
        ByteBuf payload = PooledByteBufAllocator.DEFAULT.buffer(size);
        ByteBufCodedOutputStream outStream = ByteBufCodedOutputStream.get(payload);
        try {
            response.writeTo(outStream);
            byteBuf = Markers.newMessage(PulsarMarkers.MarkerType.REPLICATED_SUBSCRIPTION_SNAPSHOT_RESPONSE, Optional.of(replyToCluster), payload);
            msgIdBuilder.recycle();
            clusterMessageIdBuilder.recycle();
        }
        catch (Throwable throwable) {
            msgIdBuilder.recycle();
            clusterMessageIdBuilder.recycle();
            payload.release();
            builder.recycle();
            response.recycle();
            outStream.recycle();
            throw throwable;
        }
        payload.release();
        builder.recycle();
        response.recycle();
        outStream.recycle();
        return byteBuf;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static PulsarMarkers.ReplicatedSubscriptionsSnapshotResponse parseReplicatedSubscriptionsSnapshotResponse(ByteBuf payload) throws IOException {
        ByteBufCodedInputStream inStream = ByteBufCodedInputStream.get(payload);
        PulsarMarkers.ReplicatedSubscriptionsSnapshotResponse.Builder builder = null;
        try {
            builder = PulsarMarkers.ReplicatedSubscriptionsSnapshotResponse.newBuilder();
            PulsarMarkers.ReplicatedSubscriptionsSnapshotResponse replicatedSubscriptionsSnapshotResponse = builder.mergeFrom(inStream, null).build();
            return replicatedSubscriptionsSnapshotResponse;
        }
        finally {
            builder.recycle();
            inStream.recycle();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ByteBuf newReplicatedSubscriptionsSnapshot(String snapshotId, String sourceCluster, long ledgerId, long entryId, Map<String, PulsarMarkers.MessageIdData> clusterIds) {
        ByteBuf byteBuf;
        PulsarMarkers.ReplicatedSubscriptionsSnapshot.Builder builder = PulsarMarkers.ReplicatedSubscriptionsSnapshot.newBuilder();
        builder.setSnapshotId(snapshotId);
        PulsarMarkers.MessageIdData.Builder msgIdBuilder = PulsarMarkers.MessageIdData.newBuilder();
        msgIdBuilder.setLedgerId(ledgerId);
        msgIdBuilder.setEntryId(entryId);
        builder.setLocalMessageId(msgIdBuilder);
        clusterIds.forEach((cluster, msgId) -> {
            PulsarMarkers.ClusterMessageId.Builder clusterMessageIdBuilder = PulsarMarkers.ClusterMessageId.newBuilder().setCluster((String)cluster).setMessageId((PulsarMarkers.MessageIdData)msgId);
            builder.addClusters(clusterMessageIdBuilder);
            clusterMessageIdBuilder.recycle();
        });
        PulsarMarkers.ReplicatedSubscriptionsSnapshot snapshot = builder.build();
        int size = snapshot.getSerializedSize();
        ByteBuf payload = PooledByteBufAllocator.DEFAULT.buffer(size);
        ByteBufCodedOutputStream outStream = ByteBufCodedOutputStream.get(payload);
        try {
            snapshot.writeTo(outStream);
            byteBuf = Markers.newMessage(PulsarMarkers.MarkerType.REPLICATED_SUBSCRIPTION_SNAPSHOT, Optional.of(sourceCluster), payload);
        }
        catch (Throwable throwable) {
            payload.release();
            builder.recycle();
            snapshot.recycle();
            outStream.recycle();
            throw throwable;
        }
        payload.release();
        builder.recycle();
        snapshot.recycle();
        outStream.recycle();
        return byteBuf;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static PulsarMarkers.ReplicatedSubscriptionsSnapshot parseReplicatedSubscriptionsSnapshot(ByteBuf payload) throws IOException {
        ByteBufCodedInputStream inStream = ByteBufCodedInputStream.get(payload);
        PulsarMarkers.ReplicatedSubscriptionsSnapshot.Builder builder = null;
        try {
            builder = PulsarMarkers.ReplicatedSubscriptionsSnapshot.newBuilder();
            PulsarMarkers.ReplicatedSubscriptionsSnapshot replicatedSubscriptionsSnapshot = builder.mergeFrom(inStream, null).build();
            return replicatedSubscriptionsSnapshot;
        }
        finally {
            builder.recycle();
            inStream.recycle();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ByteBuf newReplicatedSubscriptionsUpdate(String subscriptionName, Map<String, PulsarMarkers.MessageIdData> clusterIds) {
        ByteBuf byteBuf;
        PulsarMarkers.ReplicatedSubscriptionsUpdate.Builder builder = PulsarMarkers.ReplicatedSubscriptionsUpdate.newBuilder();
        builder.setSubscriptionName(subscriptionName);
        clusterIds.forEach((cluster, msgId) -> {
            PulsarMarkers.ClusterMessageId.Builder clusterMessageIdBuilder = PulsarMarkers.ClusterMessageId.newBuilder().setCluster((String)cluster).setMessageId((PulsarMarkers.MessageIdData)msgId);
            builder.addClusters(clusterMessageIdBuilder);
            clusterMessageIdBuilder.recycle();
        });
        PulsarMarkers.ReplicatedSubscriptionsUpdate update = builder.build();
        int size = update.getSerializedSize();
        ByteBuf payload = PooledByteBufAllocator.DEFAULT.buffer(size);
        ByteBufCodedOutputStream outStream = ByteBufCodedOutputStream.get(payload);
        try {
            update.writeTo(outStream);
            byteBuf = Markers.newMessage(PulsarMarkers.MarkerType.REPLICATED_SUBSCRIPTION_UPDATE, Optional.empty(), payload);
        }
        catch (Throwable throwable) {
            payload.release();
            builder.recycle();
            update.recycle();
            outStream.recycle();
            throw throwable;
        }
        payload.release();
        builder.recycle();
        update.recycle();
        outStream.recycle();
        return byteBuf;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static PulsarMarkers.ReplicatedSubscriptionsUpdate parseReplicatedSubscriptionsUpdate(ByteBuf payload) throws IOException {
        ByteBufCodedInputStream inStream = ByteBufCodedInputStream.get(payload);
        PulsarMarkers.ReplicatedSubscriptionsUpdate.Builder builder = null;
        try {
            builder = PulsarMarkers.ReplicatedSubscriptionsUpdate.newBuilder();
            PulsarMarkers.ReplicatedSubscriptionsUpdate replicatedSubscriptionsUpdate = builder.mergeFrom(inStream, null).build();
            return replicatedSubscriptionsUpdate;
        }
        finally {
            builder.recycle();
            inStream.recycle();
        }
    }

    public static boolean isTxnCommitMarker(PulsarApi.MessageMetadata msgMetadata) {
        return msgMetadata != null && msgMetadata.hasMarkerType() && msgMetadata.getMarkerType() == 20;
    }

    public static ByteBuf newTxnCommitMarker(long sequenceId, long txnMostBits, long txnLeastBits, PulsarMarkers.MessageIdData messageIdData) {
        return Markers.newTxnMarker(PulsarMarkers.MarkerType.TXN_COMMIT, sequenceId, txnMostBits, txnLeastBits, Optional.of(messageIdData));
    }

    public static boolean isTxnAbortMarker(PulsarApi.MessageMetadata msgMetadata) {
        return msgMetadata != null && msgMetadata.hasMarkerType() && msgMetadata.getMarkerType() == 21;
    }

    public static ByteBuf newTxnAbortMarker(long sequenceId, long txnMostBits, long txnLeastBits) {
        return Markers.newTxnMarker(PulsarMarkers.MarkerType.TXN_ABORT, sequenceId, txnMostBits, txnLeastBits, Optional.empty());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static PulsarMarkers.TxnCommitMarker parseCommitMarker(ByteBuf payload) throws IOException {
        ByteBufCodedInputStream inStream = ByteBufCodedInputStream.get(payload);
        PulsarMarkers.TxnCommitMarker.Builder builder = null;
        try {
            builder = PulsarMarkers.TxnCommitMarker.newBuilder();
            PulsarMarkers.TxnCommitMarker txnCommitMarker = builder.mergeFrom(inStream, null).build();
            return txnCommitMarker;
        }
        finally {
            builder.recycle();
            inStream.recycle();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ByteBuf newTxnMarker(PulsarMarkers.MarkerType markerType, long sequenceId, long txnMostBits, long txnLeastBits, Optional<PulsarMarkers.MessageIdData> messageIdData) {
        ByteBuf byteBuf;
        ByteBuf payload;
        PulsarApi.MessageMetadata.Builder msgMetadataBuilder = PulsarApi.MessageMetadata.newBuilder();
        msgMetadataBuilder.setPublishTime(System.currentTimeMillis());
        msgMetadataBuilder.setProducerName("pulsar.txn.marker");
        msgMetadataBuilder.setSequenceId(sequenceId);
        msgMetadataBuilder.setMarkerType(markerType.getNumber());
        msgMetadataBuilder.setTxnidMostBits(txnMostBits);
        msgMetadataBuilder.setTxnidLeastBits(txnLeastBits);
        PulsarApi.MessageMetadata msgMetadata = msgMetadataBuilder.build();
        if (messageIdData.isPresent()) {
            PulsarMarkers.TxnCommitMarker commitMarker = PulsarMarkers.TxnCommitMarker.newBuilder().setMessageId(messageIdData.get()).build();
            int size = commitMarker.getSerializedSize();
            payload = PooledByteBufAllocator.DEFAULT.buffer(size);
            ByteBufCodedOutputStream outStream = ByteBufCodedOutputStream.get(payload);
            commitMarker.writeTo(outStream);
        } else {
            payload = PooledByteBufAllocator.DEFAULT.buffer();
        }
        try {
            byteBuf = Commands.serializeMetadataAndPayload(Commands.ChecksumType.Crc32c, msgMetadata, payload);
        }
        catch (Throwable throwable) {
            payload.release();
            msgMetadata.recycle();
            msgMetadataBuilder.recycle();
            throw throwable;
        }
        payload.release();
        msgMetadata.recycle();
        msgMetadataBuilder.recycle();
        return byteBuf;
    }

    private Markers() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

