/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.client.admin;

import java.io.Closeable;
import java.io.IOException;
import java.net.URL;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.pulsar.client.admin.Bookies;
import org.apache.pulsar.client.admin.BrokerStats;
import org.apache.pulsar.client.admin.Brokers;
import org.apache.pulsar.client.admin.Clusters;
import org.apache.pulsar.client.admin.Functions;
import org.apache.pulsar.client.admin.Lookup;
import org.apache.pulsar.client.admin.Namespaces;
import org.apache.pulsar.client.admin.NonPersistentTopics;
import org.apache.pulsar.client.admin.Properties;
import org.apache.pulsar.client.admin.PulsarAdminBuilder;
import org.apache.pulsar.client.admin.ResourceQuotas;
import org.apache.pulsar.client.admin.Schemas;
import org.apache.pulsar.client.admin.Sink;
import org.apache.pulsar.client.admin.Sinks;
import org.apache.pulsar.client.admin.Source;
import org.apache.pulsar.client.admin.Sources;
import org.apache.pulsar.client.admin.Tenants;
import org.apache.pulsar.client.admin.Topics;
import org.apache.pulsar.client.admin.Worker;
import org.apache.pulsar.client.admin.internal.BookiesImpl;
import org.apache.pulsar.client.admin.internal.BrokerStatsImpl;
import org.apache.pulsar.client.admin.internal.BrokersImpl;
import org.apache.pulsar.client.admin.internal.ClustersImpl;
import org.apache.pulsar.client.admin.internal.FunctionsImpl;
import org.apache.pulsar.client.admin.internal.JacksonConfigurator;
import org.apache.pulsar.client.admin.internal.LookupImpl;
import org.apache.pulsar.client.admin.internal.NamespacesImpl;
import org.apache.pulsar.client.admin.internal.NonPersistentTopicsImpl;
import org.apache.pulsar.client.admin.internal.PulsarAdminBuilderImpl;
import org.apache.pulsar.client.admin.internal.ResourceQuotasImpl;
import org.apache.pulsar.client.admin.internal.SchemasImpl;
import org.apache.pulsar.client.admin.internal.SinksImpl;
import org.apache.pulsar.client.admin.internal.SourcesImpl;
import org.apache.pulsar.client.admin.internal.TenantsImpl;
import org.apache.pulsar.client.admin.internal.TopicsImpl;
import org.apache.pulsar.client.admin.internal.WorkerImpl;
import org.apache.pulsar.client.admin.internal.http.AsyncHttpConnectorProvider;
import org.apache.pulsar.client.api.Authentication;
import org.apache.pulsar.client.api.AuthenticationFactory;
import org.apache.pulsar.client.api.PulsarClientException;
import org.apache.pulsar.client.impl.auth.AuthenticationDisabled;
import org.apache.pulsar.client.impl.conf.ClientConfigurationData;
import org.apache.pulsar.shade.javax.ws.rs.client.Client;
import org.apache.pulsar.shade.javax.ws.rs.client.ClientBuilder;
import org.apache.pulsar.shade.javax.ws.rs.client.WebTarget;
import org.apache.pulsar.shade.org.apache.commons.lang3.StringUtils;
import org.apache.pulsar.shade.org.asynchttpclient.AsyncHttpClient;
import org.apache.pulsar.shade.org.glassfish.jersey.client.ClientConfig;
import org.apache.pulsar.shade.org.glassfish.jersey.jackson.JacksonFeature;
import org.apache.pulsar.shade.org.glassfish.jersey.media.multipart.MultiPartFeature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.bridge.SLF4JBridgeHandler;

public class PulsarAdmin
implements Closeable {
    private static final Logger LOG = LoggerFactory.getLogger(PulsarAdmin.class);
    public static final int DEFAULT_CONNECT_TIMEOUT_SECONDS = 60;
    public static final int DEFAULT_READ_TIMEOUT_SECONDS = 60;
    public static final int DEFAULT_REQUEST_TIMEOUT_SECONDS = 300;
    private final Clusters clusters;
    private final Brokers brokers;
    private final BrokerStats brokerStats;
    private final Tenants tenants;
    private final Properties properties;
    private final Namespaces namespaces;
    private final Bookies bookies;
    private final TopicsImpl topics;
    private final NonPersistentTopics nonPersistentTopics;
    private final ResourceQuotas resourceQuotas;
    private final ClientConfigurationData clientConfigData;
    private final Client client;
    private final AsyncHttpClient httpAsyncClient;
    private final String serviceUrl;
    private final Lookup lookups;
    private final Functions functions;
    private final Sources sources;
    private final Sinks sinks;
    private final Worker worker;
    private final Schemas schemas;
    protected final WebTarget root;
    protected final Authentication auth;
    private final int connectTimeout;
    private final TimeUnit connectTimeoutUnit;
    private final int readTimeout;
    private final TimeUnit readTimeoutUnit;
    private final int requestTimeout;
    private final TimeUnit requestTimeoutUnit;

    public static PulsarAdminBuilder builder() {
        return new PulsarAdminBuilderImpl();
    }

    public PulsarAdmin(String serviceUrl, ClientConfigurationData clientConfigData) throws PulsarClientException {
        this(serviceUrl, clientConfigData, 60, TimeUnit.SECONDS, 60, TimeUnit.SECONDS, 300, TimeUnit.SECONDS);
    }

    public PulsarAdmin(String serviceUrl, ClientConfigurationData clientConfigData, int connectTimeout, TimeUnit connectTimeoutUnit, int readTimeout, TimeUnit readTimeoutUnit, int requestTimeout, TimeUnit requestTimeoutUnit) throws PulsarClientException {
        this.connectTimeout = connectTimeout;
        this.connectTimeoutUnit = connectTimeoutUnit;
        this.readTimeout = readTimeout;
        this.readTimeoutUnit = readTimeoutUnit;
        this.requestTimeout = requestTimeout;
        this.requestTimeoutUnit = requestTimeoutUnit;
        this.clientConfigData = clientConfigData;
        this.auth = clientConfigData != null ? clientConfigData.getAuthentication() : new AuthenticationDisabled();
        LOG.debug("created: serviceUrl={}, authMethodName={}", (Object)serviceUrl, this.auth != null ? this.auth.getAuthMethodName() : null);
        if (this.auth != null) {
            this.auth.start();
        }
        if (StringUtils.isBlank(clientConfigData.getServiceUrl())) {
            clientConfigData.setServiceUrl(serviceUrl);
        }
        AsyncHttpConnectorProvider asyncConnectorProvider = new AsyncHttpConnectorProvider(clientConfigData);
        ClientConfig httpConfig = new ClientConfig();
        httpConfig.property("org.apache.pulsar.shade.jersey.config.client.followRedirects", true);
        httpConfig.property("org.apache.pulsar.shade.jersey.config.client.async.threadPoolSize", 8);
        httpConfig.register((Class)MultiPartFeature.class);
        httpConfig.connectorProvider(asyncConnectorProvider);
        ClientBuilder clientBuilder = (ClientBuilder)((ClientBuilder)ClientBuilder.newBuilder().withConfig(httpConfig).connectTimeout(this.connectTimeout, this.connectTimeoutUnit).readTimeout(this.readTimeout, this.readTimeoutUnit).register(JacksonConfigurator.class)).register(JacksonFeature.class);
        boolean useTls = clientConfigData.getServiceUrl().startsWith("https://");
        this.client = clientBuilder.build();
        this.serviceUrl = serviceUrl;
        this.root = this.client.target(serviceUrl);
        this.httpAsyncClient = asyncConnectorProvider.getConnector(Math.toIntExact(connectTimeoutUnit.toMillis(this.connectTimeout)), Math.toIntExact(readTimeoutUnit.toMillis(this.readTimeout)), Math.toIntExact(requestTimeoutUnit.toMillis(this.requestTimeout))).getHttpClient();
        long readTimeoutMs = readTimeoutUnit.toMillis(this.readTimeout);
        this.clusters = new ClustersImpl(this.root, this.auth, readTimeoutMs);
        this.brokers = new BrokersImpl(this.root, this.auth, readTimeoutMs);
        this.brokerStats = new BrokerStatsImpl(this.root, this.auth, readTimeoutMs);
        this.tenants = new TenantsImpl(this.root, this.auth, readTimeoutMs);
        this.properties = new TenantsImpl(this.root, this.auth, readTimeoutMs);
        this.namespaces = new NamespacesImpl(this.root, this.auth, readTimeoutMs);
        this.topics = new TopicsImpl(this.root, this.auth, readTimeoutMs);
        this.nonPersistentTopics = new NonPersistentTopicsImpl(this.root, this.auth, readTimeoutMs);
        this.resourceQuotas = new ResourceQuotasImpl(this.root, this.auth, readTimeoutMs);
        this.lookups = new LookupImpl(this.root, this.auth, useTls, readTimeoutMs);
        this.functions = new FunctionsImpl(this.root, this.auth, this.httpAsyncClient, readTimeoutMs);
        this.sources = new SourcesImpl(this.root, this.auth, this.httpAsyncClient, readTimeoutMs);
        this.sinks = new SinksImpl(this.root, this.auth, this.httpAsyncClient, readTimeoutMs);
        this.worker = new WorkerImpl(this.root, this.auth, readTimeoutMs);
        this.schemas = new SchemasImpl(this.root, this.auth, readTimeoutMs);
        this.bookies = new BookiesImpl(this.root, this.auth, readTimeoutMs);
    }

    @Deprecated
    public PulsarAdmin(URL serviceUrl, Authentication auth) throws PulsarClientException {
        this(serviceUrl.toString(), PulsarAdmin.getConfigData(auth));
    }

    private static ClientConfigurationData getConfigData(Authentication auth) {
        ClientConfigurationData conf = new ClientConfigurationData();
        conf.setAuthentication(auth);
        return conf;
    }

    @Deprecated
    public PulsarAdmin(URL serviceUrl, String authPluginClassName, String authParamsString) throws PulsarClientException {
        this(serviceUrl, AuthenticationFactory.create((String)authPluginClassName, (String)authParamsString));
    }

    @Deprecated
    public PulsarAdmin(URL serviceUrl, String authPluginClassName, Map<String, String> authParams) throws PulsarClientException {
        this(serviceUrl, AuthenticationFactory.create((String)authPluginClassName, authParams));
    }

    public Clusters clusters() {
        return this.clusters;
    }

    public Brokers brokers() {
        return this.brokers;
    }

    public Tenants tenants() {
        return this.tenants;
    }

    @Deprecated
    public Properties properties() {
        return this.properties;
    }

    public Namespaces namespaces() {
        return this.namespaces;
    }

    public Topics topics() {
        return this.topics;
    }

    public Bookies bookies() {
        return this.bookies;
    }

    @Deprecated
    public NonPersistentTopics nonPersistentTopics() {
        return this.nonPersistentTopics;
    }

    public ResourceQuotas resourceQuotas() {
        return this.resourceQuotas;
    }

    public Lookup lookups() {
        return this.lookups;
    }

    public Functions functions() {
        return this.functions;
    }

    @Deprecated
    public Source source() {
        return (Source)this.sources;
    }

    public Sources sources() {
        return this.sources;
    }

    @Deprecated
    public Sink sink() {
        return (Sink)this.sinks;
    }

    public Sinks sinks() {
        return this.sinks;
    }

    public Worker worker() {
        return this.worker;
    }

    public BrokerStats brokerStats() {
        return this.brokerStats;
    }

    public String getServiceUrl() {
        return this.serviceUrl;
    }

    public ClientConfigurationData getClientConfigData() {
        return this.clientConfigData;
    }

    public Schemas schemas() {
        return this.schemas;
    }

    @Override
    public void close() {
        try {
            if (this.auth != null) {
                this.auth.close();
            }
        }
        catch (IOException e) {
            LOG.error("Failed to close the authentication service", (Throwable)e);
        }
        this.client.close();
        try {
            this.httpAsyncClient.close();
        }
        catch (IOException e) {
            LOG.error("Failed to close http async client", (Throwable)e);
        }
    }

    static {
        try {
            Class.forName("org.slf4j.impl.JDK14LoggerFactory");
        }
        catch (Exception ex) {
            SLF4JBridgeHandler.removeHandlersForRootLogger();
            SLF4JBridgeHandler.install();
        }
    }
}

