/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.common.api.raw;

import com.scurrilous.circe.checksum.Crc32cIntChecksum;
import java.io.IOException;
import org.apache.pulsar.common.api.proto.PulsarApi;
import org.apache.pulsar.common.api.raw.RawMessage;
import org.apache.pulsar.common.api.raw.RawMessageImpl;
import org.apache.pulsar.common.api.raw.ReferenceCountedObject;
import org.apache.pulsar.common.compression.CompressionCodec;
import org.apache.pulsar.common.compression.CompressionCodecProvider;
import org.apache.pulsar.common.naming.TopicName;
import org.apache.pulsar.common.protocol.Commands;
import org.apache.pulsar.shade.io.netty.buffer.ByteBuf;
import org.apache.pulsar.shade.io.netty.util.ReferenceCountUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class MessageParser {
    private static final Logger log = LoggerFactory.getLogger(MessageParser.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void parseMessage(TopicName topicName, long ledgerId, long entryId, ByteBuf headersAndPayload, MessageProcessor processor, int maxMessageSize) throws IOException {
        ReferenceCountedObject<PulsarApi.MessageMetadata> refCntMsgMetadata;
        ByteBuf uncompressedPayload;
        block13: {
            PulsarApi.MessageMetadata msgMetadata;
            block12: {
                block11: {
                    ByteBuf payload;
                    block10: {
                        msgMetadata = null;
                        payload = headersAndPayload;
                        uncompressedPayload = null;
                        refCntMsgMetadata = null;
                        try {
                            if (MessageParser.verifyChecksum(topicName, headersAndPayload, ledgerId, entryId)) break block10;
                        }
                        catch (Throwable throwable) {
                            ReferenceCountUtil.safeRelease(uncompressedPayload);
                            ReferenceCountUtil.safeRelease(refCntMsgMetadata);
                            throw throwable;
                        }
                        ReferenceCountUtil.safeRelease(uncompressedPayload);
                        ReferenceCountUtil.safeRelease(refCntMsgMetadata);
                        return;
                    }
                    try {
                        msgMetadata = Commands.parseMessageMetadata(payload);
                    }
                    catch (Throwable t) {
                        log.warn("[{}] Failed to deserialize metadata for message {}:{} - Ignoring", new Object[]{topicName, ledgerId, entryId});
                        ReferenceCountUtil.safeRelease(uncompressedPayload);
                        ReferenceCountUtil.safeRelease(refCntMsgMetadata);
                        return;
                    }
                    if (!msgMetadata.hasMarkerType()) break block11;
                    ReferenceCountUtil.safeRelease(uncompressedPayload);
                    ReferenceCountUtil.safeRelease(refCntMsgMetadata);
                    return;
                }
                if (msgMetadata.getEncryptionKeysCount() > 0) {
                    throw new IOException("Cannot parse encrypted message " + msgMetadata + " on topic " + topicName);
                }
                uncompressedPayload = MessageParser.uncompressPayloadIfNeeded(topicName, msgMetadata, headersAndPayload, ledgerId, entryId, maxMessageSize);
                if (uncompressedPayload != null) break block12;
                ReferenceCountUtil.safeRelease(uncompressedPayload);
                ReferenceCountUtil.safeRelease(refCntMsgMetadata);
                return;
            }
            int numMessages = msgMetadata.getNumMessagesInBatch();
            refCntMsgMetadata = new ReferenceCountedObject<PulsarApi.MessageMetadata>(msgMetadata, x -> x.recycle());
            if (numMessages == 1 && !msgMetadata.hasNumMessagesInBatch()) {
                processor.process(RawMessageImpl.get(refCntMsgMetadata, null, uncompressedPayload.retain(), ledgerId, entryId, 0L));
                break block13;
            }
            MessageParser.receiveIndividualMessagesFromBatch(refCntMsgMetadata, uncompressedPayload, ledgerId, entryId, processor);
        }
        ReferenceCountUtil.safeRelease(uncompressedPayload);
        ReferenceCountUtil.safeRelease(refCntMsgMetadata);
    }

    public static boolean verifyChecksum(TopicName topic, ByteBuf headersAndPayload, long ledgerId, long entryId) {
        int computedChecksum;
        int checksum;
        if (Commands.hasChecksum(headersAndPayload) && (checksum = Commands.readChecksum(headersAndPayload)) != (computedChecksum = Crc32cIntChecksum.computeChecksum(headersAndPayload))) {
            log.error("[{}] Checksum mismatch for message at {}:{}. Received checksum: 0x{}, Computed checksum: 0x{}", new Object[]{topic, ledgerId, entryId, Long.toHexString(checksum), Integer.toHexString(computedChecksum)});
            return false;
        }
        return true;
    }

    public static ByteBuf uncompressPayloadIfNeeded(TopicName topic, PulsarApi.MessageMetadata msgMetadata, ByteBuf payload, long ledgerId, long entryId, int maxMessageSize) {
        CompressionCodec codec = CompressionCodecProvider.getCompressionCodec(msgMetadata.getCompression());
        int uncompressedSize = msgMetadata.getUncompressedSize();
        int payloadSize = payload.readableBytes();
        if (payloadSize > maxMessageSize) {
            log.error("[{}] Got corrupted payload message size {} at {}:{}", new Object[]{topic, payloadSize, ledgerId, entryId});
            return null;
        }
        try {
            ByteBuf uncompressedPayload = codec.decode(payload, uncompressedSize);
            return uncompressedPayload;
        }
        catch (IOException e) {
            log.error("[{}] Failed to decompress message with {} at {}:{} : {}", new Object[]{topic, msgMetadata.getCompression(), ledgerId, entryId, e.getMessage(), e});
            return null;
        }
    }

    private static void receiveIndividualMessagesFromBatch(ReferenceCountedObject<PulsarApi.MessageMetadata> msgMetadata, ByteBuf uncompressedPayload, long ledgerId, long entryId, MessageProcessor processor) {
        int batchSize = msgMetadata.get().getNumMessagesInBatch();
        try {
            for (int i = 0; i < batchSize; ++i) {
                PulsarApi.SingleMessageMetadata.Builder singleMessageMetadataBuilder = PulsarApi.SingleMessageMetadata.newBuilder();
                ByteBuf singleMessagePayload = Commands.deSerializeSingleMessageInBatch(uncompressedPayload, singleMessageMetadataBuilder, i, batchSize);
                if (singleMessageMetadataBuilder.getCompactedOut()) {
                    singleMessagePayload.release();
                    singleMessageMetadataBuilder.recycle();
                    continue;
                }
                processor.process(RawMessageImpl.get(msgMetadata, singleMessageMetadataBuilder, singleMessagePayload, ledgerId, entryId, i));
            }
        }
        catch (IOException e) {
            log.warn("Unable to obtain messages in batch", (Throwable)e);
        }
    }

    private MessageParser() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    public static interface MessageProcessor {
        public void process(RawMessage var1);
    }
}

