/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.client.impl.schema.reader;

import java.io.IOException;
import org.apache.avro.Schema;
import org.apache.avro.io.BinaryDecoder;
import org.apache.avro.io.Decoder;
import org.apache.avro.io.DecoderFactory;
import org.apache.avro.reflect.ReflectDatumReader;
import org.apache.pulsar.client.api.SchemaSerializationException;
import org.apache.pulsar.client.api.schema.SchemaReader;

public class AvroReader<T>
implements SchemaReader<T> {
    private ReflectDatumReader<T> reader;
    private static final ThreadLocal<BinaryDecoder> decoders = new ThreadLocal();

    public AvroReader(Schema schema) {
        this.reader = new ReflectDatumReader(schema);
    }

    public AvroReader(Schema writerSchema, Schema readerSchema) {
        this.reader = new ReflectDatumReader(writerSchema, readerSchema);
    }

    public T read(byte[] bytes) {
        try {
            BinaryDecoder decoderFromCache = decoders.get();
            BinaryDecoder decoder = DecoderFactory.get().binaryDecoder(bytes, decoderFromCache);
            if (decoderFromCache == null) {
                decoders.set(decoder);
            }
            return (T)this.reader.read(null, (Decoder)DecoderFactory.get().binaryDecoder(bytes, decoder));
        }
        catch (IOException e) {
            throw new SchemaSerializationException((Throwable)e);
        }
    }
}

