/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.client.admin.internal;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.pulsar.client.admin.PulsarAdminException;
import org.apache.pulsar.client.admin.Worker;
import org.apache.pulsar.client.admin.internal.BaseResource;
import org.apache.pulsar.client.api.Authentication;
import org.apache.pulsar.common.functions.WorkerInfo;
import org.apache.pulsar.common.policies.data.WorkerFunctionInstanceStats;
import org.apache.pulsar.common.stats.Metrics;
import org.apache.pulsar.shade.javax.ws.rs.ClientErrorException;
import org.apache.pulsar.shade.javax.ws.rs.client.WebTarget;
import org.apache.pulsar.shade.javax.ws.rs.core.GenericType;
import org.apache.pulsar.shade.javax.ws.rs.core.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WorkerImpl
extends BaseResource
implements Worker {
    private static final Logger log = LoggerFactory.getLogger(WorkerImpl.class);
    private final WebTarget workerStats;
    private final WebTarget worker;

    public WorkerImpl(WebTarget web, Authentication auth, long readTimeoutMs) {
        super(auth, readTimeoutMs);
        this.worker = web.path("/admin/v2/worker");
        this.workerStats = web.path("/admin/v2/worker-stats");
    }

    @Override
    public List<WorkerFunctionInstanceStats> getFunctionsStats() throws PulsarAdminException {
        try {
            Response response = this.request(this.workerStats.path("functionsmetrics")).get();
            if (!response.getStatusInfo().equals(Response.Status.OK)) {
                throw new ClientErrorException(response);
            }
            List<WorkerFunctionInstanceStats> metricsList = response.readEntity(new GenericType<List<WorkerFunctionInstanceStats>>(){});
            return metricsList;
        }
        catch (Exception e) {
            throw this.getApiException(e);
        }
    }

    @Override
    public Collection<Metrics> getMetrics() throws PulsarAdminException {
        try {
            Response response = this.request(this.workerStats.path("metrics")).get();
            if (!response.getStatusInfo().equals(Response.Status.OK)) {
                throw new ClientErrorException(response);
            }
            return response.readEntity(new GenericType<List<Metrics>>(){});
        }
        catch (Exception e) {
            throw this.getApiException(e);
        }
    }

    @Override
    public List<WorkerInfo> getCluster() throws PulsarAdminException {
        try {
            Response response = this.request(this.worker.path("cluster")).get();
            if (!response.getStatusInfo().equals(Response.Status.OK)) {
                throw new ClientErrorException(response);
            }
            return response.readEntity(new GenericType<List<WorkerInfo>>(){});
        }
        catch (Exception e) {
            throw this.getApiException(e);
        }
    }

    @Override
    public WorkerInfo getClusterLeader() throws PulsarAdminException {
        try {
            Response response = this.request(this.worker.path("cluster").path("leader")).get();
            if (!response.getStatusInfo().equals(Response.Status.OK)) {
                throw new ClientErrorException(response);
            }
            return response.readEntity(new GenericType<WorkerInfo>(){});
        }
        catch (Exception e) {
            throw this.getApiException(e);
        }
    }

    @Override
    public Map<String, Collection<String>> getAssignments() throws PulsarAdminException {
        try {
            Response response = this.request(this.worker.path("assignments")).get();
            if (!response.getStatusInfo().equals(Response.Status.OK)) {
                throw new ClientErrorException(response);
            }
            Map<String, Collection<String>> assignments = response.readEntity(new GenericType<Map<String, Collection<String>>>(){});
            return assignments;
        }
        catch (Exception e) {
            throw this.getApiException(e);
        }
    }
}

